/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.util;

import io.github.projectet.ae2things.util.DataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class StorageManager
extends class_18 {
    private final Map<UUID, DataStorage> disks;

    public StorageManager() {
        this.disks = new HashMap<UUID, DataStorage>();
        this.method_80();
    }

    private StorageManager(Map<UUID, DataStorage> disks) {
        this.disks = disks;
        this.method_80();
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 diskList = new class_2499();
        for (Map.Entry<UUID, DataStorage> entry : this.disks.entrySet()) {
            class_2487 disk = new class_2487();
            disk.method_25927("diskuuid", entry.getKey());
            disk.method_10566("diskdata", (class_2520)entry.getValue().toNbt());
            diskList.add((Object)disk);
        }
        nbt.method_10566("disklist", (class_2520)diskList);
        return nbt;
    }

    public static StorageManager readNbt(class_2487 nbt) {
        HashMap<UUID, DataStorage> disks = new HashMap<UUID, DataStorage>();
        class_2499 diskList = nbt.method_10554("disklist", 10);
        for (int i = 0; i < diskList.size(); ++i) {
            class_2487 disk = diskList.method_10602(i);
            disks.put(disk.method_25926("diskuuid"), DataStorage.fromNbt(disk.method_10562("diskdata")));
        }
        return new StorageManager(disks);
    }

    public void updateDisk(UUID uuid, DataStorage dataStorage) {
        this.disks.put(uuid, dataStorage);
        this.method_80();
    }

    public void removeDisk(UUID uuid) {
        this.disks.remove(uuid);
        this.method_80();
    }

    public boolean hasUUID(UUID uuid) {
        return this.disks.containsKey(uuid);
    }

    public DataStorage getOrCreateDisk(UUID uuid) {
        if (!this.disks.containsKey(uuid)) {
            this.updateDisk(uuid, new DataStorage());
        }
        return this.disks.get(uuid);
    }

    public void modifyDisk(UUID diskID, class_2499 stackKeys, long[] stackAmounts, long itemCount) {
        DataStorage diskToModify = this.getOrCreateDisk(diskID);
        if (stackKeys != null && stackAmounts != null) {
            diskToModify.stackKeys = stackKeys;
            diskToModify.stackAmounts = stackAmounts;
        }
        diskToModify.itemCount = itemCount;
        this.updateDisk(diskID, diskToModify);
    }

    public static StorageManager getInstance(MinecraftServer server) {
        class_3218 world = server.method_3847(class_3218.field_25179);
        return (StorageManager)world.method_17983().method_17924(StorageManager::readNbt, StorageManager::new, "disk_manager");
    }
}

