/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.storage;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.item.DISKDrive;
import io.github.projectet.ae2things.storage.IDISKCellItem;
import io.github.projectet.ae2things.util.DataStorage;
import io.github.projectet.ae2things.util.StorageManager;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;

public class DISKCellInventory
implements StorageCell {
    private final IDISKCellItem cellType;
    public static final String ITEM_COUNT_TAG = "ic";
    public static final String STACK_KEYS = "keys";
    public static final String STACK_AMOUNTS = "amts";
    private final ISaveProvider container;
    private final AEKeyType keyType;
    private IPartitionList partitionList;
    private IncludeExclude partitionListMode;
    private int storedItems;
    private long storedItemCount;
    private Object2LongMap<AEKey> storedAmounts;
    private final class_1799 i;
    private boolean isPersisted = true;

    public DISKCellInventory(IDISKCellItem cellType, class_1799 stack, ISaveProvider saveProvider) {
        this.cellType = cellType;
        this.i = stack;
        this.container = saveProvider;
        this.keyType = cellType.getKeyType();
        this.storedAmounts = null;
        this.initData();
        this.updateFilter();
    }

    private void updateFilter() {
        IPartitionList.Builder builder = IPartitionList.builder();
        IUpgradeInventory upgrades = this.getUpgradesInventory();
        ConfigInventory config = this.getConfigInventory();
        boolean hasInverter = upgrades.isInstalled((class_1935)AEItems.INVERTER_CARD);
        if (upgrades.isInstalled((class_1935)AEItems.FUZZY_CARD)) {
            builder.fuzzyMode(this.getFuzzyMode());
        }
        builder.addAll((Iterable)config.keySet());
        this.partitionListMode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        this.partitionList = builder.build();
    }

    private DataStorage getDiskStorage() {
        if (this.getDiskUUID() != null) {
            return this.getStorageInstance().getOrCreateDisk(this.getDiskUUID());
        }
        return DataStorage.EMPTY;
    }

    private void initData() {
        if (this.hasDiskUUID()) {
            this.storedItems = this.getDiskStorage().stackAmounts.length;
            this.storedItemCount = this.getDiskStorage().itemCount;
        } else {
            this.storedItems = 0;
            this.storedItemCount = 0L;
            this.getCellItems();
        }
    }

    public IncludeExclude getPartitionListMode() {
        return this.partitionListMode;
    }

    public boolean isPreformatted() {
        return !this.partitionList.isEmpty();
    }

    public boolean isFuzzy() {
        return this.partitionList instanceof FuzzyPriorityList;
    }

    public ConfigInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.i);
    }

    public FuzzyMode getFuzzyMode() {
        return this.cellType.getFuzzyMode(this.i);
    }

    public IUpgradeInventory getUpgradesInventory() {
        return this.cellType.getUpgrades(this.i);
    }

    public CellState getStatus() {
        if (this.getStoredItemCount() == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    public CellState getClientStatus() {
        if (this.getNbtItemCount() == 0L) {
            return CellState.EMPTY;
        }
        if (this.getNbtItemCount() > 0L && this.getNbtItemCount() != this.getTotalBytes()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedItemCount == 0L) {
            if (this.hasDiskUUID()) {
                this.getStorageInstance().removeDisk(this.getDiskUUID());
                this.i.method_7969().method_10551("diskuuid");
                this.i.method_7969().method_10551(ITEM_COUNT_TAG);
                this.initData();
            }
            return;
        }
        long itemCount = 0L;
        LongArrayList amounts = new LongArrayList(this.storedAmounts.size());
        class_2499 keys = new class_2499();
        for (Object2LongMap.Entry entry : this.storedAmounts.object2LongEntrySet()) {
            long amount = entry.getLongValue();
            if (amount <= 0L) continue;
            itemCount += amount;
            keys.add((Object)((AEKey)entry.getKey()).toTagGeneric());
            amounts.add(amount);
        }
        if (keys.isEmpty()) {
            this.getStorageInstance().updateDisk(this.getDiskUUID(), new DataStorage());
        } else {
            this.getStorageInstance().modifyDisk(this.getDiskUUID(), keys, amounts.toArray(new long[0]), itemCount);
        }
        this.storedItems = (short)this.storedAmounts.size();
        this.storedItemCount = itemCount;
        this.i.method_7948().method_10544(ITEM_COUNT_TAG, itemCount);
        this.isPersisted = true;
    }

    public class_2561 getDescription() {
        return null;
    }

    public static DISKCellInventory createInventory(class_1799 stack, ISaveProvider saveProvider) {
        Objects.requireNonNull(stack, "Cannot create cell inventory for null itemstack");
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IDISKCellItem)) {
            return null;
        }
        IDISKCellItem cellType = (IDISKCellItem)class_17922;
        if (!cellType.isStorageCell(stack)) {
            return null;
        }
        return new DISKCellInventory(cellType, stack, saveProvider);
    }

    public boolean hasDiskUUID() {
        return this.i.method_7985() && this.i.method_7948().method_10545("diskuuid");
    }

    public static boolean hasDiskUUID(class_1799 disk) {
        if (disk.method_7909() instanceof IDISKCellItem) {
            return disk.method_7985() && disk.method_7948().method_10545("diskuuid");
        }
        return false;
    }

    public UUID getDiskUUID() {
        if (this.hasDiskUUID()) {
            return this.i.method_7948().method_25926("diskuuid");
        }
        return null;
    }

    private boolean isStorageCell(AEItemKey key) {
        DISKDrive type = DISKCellInventory.getStorageCell(key);
        return type != null && !type.storableInStorageCell();
    }

    private static DISKDrive getStorageCell(AEItemKey itemKey) {
        class_1792 class_17922 = itemKey.getItem();
        if (class_17922 instanceof DISKDrive) {
            DISKDrive diskDrive = (DISKDrive)class_17922;
            return diskDrive;
        }
        return null;
    }

    private static boolean isCellEmpty(DISKCellInventory inv) {
        if (inv != null) {
            return inv.getAvailableStacks().isEmpty();
        }
        return true;
    }

    protected Object2LongMap<AEKey> getCellItems() {
        if (this.storedAmounts == null) {
            this.storedAmounts = new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.storedAmounts;
    }

    public void getAvailableStacks(KeyCounter out) {
        for (Object2LongMap.Entry entry : this.getCellItems().object2LongEntrySet()) {
            out.add((AEKey)entry.getKey(), entry.getLongValue());
        }
    }

    private void loadCellItems() {
        boolean corruptedTag = false;
        if (!this.i.method_7985()) {
            return;
        }
        long[] amounts = this.getDiskStorage().stackAmounts;
        class_2499 tags = this.getDiskStorage().stackKeys;
        if (amounts.length != tags.size()) {
            AELog.warn((String)"Loading storage cell with mismatched amounts/tags: %d != %d", (Object[])new Object[]{amounts.length, tags.size()});
        }
        for (int i = 0; i < amounts.length; ++i) {
            long amount = amounts[i];
            AEKey key = AEKey.fromTagGeneric((class_2487)tags.method_10602(i));
            if (amount <= 0L || key == null) {
                corruptedTag = true;
                continue;
            }
            this.storedAmounts.put((Object)key, amount);
        }
        if (corruptedTag) {
            this.saveChanges();
        }
    }

    private StorageManager getStorageInstance() {
        return AE2Things.STORAGE_INSTANCE;
    }

    protected void saveChanges() {
        this.storedItems = this.storedAmounts.size();
        this.storedItemCount = 0L;
        for (Long storedAmount : this.storedAmounts.values()) {
            this.storedItemCount += storedAmount.longValue();
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long getRemainingItemCount() {
        return this.getFreeBytes() > 0L ? this.getFreeBytes() : 0L;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        DISKCellInventory meInventory;
        AEItemKey itemKey;
        if (amount == 0L || !this.keyType.contains(what)) {
            return 0L;
        }
        if (!this.partitionList.isEmpty() && !this.partitionList.isListed(what)) {
            return 0L;
        }
        if (this.cellType.isBlackListed(this.i, what)) {
            return 0L;
        }
        if (what instanceof AEItemKey && this.isStorageCell(itemKey = (AEItemKey)what) && !DISKCellInventory.isCellEmpty(meInventory = DISKCellInventory.createInventory(itemKey.toStack(), null))) {
            return 0L;
        }
        if (!this.hasDiskUUID()) {
            this.i.method_7948().method_25927("diskuuid", UUID.randomUUID());
            this.getStorageInstance().getOrCreateDisk(this.getDiskUUID());
            this.loadCellItems();
        }
        long currentAmount = this.getCellItems().getLong((Object)what);
        long remainingItemCount = this.getRemainingItemCount();
        if (amount > remainingItemCount) {
            amount = remainingItemCount;
        }
        if (mode == Actionable.MODULATE) {
            this.getCellItems().put((Object)what, currentAmount + amount);
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentAmount = this.getCellItems().getLong((Object)what);
        if (currentAmount > 0L) {
            if (extractAmount >= currentAmount) {
                if (mode == Actionable.MODULATE) {
                    this.getCellItems().remove((Object)what, currentAmount);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                this.getCellItems().put((Object)what, currentAmount - extractAmount);
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    public long getTotalBytes() {
        return this.cellType.getBytes(this.i);
    }

    public long getFreeBytes() {
        return this.getTotalBytes() - this.getStoredItemCount();
    }

    public long getNbtItemCount() {
        if (this.hasDiskUUID()) {
            return this.i.method_7969().method_10537(ITEM_COUNT_TAG);
        }
        return 0L;
    }

    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    public long getStoredItemTypes() {
        return this.storedItems;
    }

    public boolean canHoldNewItem() {
        return this.getFreeBytes() > 0L && this.getFreeBytes() != this.getTotalBytes();
    }
}

