/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.block.entity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.items.misc.CrystalSeedItem;
import appeng.me.helpers.MachineSource;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.inventory.CrystalGrowthSlot;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class BECrystalGrowth
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject {
    private final AppEngInternalInventory inventory = new AppEngInternalInventory((InternalInventoryHost)this, 27);
    private final InternalInventory extInventory;
    private IUpgradeInventory upgrades;
    private boolean isWorking;
    private final Set<Integer> cachedGrowable = new HashSet<Integer>();

    public BECrystalGrowth(class_2338 pos, class_2680 state) {
        super(AE2Things.CRYSTAL_GROWTH_BE, pos, state);
        this.upgrades = UpgradeInventories.forMachine((class_1935)AE2Things.CRYSTAL_GROWTH, (int)3, () -> ((BECrystalGrowth)this).saveChanges());
        FilteredInventory filter = new FilteredInventory();
        this.extInventory = new FilteredInternalInventory((InternalInventory)this.inventory, (IAEItemFilter)filter);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class)).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(1600.0);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber, !this.hasWork(), true);
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public boolean hasWork() {
        return this.hasFluixIngredients() || !this.cachedGrowable.isEmpty();
    }

    private boolean hasFluixIngredients() {
        Storage inv = this.inventory.toStorage();
        try (Transaction transaction = Transaction.openOuter();){
            boolean hasRedstone = inv.simulateExtract((Object)ItemVariant.of((class_1935)class_1802.field_8725), 1L, (TransactionContext)transaction) == 1L;
            boolean hasChargedCertus = inv.simulateExtract((Object)ItemVariant.of((class_1935)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.method_8389()), 1L, (TransactionContext)transaction) == 1L;
            boolean hasQuartz = inv.simulateExtract((Object)ItemVariant.of((class_1935)class_1802.field_8155), 1L, (TransactionContext)transaction) == 1L;
            transaction.commit();
            boolean bl = hasRedstone && hasChargedCertus && hasQuartz;
            return bl;
        }
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.hasWork()) {
            int speedFactor = 1 + this.upgrades.getInstalledUpgrades((class_1935)AEItems.SPEED_CARD);
            IEnergyService[] eg = new IEnergyService[1];
            BECrystalGrowth src = this;
            this.getMainNode().ifPresent(iGrid -> {
                eg[0] = iGrid.getEnergyService();
            });
            if (eg[0] == null) {
                return TickRateModulation.IDLE;
            }
            int powerConsumption = 10 * speedFactor;
            double powerThreshold = (double)powerConsumption - 0.01;
            double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            if (powerReq <= powerThreshold) {
                src = eg[0];
                powerReq = eg[0].extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            }
            if (powerReq > powerThreshold) {
                if (!this.isWorking()) {
                    this.isWorking = true;
                    this.markForUpdate();
                }
            } else {
                if (this.isWorking()) {
                    this.isWorking = false;
                    this.markForUpdate();
                }
                return TickRateModulation.IDLE;
            }
            src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
            for (Integer slot : this.cachedGrowable.stream().toList()) {
                class_1799 crystal = this.inventory.getStackInSlot(slot.intValue());
                if (!(crystal.method_7909() instanceof IGrowableCrystal)) {
                    this.cachedGrowable.remove(slot);
                    continue;
                }
                this.inventory.setItemDirect(slot.intValue(), this.triggerGrowth(crystal, 20, speedFactor));
                this.saveChanges();
            }
            if (this.hasFluixIngredients()) {
                try (Transaction context = Transaction.openOuter();){
                    int redstone = this.inventory.removeItems(1, new class_1799((class_1935)class_1802.field_8725), null).method_7947();
                    int chargedCertus = this.inventory.removeItems(1, new class_1799((class_1935)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.method_8389()), null).method_7947();
                    int quartz = this.inventory.removeItems(1, new class_1799((class_1935)class_1802.field_8155), null).method_7947();
                    this.inventory.addItems(new class_1799((class_1935)AEItems.FLUIX_DUST, 2));
                    if (redstone == 1 && chargedCertus == 1 && quartz == 1) {
                        context.commit();
                        this.saveChanges();
                    }
                }
            }
            if (this.cachedGrowable.isEmpty() && !this.hasFluixIngredients()) {
                this.isWorking = false;
                this.markForUpdate();
            }
        }
        if (!this.inventory.isEmpty()) {
            MEStorage gridStorage = this.getMainNode().getGrid().getStorageService().getInventory();
            for (class_1799 stack : this.inventory) {
                if (stack.equals(class_1799.field_8037) || stack.method_7909().equals(class_1802.field_8162) || FilteredInventory.canTransfer(stack.method_7909())) continue;
                AEItemKey item = AEItemKey.of((class_1799)stack);
                long inserted = gridStorage.insert((AEKey)item, (long)stack.method_7947(), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
                stack.method_7934((int)inserted);
            }
        }
        return this.hasWork() ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        this.setPowerSides(EnumSet.allOf(class_2350.class));
    }

    public void onReady() {
        this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class));
        super.onReady();
    }

    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.setItemDirect(i, data.method_10819());
        }
        return c;
    }

    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        for (int i = 0; i < this.inventory.size(); ++i) {
            data.method_10793(this.inventory.getStackInSlot(i));
        }
    }

    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.upgrades.writeToNBT(data, "upgrades");
        data.method_10572("cache", this.cachedGrowable.stream().toList());
        data.method_10556("working", this.isWorking);
    }

    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.cachedGrowable.addAll(Arrays.stream(data.method_10561("cache")).boxed().toList());
        this.isWorking = data.method_10577("working");
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public InternalInventory getInternalInventory() {
        return this.inventory;
    }

    public InternalInventory getExposedInventoryForSide(class_2350 side) {
        return this.extInventory;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv.getStackInSlot(slot).method_7909() instanceof IGrowableCrystal) {
            this.cachedGrowable.add(slot);
        }
        this.markForUpdate();
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public class_1799 triggerGrowth(class_1799 seedItem, int ticks, int multiplier) {
        class_1792 class_17922 = seedItem.method_7909();
        if (class_17922 instanceof CrystalSeedItem) {
            CrystalSeedItem crystalSeedItem = (CrystalSeedItem)class_17922;
            int growthTicks = CrystalSeedItem.getGrowthTicks((class_1799)seedItem) + ticks * multiplier;
            CrystalSeedItem.setGrowthTicks((class_1799)seedItem, (int)growthTicks);
            if (CrystalSeedItem.getGrowthTicks((class_1799)seedItem) >= 24000) {
                return crystalSeedItem.triggerGrowth(seedItem);
            }
        }
        return seedItem;
    }

    public class FilteredInventory
    implements IAEItemFilter {
        public static boolean canTransfer(class_1792 item) {
            return CrystalGrowthSlot.validItems.contains(item) || item instanceof CrystalSeedItem;
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return !FilteredInventory.canTransfer(inv.getStackInSlot(slot).method_7909());
        }

        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return FilteredInventory.canTransfer(stack.method_7909());
        }
    }
}

