/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.block.entity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.blockentity.misc.InscriberRecipes;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.me.helpers.MachineSource;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import io.github.projectet.ae2things.AE2Things;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class BEAdvancedInscriber
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject {
    private final AppEngInternalInventory topItemHandler = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final AppEngInternalInventory botItemHandler = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final AppEngInternalInventory sideItemHandler = new AppEngInternalInventory((InternalInventoryHost)this, 2, 64);
    private final InternalInventory topItemHandlerExtern;
    private final InternalInventory botItemHandlerExtern;
    private final InternalInventory sideItemHandlerExtern;
    private final InternalInventory combinedExtInventory;
    private int finalStep;
    private final InternalInventory inv = new CombinedInternalInventory(new InternalInventory[]{this.topItemHandler, this.botItemHandler, this.sideItemHandler});
    private final IUpgradeInventory upgrades = UpgradeInventories.forMachine((class_1935)AE2Things.ADVANCED_INSCRIBER, (int)5, () -> ((BEAdvancedInscriber)this).saveChanges());
    private InscriberRecipe cachedTask;
    private int processingTime = 0;
    private final int maxProcessingTime = 100;
    private boolean smash;
    private long clientStart;

    public BEAdvancedInscriber(class_2338 pos, class_2680 state) {
        super(AE2Things.ADVANCED_INSCRIBER_BE, pos, state);
        this.sideItemHandler.setMaxStackSize(1, 64);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class)).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(1600.0);
        FilteredInventory filter = new FilteredInventory();
        this.topItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.topItemHandler, (IAEItemFilter)filter);
        this.botItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.botItemHandler, (IAEItemFilter)filter);
        this.sideItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.sideItemHandler, (IAEItemFilter)filter);
        this.combinedExtInventory = new CombinedInternalInventory(new InternalInventory[]{this.topItemHandlerExtern, this.botItemHandlerExtern, this.sideItemHandlerExtern});
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public InternalInventory getExposedInventoryForSide(class_2350 facing) {
        return this.combinedExtInventory;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (slot == 0) {
            this.setProcessingTime(0);
        }
        if (!this.isSmash()) {
            this.markForUpdate();
        }
        this.cachedTask = null;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        this.setPowerSides(EnumSet.allOf(class_2350.class));
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public void onReady() {
        this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class));
        super.onReady();
    }

    private void setClientStart(long clientStart) {
        this.clientStart = clientStart;
    }

    protected boolean readFromStream(class_2540 data) {
        boolean newSmash;
        boolean c = super.readFromStream(data);
        boolean oldSmash = this.isSmash();
        if (oldSmash != (newSmash = data.readBoolean()) && newSmash) {
            this.setSmash(true);
            this.setClientStart(System.currentTimeMillis());
        }
        for (int i = 0; i < this.inv.size(); ++i) {
            this.inv.setItemDirect(i, data.method_10819());
        }
        this.cachedTask = null;
        return c;
    }

    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.isSmash());
        for (int i = 0; i < this.inv.size(); ++i) {
            data.method_10793(this.inv.getStackInSlot(i));
        }
    }

    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    public boolean isSmash() {
        return this.smash;
    }

    @Nullable
    public InscriberRecipe getTask() {
        if (this.cachedTask == null && this.field_11863 != null) {
            class_1799 input = this.sideItemHandler.getStackInSlot(0);
            class_1799 plateA = this.topItemHandler.getStackInSlot(0);
            class_1799 plateB = this.botItemHandler.getStackInSlot(0);
            if (input.method_7960()) {
                return null;
            }
            this.cachedTask = InscriberRecipes.findRecipe((class_1937)this.field_11863, (class_1799)input, (class_1799)plateA, (class_1799)plateB, (boolean)true);
        }
        return this.cachedTask;
    }

    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.upgrades.writeToNBT(data, "upgrades");
    }

    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    private boolean hasWork() {
        if (this.getTask() != null) {
            return true;
        }
        this.setProcessingTime(0);
        return this.isSmash();
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber, !this.hasWork(), false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSmash()) {
            ++this.finalStep;
            if (this.finalStep == 8) {
                InscriberRecipe out = this.getTask();
                if (out != null) {
                    class_1799 outputCopy = out.method_8110().method_7972();
                    if (this.sideItemHandler.insertItem(1, outputCopy, false).method_7960()) {
                        this.setProcessingTime(0);
                        if (out.getProcessType() == InscriberProcessType.PRESS) {
                            this.topItemHandler.extractItem(0, 1, false);
                            this.botItemHandler.extractItem(0, 1, false);
                        }
                        this.sideItemHandler.extractItem(0, 1, false);
                    }
                    if (this.sideItemHandler.getStackInSlot(1).method_7909() != class_1802.field_8162) {
                        class_1799 outStack = this.sideItemHandler.getStackInSlot(1);
                        AEItemKey itemKey = AEItemKey.of((class_1799)outStack);
                        long inserted = this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)itemKey, (long)outStack.method_7947(), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
                        this.sideItemHandler.extractItem(1, (int)inserted, false);
                    }
                }
                this.saveChanges();
            } else if (this.finalStep == 16) {
                this.finalStep = 0;
                this.setSmash(false);
                this.markForUpdate();
            }
        } else {
            this.getMainNode().ifPresent(grid -> {
                IEnergyService eg = grid.getEnergyService();
                BEAdvancedInscriber src = this;
                int speedFactor = 1 + this.upgrades.getInstalledUpgrades((class_1935)AEItems.SPEED_CARD);
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    if (this.getProcessingTime() == 0) {
                        this.setProcessingTime(this.getProcessingTime() + speedFactor);
                    } else {
                        this.setProcessingTime(this.getProcessingTime() + ticksSinceLastCall * speedFactor);
                    }
                }
            });
            if (this.getProcessingTime() > this.getMaxProcessingTime()) {
                class_1799 outputCopy;
                this.setProcessingTime(this.getMaxProcessingTime());
                InscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.method_8110().method_7972(), true).method_7960()) {
                    this.setSmash(true);
                    this.finalStep = 0;
                    this.markForUpdate();
                }
            }
        }
        return this.hasWork() ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    public int getMaxProcessingTime() {
        return 100;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public void setSmash(boolean smash) {
        this.smash = smash;
    }

    public class FilteredInventory
    implements IAEItemFilter {
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            if (BEAdvancedInscriber.this.isSmash()) {
                return false;
            }
            return slot == 1;
        }

        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            if (slot == 1) {
                return false;
            }
            if (BEAdvancedInscriber.this.isSmash()) {
                return false;
            }
            if (inv == BEAdvancedInscriber.this.topItemHandler || inv == BEAdvancedInscriber.this.botItemHandler) {
                if (AEItems.NAME_PRESS.isSameAs(stack)) {
                    return true;
                }
                return InscriberRecipes.isValidOptionalIngredient((class_1937)BEAdvancedInscriber.this.method_10997(), (class_1799)stack);
            }
            return true;
        }
    }
}

