/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.staticdata;

import com.google.common.collect.ImmutableSet;
import io.github.cottonmc.staticdata.StaticDataItem;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;

@ParametersAreNonnullByDefault
public class StaticData {
    public static final String GLOBAL_DATA_NAMESPACE = "g";

    @Nonnull
    public static ImmutableSet<StaticDataItem> getAll() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            Path staticDataPath = container.getRootPath().resolve("static_data");
            if (!Files.isDirectory(staticDataPath, new LinkOption[0])) continue;
            try {
                Stream<Path> files = Files.walk(staticDataPath, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    files.forEach(it -> {
                        if (Files.isDirectory(it, new LinkOption[0])) {
                            return;
                        }
                        builder.add((Object)new StaticDataItem(StaticData.toIdentifier(container, it), (Path)it));
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (files == null) continue;
                    if (throwable != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    files.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Path globalStaticDataFolder = new File(FabricLoader.getInstance().getGameDirectory(), "static_data").toPath();
        if (Files.isDirectory(globalStaticDataFolder, new LinkOption[0])) {
            try (Stream<Path> files = Files.walk(globalStaticDataFolder, new FileVisitOption[0]);){
                files.forEach(it -> {
                    if (Files.isDirectory(it, new LinkOption[0])) {
                        return;
                    }
                    builder.add((Object)new StaticDataItem(StaticData.toGlobalIdentifier(globalStaticDataFolder, it), (Path)it));
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return builder.build();
    }

    @Nonnull
    public static ImmutableSet<StaticDataItem> getAll(String name) {
        Path data;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            Path data2;
            Path staticDataPath = container.getRootPath().resolve("static_data");
            if (!Files.isDirectory(staticDataPath, new LinkOption[0]) || !Files.exists(data2 = staticDataPath.resolve(name), new LinkOption[0]) || Files.isDirectory(data2, new LinkOption[0])) continue;
            builder.add((Object)new StaticDataItem(StaticData.toIdentifier(container, data2), data2));
        }
        Path globalStaticDataFolder = new File(FabricLoader.getInstance().getGameDirectory(), "static_data").toPath();
        if (Files.isDirectory(globalStaticDataFolder, new LinkOption[0]) && Files.exists(data = globalStaticDataFolder.resolve(name), new LinkOption[0]) && !Files.isDirectory(data, new LinkOption[0])) {
            builder.add((Object)new StaticDataItem(StaticData.toGlobalIdentifier(globalStaticDataFolder, data), data));
        }
        return builder.build();
    }

    @Nonnull
    public static ImmutableSet<StaticDataItem> getAllInDirectory(String dirname) {
        Path datadir;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            Path datadir2;
            Path staticDataPath = container.getRootPath().resolve("static_data");
            if (!Files.isDirectory(staticDataPath, new LinkOption[0]) || !Files.isDirectory(datadir2 = staticDataPath.resolve(dirname), new LinkOption[0])) continue;
            try {
                Stream<Path> files = Files.walk(datadir2, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    files.forEach(it -> {
                        if (Files.isDirectory(it, new LinkOption[0])) {
                            return;
                        }
                        builder.add((Object)new StaticDataItem(StaticData.toIdentifier(container, it), (Path)it));
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (files == null) continue;
                    if (throwable != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    files.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Path globalStaticDataFolder = new File(FabricLoader.getInstance().getGameDirectory(), "static_data").toPath();
        if (Files.isDirectory(globalStaticDataFolder, new LinkOption[0]) && Files.isDirectory(datadir = globalStaticDataFolder.resolve(dirname), new LinkOption[0])) {
            try (Stream<Path> files = Files.walk(datadir, new FileVisitOption[0]);){
                files.forEach(it -> {
                    if (Files.isDirectory(it, new LinkOption[0])) {
                        return;
                    }
                    builder.add((Object)new StaticDataItem(StaticData.toGlobalIdentifier(globalStaticDataFolder, it), (Path)it));
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return builder.build();
    }

    @Nonnull
    public static Optional<StaticDataItem> get(String modid, String name) {
        if (modid.equals(GLOBAL_DATA_NAMESPACE)) {
            Path data;
            Path globalStaticDataFolder = new File(FabricLoader.getInstance().getGameDirectory(), "static_data").toPath();
            if (Files.isDirectory(globalStaticDataFolder, new LinkOption[0]) && Files.exists(data = globalStaticDataFolder.resolve(name), new LinkOption[0]) && !Files.isDirectory(data, new LinkOption[0])) {
                return Optional.of(new StaticDataItem(new class_2960(GLOBAL_DATA_NAMESPACE, name), data));
            }
            return Optional.empty();
        }
        Optional containerOpt = FabricLoader.getInstance().getModContainer(modid);
        if (!containerOpt.isPresent()) {
            return Optional.empty();
        }
        return containerOpt.map(container -> {
            Path data;
            Path staticDataPath = container.getRootPath().resolve("static_data");
            if (Files.isDirectory(staticDataPath, new LinkOption[0]) && Files.exists(data = staticDataPath.resolve(name), new LinkOption[0])) {
                return new StaticDataItem(StaticData.toIdentifier(container, data), data);
            }
            return null;
        });
    }

    @Nonnull
    public static Optional<StaticDataItem> get(class_2960 id) {
        return StaticData.get(id.method_12836(), id.method_12832());
    }

    @Nonnull
    public static ImmutableSet<StaticDataItem> getInDirectory(String modid, String dirname) {
        Path datadir;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (modid.equals(GLOBAL_DATA_NAMESPACE)) {
            Path datadir2;
            Path globalStaticDataFolder = new File(FabricLoader.getInstance().getGameDirectory(), "static_data").toPath();
            if (Files.isDirectory(globalStaticDataFolder, new LinkOption[0]) && Files.isDirectory(datadir2 = globalStaticDataFolder.resolve(dirname), new LinkOption[0])) {
                try (Stream<Path> files = Files.walk(datadir2, new FileVisitOption[0]);){
                    files.forEach(it -> {
                        if (Files.isDirectory(it, new LinkOption[0])) {
                            return;
                        }
                        builder.add((Object)new StaticDataItem(StaticData.toGlobalIdentifier(globalStaticDataFolder, it), (Path)it));
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return builder.build();
        }
        Optional containerOpt = FabricLoader.getInstance().getModContainer(modid);
        if (!containerOpt.isPresent()) {
            return builder.build();
        }
        ModContainer container = (ModContainer)containerOpt.get();
        Path staticDataPath = container.getRootPath().resolve("static_data");
        if (Files.isDirectory(staticDataPath, new LinkOption[0]) && Files.isDirectory(datadir = staticDataPath.resolve(dirname), new LinkOption[0])) {
            try (Stream<Path> files = Files.walk(datadir, new FileVisitOption[0]);){
                files.forEach(it -> {
                    if (Files.isDirectory(it, new LinkOption[0])) {
                        return;
                    }
                    builder.add((Object)new StaticDataItem(StaticData.toIdentifier(container, it), (Path)it));
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return builder.build();
    }

    @Nonnull
    public static ImmutableSet<StaticDataItem> getInDirectory(class_2960 id) {
        return StaticData.getInDirectory(id.method_12836(), id.method_12832());
    }

    private static String getRelative(Path parent, Path child) {
        return parent.toAbsolutePath().relativize(child).toString().replace(File.separatorChar, '/').toLowerCase(Locale.ROOT).replace(' ', '_');
    }

    private static class_2960 toIdentifier(ModContainer container, Path path) {
        String rel = StaticData.getRelative(container.getRootPath(), path);
        if (rel.startsWith("static_data/")) {
            rel = rel.substring("static_data/".length());
        }
        return new class_2960(container.getMetadata().getId(), rel);
    }

    private static class_2960 toGlobalIdentifier(Path root, Path path) {
        return new class_2960(GLOBAL_DATA_NAMESPACE, StaticData.getRelative(root, path));
    }
}

