/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SelectImageScreen
extends ButtonListBaseScreen {
    private final ImageConfig imageConfig;
    private final ConfigCallback callback;
    private final List<class_2960> images;

    public SelectImageScreen(ImageConfig i, ConfigCallback c) {
        this.imageConfig = i;
        this.callback = c;
        this.setTitle((class_2561)new class_2585("Select Image"));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.images = new ArrayList<class_2960>();
        StringUtils.ignoreResourceLocationErrors = true;
        Collection<Object> textures = Collections.emptyList();
        try {
            textures = class_310.method_1551().method_1478().method_14488("textures", t -> t.endsWith(".png"));
        }
        catch (Exception ex) {
            FTBLibrary.LOGGER.error("A mod has broken resource preventing this list from loading: " + ex);
        }
        StringUtils.ignoreResourceLocationErrors = false;
        for (class_2960 class_29602 : textures) {
            if (!class_2960.method_20207((String)class_29602.toString())) {
                FTBLibrary.LOGGER.warn("Image " + class_29602 + " has invalid path! Report this to author of '" + class_29602.method_12836() + "'!");
                continue;
            }
            if (!this.isValidImage(class_29602)) continue;
            this.images.add(class_29602);
        }
        this.images.sort(null);
    }

    public boolean allowNone() {
        return true;
    }

    public boolean isValidImage(class_2960 id) {
        return !id.method_12832().startsWith("textures/font/");
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.allowNone()) {
            panel.add(new SimpleTextButton(panel, (class_2561)new class_2585("None"), Icon.EMPTY){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue("");
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
        for (final class_2960 res : this.images) {
            panel.add(new SimpleTextButton(panel, (class_2561)new class_2585("").method_10852((class_2561)new class_2585(res.method_12836()).method_27692(class_124.field_1065)).method_27693(":").method_10852((class_2561)new class_2585(res.method_12832().substring(9, res.method_12832().length() - 4)).method_27692(class_124.field_1054)), Icon.getIcon(res.toString())){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue(res.toString());
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }
}

