/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class ScrollBar
extends Widget {
    public final Plane plane;
    private final int scrollBarSize;
    private double value = 0.0;
    private double scrollStep = 20.0;
    private double grab = -10000.0;
    private double minValue = 0.0;
    private double maxValue = 100.0;
    private boolean canAlwaysScroll = false;
    private boolean canAlwaysScrollPlane = true;

    public ScrollBar(Panel parent, Plane p, int ss) {
        super(parent);
        this.plane = p;
        this.scrollBarSize = Math.max(ss, 0);
    }

    public void setCanAlwaysScroll(boolean v) {
        this.canAlwaysScroll = v;
    }

    public void setCanAlwaysScrollPlane(boolean v) {
        this.canAlwaysScrollPlane = v;
    }

    public void setMinValue(double min) {
        this.minValue = min;
        this.setValue(this.getValue());
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double max) {
        this.maxValue = max;
        this.setValue(this.getValue());
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setScrollStep(double s) {
        this.scrollStep = Math.max(0.0, s);
    }

    public int getScrollBarSize() {
        return this.scrollBarSize;
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            this.grab = this.plane.isVertical ? (double)this.getMouseY() - ((double)this.getY() + this.getMappedValue(this.height - this.getScrollBarSize())) : (double)this.getMouseX() - ((double)this.getX() + this.getMappedValue(this.width - this.getScrollBarSize()));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double scroll) {
        if (scroll != 0.0 && this.canMouseScrollPlane() && this.canMouseScroll()) {
            this.setValue(this.getValue() - this.getScrollStep() * scroll);
            return true;
        }
        return false;
    }

    @Override
    public void addMouseOverText(TooltipList list) {
        if (this.showValueOnMouseOver()) {
            class_2561 t = this.getTitle();
            list.string((String)(t == class_2585.field_24366 ? Double.toString(this.getValue()) : t + ": " + this.getValue()));
        }
        if (Theme.renderDebugBoxes) {
            list.styledString("Size: " + this.getScrollBarSize(), class_124.field_1063);
            list.styledString("Max: " + this.getMaxValue(), class_124.field_1063);
            list.styledString("Value: " + this.getValue(), class_124.field_1063);
        }
    }

    public boolean showValueOnMouseOver() {
        return false;
    }

    @Override
    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        int scrollBarSize = this.getScrollBarSize();
        if (scrollBarSize > 0) {
            double v = this.getValue();
            if (this.grab != -10000.0) {
                if (ScrollBar.isMouseButtonDown(MouseButton.LEFT)) {
                    v = this.plane.isVertical ? ((double)this.getMouseY() - ((double)y + this.grab)) * this.getMaxValue() / (double)(this.height - scrollBarSize) : ((double)this.getMouseX() - ((double)x + this.grab)) * this.getMaxValue() / (double)(this.width - scrollBarSize);
                } else {
                    this.grab = -10000.0;
                }
            }
            this.setValue(v);
        }
        this.drawBackground(matrixStack, theme, x, y, this.width, this.height);
        if (scrollBarSize > 0) {
            if (this.plane.isVertical) {
                this.drawScrollBar(matrixStack, theme, x, (int)((double)y + this.getMappedValue(this.height - scrollBarSize)), this.width, scrollBarSize);
            } else {
                this.drawScrollBar(matrixStack, theme, (int)((double)x + this.getMappedValue(this.width - scrollBarSize)), y, scrollBarSize, this.height);
            }
        }
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawScrollBarBackground(matrixStack, x, y, w, h, this.getWidgetType());
    }

    public void drawScrollBar(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawScrollBar(matrixStack, x, y, w, h, WidgetType.mouseOver(this.grab != -10000.0), this.plane.isVertical);
    }

    public void onMoved() {
    }

    public boolean canMouseScrollPlane() {
        return this.canAlwaysScrollPlane || ScrollBar.isShiftKeyDown() != this.plane.isVertical;
    }

    public boolean canMouseScroll() {
        return this.canAlwaysScroll || this.isMouseOver();
    }

    public void setValue(double v) {
        if (this.value != (v = class_3532.method_15350((double)v, (double)this.getMinValue(), (double)this.getMaxValue()))) {
            this.value = v;
            this.onMoved();
        }
    }

    public double getValue() {
        return this.value;
    }

    public double getMappedValue(double max) {
        return MathUtils.map(this.getMinValue(), this.getMaxValue(), 0.0, max, this.value);
    }

    public double getScrollStep() {
        return this.scrollStep;
    }

    public static enum Plane {
        HORIZONTAL(false),
        VERTICAL(true);

        public final boolean isVertical;

        private Plane(boolean v) {
            this.isVertical = v;
        }
    }
}

