/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.integration;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import dev.ftb.mods.ftblibrary.config.ui.ItemSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonGroup;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.SystemFavoriteEntryProvider;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class REIIntegration
implements REIClientPlugin {
    public static final class_2960 ID = new class_2960("ftblibrary", "sidebar_button");
    private static final ItemSearchMode REI_ITEMS = new ItemSearchMode(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(class_1802.field_28659);
        }

        @Override
        public class_5250 getDisplayName() {
            return new class_2588("ftblibrary.select_item.list_mode.rei");
        }

        @Override
        public Collection<class_1799> getAllItems() {
            return CollectionUtils.filterAndMap((Iterable)EntryRegistry.getInstance().getPreFilteredList(), stack -> stack.getType().equals(VanillaEntryTypes.ITEM), stack -> (class_1799)stack.castValue());
        }
    };

    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(ID, (FavoriteEntryType)SidebarButtonType.INSTANCE);
        registry.registerSystemFavorites((SystemFavoriteEntryProvider)new SystemFavoriteEntryProvider<FavoriteEntry>(){

            public List<FavoriteEntry> provide() {
                ArrayList<FavoriteEntry> entries = new ArrayList<FavoriteEntry>();
                for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
                    for (SidebarButton button : group.getButtons()) {
                        entries.add(new SidebarButtonEntry(button));
                    }
                }
                return entries;
            }

            public long updateInterval() {
                return 2000L;
            }
        });
    }

    static {
        SelectItemStackScreen.modes.add(0, REI_ITEMS);
    }

    private static enum SidebarButtonType implements FavoriteEntryType<SidebarButtonEntry>
    {
        INSTANCE;


        public class_2487 save(SidebarButtonEntry entry, class_2487 tag) {
            tag.method_10582("id", entry.button.id.toString());
            tag.method_10582("json", new Gson().toJson((JsonElement)entry.button.json));
            return tag;
        }

        public DataResult<SidebarButtonEntry> read(class_2487 object) {
            class_2960 id = new class_2960(object.method_10558("id"));
            JsonObject json = (JsonObject)JsonParser.parseString((String)object.method_10558("json"));
            return DataResult.success((Object)((Object)new SidebarButtonEntry(new SidebarButton(id, null, json))), (Lifecycle)Lifecycle.stable());
        }

        public DataResult<SidebarButtonEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error((String)"Cannot create SidebarButtonEntry from empty args!");
            }
            if (!(args[0] instanceof class_2960)) {
                return DataResult.error((String)"Creation of SidebarButtonEntry from args expected ResourceLocation as the first argument!");
            }
            if (!(args[1] instanceof SidebarButton) && !(args[1] instanceof JsonObject)) {
                return DataResult.error((String)"Creation of SidebarButtonEntry from args expected SidebarButton or JsonObject as the second argument!");
            }
            return DataResult.success((Object)((Object)new SidebarButtonEntry(args[1] instanceof SidebarButton ? (SidebarButton)args[1] : new SidebarButton((class_2960)args[0], null, (JsonObject)args[1]))), (Lifecycle)Lifecycle.stable());
        }
    }

    private static class SidebarButtonEntry
    extends FavoriteEntry {
        private final SidebarButton button;

        public SidebarButtonEntry(SidebarButton button) {
            this.button = button;
        }

        public boolean isInvalid() {
            for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
                for (SidebarButton groupButton : group.getButtons()) {
                    if (!groupButton.id.equals((Object)this.button.id) || !groupButton.isActuallyVisible()) continue;
                    return false;
                }
            }
            return true;
        }

        public Renderer getRenderer(boolean showcase) {
            return new Renderer(){

                public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    GuiHelper.setupDrawing();
                    button.getIcon().draw(matrices, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                }

                @Nullable
                public Tooltip getTooltip(Point mouse) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(class_1074.method_4662((String)button.getLangKey(), (Object[])new Object[0]));
                    if (button.getTooltipHandler() != null) {
                        button.getTooltipHandler().accept(list);
                    }
                    return Tooltip.create((Point)mouse, (Collection)CollectionUtils.map(list, ImmutableTextComponent::new));
                }

                public int getZ() {
                    return 0;
                }

                public void setZ(int z) {
                }
            };
        }

        public boolean doAction(int button) {
            this.button.onClicked(class_437.method_25442());
            return true;
        }

        public long hashIgnoreAmount() {
            return this.button.id.hashCode();
        }

        public FavoriteEntry copy() {
            return new SidebarButtonEntry(new SidebarButton(this.button.id, null, this.button.json));
        }

        public class_2960 getType() {
            return ID;
        }

        public boolean isSame(FavoriteEntry other) {
            if (other instanceof SidebarButtonEntry) {
                return ((SidebarButtonEntry)other).button.id.equals((Object)this.button.id);
            }
            return false;
        }
    }
}

