/*
 * Decompiled with CFR 0.152.
 */
package net.gudenau.minecraft.moretags.mixins;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public final class Plugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"MoreTags");
    private static final Set<CompatibilityLayer> COMPATIBILITY_LAYERS = Stream.of(CompatibilityLayer.values()).filter(CompatibilityLayer::shouldApply).collect(Collectors.toUnmodifiableSet());

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        for (CompatibilityLayer layer : COMPATIBILITY_LAYERS) {
            if (layer.shouldApplyMixin(mixinClassName)) continue;
            return false;
        }
        return true;
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static enum CompatibilityLayer {
        FAPI_TAGS("fabric-tag-extensions-v0", "1.2.2", VersionCheckType.OLDER_THAN, mixinName -> !"net.gudenau.minecraft.moretags.mixins.retro.OldTagApiSupport".equals(mixinName)),
        ATBYW("atbyw", null, VersionCheckType.ALWAYS, mixinName -> switch (mixinName) {
            case "net.gudenau.minecraft.moretags.mixins.bookshelves.EnchantingTableBlockMixin", "net.gudenau.minecraft.moretags.mixins.bookshelves.EnchantmentScreenHandlerMixin" -> false;
            default -> true;
        }),
        BCLIB("bclib", null, VersionCheckType.ALWAYS, mixinName -> switch (mixinName) {
            case "net.gudenau.minecraft.moretags.mixins.bookshelves.EnchantingTableBlockMixin", "net.gudenau.minecraft.moretags.mixins.bookshelves.EnchantmentScreenHandlerMixin" -> false;
            default -> true;
        });

        private final String modId;
        private final String modVersion;
        private final VersionCheckType checkType;
        private final Predicate<String> mixinPredicate;

        private CompatibilityLayer(String modId, String modVersion, VersionCheckType checkType, Predicate<String> mixinPredicate) {
            this.modId = modId;
            this.modVersion = modVersion;
            this.checkType = checkType;
            this.mixinPredicate = mixinPredicate;
        }

        public boolean shouldApply() {
            SemanticVersion expectedVersion;
            if (this.modId == null) {
                return true;
            }
            Optional container = FabricLoader.getInstance().getModContainer(this.modId);
            if (container.isEmpty()) {
                return false;
            }
            if (this.checkType == VersionCheckType.ALWAYS) {
                return true;
            }
            Version modVersion = ((ModContainer)container.get()).getMetadata().getVersion();
            if (!(modVersion instanceof SemanticVersion)) {
                LOGGER.error("Failed to get SemanticVersion for mod %s".formatted(this.modId));
                return false;
            }
            SemanticVersion suppliedVersion = (SemanticVersion)modVersion;
            try {
                expectedVersion = SemanticVersion.parse((String)this.modVersion);
            }
            catch (VersionParsingException e) {
                throw new RuntimeException("Failed to parse version %s for %s's compatibility layer".formatted(this.modVersion, this.modId));
            }
            return this.checkType.test(suppliedVersion, expectedVersion);
        }

        public boolean shouldApplyMixin(String mixinName) {
            return this.mixinPredicate.test(mixinName);
        }
    }

    private static enum VersionCheckType {
        ALWAYS((suppliedVersion, expectedVersion) -> true),
        OLDER_THAN((suppliedVersion, expectedVersion) -> suppliedVersion.compareTo(expectedVersion) > 0),
        NEWER_THAN((suppliedVersion, expectedVersion) -> suppliedVersion.compareTo(expectedVersion) < 0),
        EQUAL_TO((suppliedVersion, expectedVersion) -> suppliedVersion.equals(expectedVersion));

        private final BiPredicate<SemanticVersion, SemanticVersion> predicate;

        private VersionCheckType(BiPredicate<SemanticVersion, SemanticVersion> predicate) {
            this.predicate = predicate;
        }

        public boolean test(SemanticVersion suppliedVersion, SemanticVersion expectedVersion) {
            return this.predicate.test(suppliedVersion, expectedVersion);
        }
    }
}

