/*
 * Decompiled with CFR 0.152.
 */
package me.steven.carrier;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistryV3;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import me.steven.carrier.Config;
import me.steven.carrier.ServerWorldTickCallback;
import me.steven.carrier.api.Carriable;
import me.steven.carrier.api.CarriablePlacementContext;
import me.steven.carrier.api.CarriableRegistry;
import me.steven.carrier.api.CarrierComponent;
import me.steven.carrier.api.CarrierPlayerExtension;
import me.steven.carrier.impl.CarriableBanner;
import me.steven.carrier.impl.CarriableChest;
import me.steven.carrier.impl.CarriableChicken;
import me.steven.carrier.impl.CarriableCow;
import me.steven.carrier.impl.CarriableEnchantingTable;
import me.steven.carrier.impl.CarriableGeneric;
import me.steven.carrier.impl.CarriableParrot;
import me.steven.carrier.impl.CarriablePig;
import me.steven.carrier.impl.CarriableRabbit;
import me.steven.carrier.impl.CarriableSheep;
import me.steven.carrier.impl.CarriableSpawner;
import me.steven.carrier.impl.CarriableTurtle;
import me.steven.carrier.impl.CarriableWolf;
import me.steven.carrier.items.GloveItem;
import net.devtech.arrp.api.RRPCallback;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JKeys;
import net.devtech.arrp.json.recipe.JPattern;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JResult;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2185;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3494;
import net.minecraft.class_4739;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;

public class Carrier
implements ModInitializer,
EntityComponentInitializer {
    public static final ComponentKey<CarrierComponent> HOLDER = ComponentRegistryV3.INSTANCE.getOrCreate(new class_2960("carrier", "holder"), CarrierComponent.class);
    public static final String MOD_ID = "carrier";
    public static Config CONFIG = new Config();
    public static final class_1792 ITEM_GLOVE = new GloveItem((class_1792.class_1793)new FabricItemSettings().group(class_1761.field_7930).maxCount(1));
    public static final class_2960 SET_CAN_CARRY_PACKET = new class_2960("carrier", "can_carry_packet");
    public static final class_3494<class_2248> BLACKLIST = TagFactory.BLOCK.create(new class_2960("carrier", "blacklist"));

    public void onInitialize() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "carrier.json");
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new IOException("Failed to create file");
                }
                FileUtils.write((File)file, (CharSequence)gson.toJson((Object)CONFIG), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LogManager.getLogger((String)"Carrier").error("Failed to create carrier config");
                throw new RuntimeException(e);
            }
        }
        try {
            String lines = String.join((CharSequence)"\n", FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8));
            CONFIG = (Config)gson.fromJson(lines, Config.class);
        }
        catch (IOException e) {
            LogManager.getLogger((String)"Carrier").error("Failed to read config");
            throw new RuntimeException(e);
        }
        ServerTickEvents.END_WORLD_TICK.register((Object)new ServerWorldTickCallback());
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_cow"), new CarriableCow());
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_chicken"), new CarriableChicken());
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_parrot"), new CarriableParrot());
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_pig"), new CarriablePig());
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_rabbit"), new CarriableRabbit());
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_sheep"), new CarriableSheep());
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_turtle"), new CarriableTurtle());
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_wolf"), new CarriableWolf());
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_spawner"), new CarriableSpawner(new class_2960(MOD_ID, "minecraft_spawner")));
        CarriableRegistry.INSTANCE.register(new class_2960(MOD_ID, "minecraft_enchanting_table"), new CarriableEnchantingTable(new class_2960(MOD_ID, "minecraft_enchanting_table")));
        class_2378.field_11146.forEach(block -> {
            class_2960 id = class_2378.field_11146.method_10221(block);
            class_2960 type = new class_2960(MOD_ID, id.method_12836() + "_" + id.method_12832());
            Carrier.registerGenericCarriable(block, type);
        });
        RegistryEntryAddedCallback.event((class_2378)class_2378.field_11146).register((rawId, id, block) -> {
            class_2960 type = new class_2960(MOD_ID, id.method_12836() + "_" + id.method_12832());
            Carrier.registerGenericCarriable(block, type);
        });
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960(MOD_ID, "glove"), (Object)ITEM_GLOVE);
        if (CONFIG.doGlovesExist()) {
            RuntimeResourcePack resourcePack = RuntimeResourcePack.create((String)"carrier:gloves");
            resourcePack.addRecipe(new class_2960(MOD_ID, "gloves"), (JRecipe)JRecipe.shaped((JPattern)JPattern.pattern((String[])new String[]{"L  ", "LL "}), (JKeys)JKeys.keys().key("L", JIngredient.ingredient().item("minecraft:leather")), (JResult)JResult.item((class_1792)ITEM_GLOVE)));
            RRPCallback.EVENT.register(packs -> packs.add(resourcePack));
        }
        ServerSidePacketRegistry.INSTANCE.register(SET_CAN_CARRY_PACKET, (ctx, buf) -> {
            boolean canCarry = buf.readBoolean();
            ctx.getTaskQueue().execute(() -> ((CarrierPlayerExtension)ctx.getPlayer()).setCanCarry(canCarry));
        });
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b) -> commandDispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"carrierinfo").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            class_2487 tag = new class_2487();
            ((CarrierComponent)HOLDER.get((Object)player)).writeToNbt(tag);
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(tag.toString()), false);
            return 1;
        })));
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b) -> commandDispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"carrierdelete").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            CarrierComponent component = (CarrierComponent)HOLDER.get((Object)player);
            class_2487 tag = new class_2487();
            component.writeToNbt(tag);
            component.setCarryingData(null);
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Deleted ").method_10852((class_2561)new class_2585(tag.toString()).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, tag.toString())))), false);
            return 1;
        })));
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b) -> commandDispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"carrierplace").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            CarrierComponent component = (CarrierComponent)HOLDER.get((Object)player);
            Carriable<class_2960> carriable = CarriableRegistry.INSTANCE.get(component.getCarryingData().getType());
            class_2338 pos = player.method_24515().method_10093(player.method_5735());
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            if (!world.method_8320(pos).method_26207().method_15800()) {
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Could not place! Make sure you have empty space in front of you."), false);
                return 1;
            }
            CarriablePlacementContext placementCtx = new CarriablePlacementContext(component, carriable, pos, player.method_5735().method_10153(), player.method_5735());
            carriable.tryPlace(component, (class_1937)world, placementCtx);
            component.setCarryingData(null);
            return 1;
        })));
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(HOLDER, CarrierComponent::new, RespawnCopyStrategy.ALWAYS_COPY);
    }

    public static boolean canCarry(class_2960 id) {
        if (class_2378.field_11146.method_17966(id).stream().anyMatch(arg_0 -> BLACKLIST.method_15141(arg_0))) {
            return false;
        }
        if (CONFIG.getType() == Config.ListType.WHITELIST) {
            return CONFIG.getList().stream().anyMatch(s -> Pattern.compile(s).matcher(id.toString()).find());
        }
        return CONFIG.getList().stream().noneMatch(s -> Pattern.compile(s).matcher(id.toString()).find());
    }

    public static boolean isHoldingKey(class_1657 playerEntity) {
        return playerEntity instanceof CarrierPlayerExtension && ((CarrierPlayerExtension)playerEntity).canCarry();
    }

    private static void registerGenericCarriable(class_2248 block, class_2960 type) {
        if (block instanceof class_2343 && !CarriableRegistry.INSTANCE.contains(block)) {
            if (block instanceof class_4739) {
                CarriableRegistry.INSTANCE.register(type, new CarriableChest(type, block));
            } else if (block instanceof class_2185) {
                CarriableRegistry.INSTANCE.register(type, new CarriableBanner(type, block));
            } else {
                CarriableRegistry.INSTANCE.register(type, new CarriableGeneric(type, block));
            }
        }
    }
}

