/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.item.FixedItemInvView;
import alexiil.mc.lib.attributes.item.impl.AbstractPartialFixedItemInvView;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.MappedFixedItemInvView;

public class SubFixedItemInvView
extends AbstractPartialFixedItemInvView {
    protected final int fromIndex;
    protected final int toIndex;

    public SubFixedItemInvView(FixedItemInvView inv, int fromIndex, int toIndex) {
        super(inv);
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex was greater than toIndex! (" + fromIndex + " > " + toIndex + ")");
        }
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    protected final int getInternalSlot(int slot) {
        if ((slot += this.fromIndex) >= this.toIndex) {
            throw new IllegalArgumentException("The given slot " + (slot - this.fromIndex) + "is greater than the size of this inventory! (" + this.getSlotCount() + ")");
        }
        return slot;
    }

    @Override
    public int getSlotCount() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public FixedItemInvView getFixedView() {
        if (this.getClass() == SubFixedItemInvView.class) {
            return this;
        }
        return super.getFixedView();
    }

    @Override
    public FixedItemInvView getSubInv(int fIndex, int tIndex) {
        if (fIndex == tIndex) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (fIndex == 0 && tIndex == this.getSlotCount()) {
            return this;
        }
        fIndex = this.getInternalSlot(fIndex);
        tIndex = this.getInternalSlot(tIndex - 1) + 1;
        return new SubFixedItemInvView(this.inv, fIndex, tIndex);
    }

    @Override
    public FixedItemInvView getMappedInv(int ... slots) {
        if (slots.length == 0) {
            return EmptyFixedItemInv.INSTANCE;
        }
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = this.getInternalSlot(slots[i]);
        }
        return new MappedFixedItemInvView(this.inv, slots);
    }
}

