/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.GroupedItemInv;
import alexiil.mc.lib.attributes.item.LimitedGroupedItemInv;
import alexiil.mc.lib.attributes.item.filter.AggregateItemFilter;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ExactItemStackFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.DelegatingGroupedItemInv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1799;

public class SimpleLimitedGroupedItemInv
extends DelegatingGroupedItemInv
implements LimitedGroupedItemInv {
    private boolean isImmutable = false;
    private final List<InsertionRule> insertionRules = new ArrayList<InsertionRule>();
    private final List<ExtractionRule> extractionRules = new ArrayList<ExtractionRule>();

    public SimpleLimitedGroupedItemInv(GroupedItemInv delegate) {
        super(delegate);
    }

    @Override
    public LimitedGroupedItemInv markFinal() {
        this.isImmutable = true;
        return this;
    }

    protected void assertMutable() {
        if (this.isImmutable) {
            throw new IllegalStateException("This object has already been marked as immutable, so no further changes are permitted!");
        }
    }

    @Override
    public LimitedGroupedItemInv copy() {
        SimpleLimitedGroupedItemInv copy = new SimpleLimitedGroupedItemInv(this.delegate);
        copy.extractionRules.addAll(this.extractionRules);
        copy.insertionRules.addAll(this.insertionRules);
        return copy;
    }

    @Override
    public class_1799 attemptExtraction(ItemFilter filter, int maxAmount, Simulation simulation) {
        if (filter == ConstantItemFilter.NOTHING || filter == ConstantItemFilter.ONLY_EMPTY) {
            return class_1799.field_8037;
        }
        if (this.extractionRules.isEmpty()) {
            return this.delegate.attemptExtraction(filter, maxAmount, simulation);
        }
        Set<class_1799> stacks = this.delegate.getStoredStacks();
        if (stacks.isEmpty()) {
            return class_1799.field_8037;
        }
        if (filter instanceof ExactItemStackFilter) {
            class_1799 stack = ((ExactItemStackFilter)filter).stack;
            if (!stacks.contains(stack)) {
                return class_1799.field_8037;
            }
            stacks = Collections.singleton(stack);
        }
        block0: for (class_1799 stack : stacks) {
            int current;
            if (!filter.matches(stack) || (current = this.delegate.getAmount(stack)) <= 0) continue;
            int minLeft = 0;
            for (ExtractionRule rule : this.extractionRules) {
                if (!rule.filter.matches(stack) || rule.minimumAmount <= 0 || current > (minLeft = Math.max(minLeft, rule.minimumAmount))) continue;
                continue block0;
            }
            int allowed = current - minLeft;
            return this.delegate.attemptExtraction(new ExactItemStackFilter(stack), Math.min(maxAmount, allowed), simulation);
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 attemptInsertion(class_1799 stack, Simulation simulation) {
        if (stack.method_7960()) {
            return stack;
        }
        int current = this.delegate.getAmount(stack);
        int maxCount = Integer.MAX_VALUE;
        for (InsertionRule rule : this.insertionRules) {
            if (!rule.filter.matches(stack) || (maxCount = Math.min(maxCount, rule.maximumInsertion)) > current) continue;
            return stack;
        }
        int allowed = maxCount - current;
        assert (allowed >= 1);
        if (allowed < stack.method_7947()) {
            class_1799 original = stack;
            class_1799 offered = original.method_7972();
            class_1799 leftover = this.delegate.attemptInsertion(offered.method_7971(allowed), simulation);
            if (leftover.method_7947() == maxCount) {
                return original;
            }
            offered.method_7933(leftover.method_7947());
            return offered;
        }
        return super.attemptInsertion(stack, simulation);
    }

    @Override
    public ItemFilter getInsertionFilter() {
        if (this.insertionRules.isEmpty()) {
            return this.delegate.getInsertionFilter();
        }
        ArrayList<ItemFilter> disallowed = new ArrayList<ItemFilter>();
        for (InsertionRule rule : this.insertionRules) {
            if (rule.maximumInsertion > 0) continue;
            disallowed.add(rule.filter);
        }
        ItemFilter allowed = AggregateItemFilter.anyOf(disallowed).negate();
        return allowed.and(this.delegate.getInsertionFilter());
    }

    @Override
    public LimitedGroupedItemInv.ItemLimitRule getRule(final ItemFilter filter) {
        if (filter == ConstantItemFilter.NOTHING) {
            return new LimitedGroupedItemInv.ItemLimitRule(){

                @Override
                public LimitedGroupedItemInv.ItemLimitRule setMinimum(int min) {
                    return this;
                }

                @Override
                public LimitedGroupedItemInv.ItemLimitRule limitInsertionCount(int max) {
                    return this;
                }
            };
        }
        if (filter == ConstantItemFilter.ANYTHING) {
            return new LimitedGroupedItemInv.ItemLimitRule(){

                @Override
                public LimitedGroupedItemInv.ItemLimitRule setMinimum(int min) {
                    SimpleLimitedGroupedItemInv.this.extractionRules.clear();
                    if (min > 0) {
                        SimpleLimitedGroupedItemInv.this.extractionRules.add(new ExtractionRule(filter, min));
                    }
                    return this;
                }

                @Override
                public LimitedGroupedItemInv.ItemLimitRule limitInsertionCount(int max) {
                    SimpleLimitedGroupedItemInv.this.insertionRules.clear();
                    if (max >= 0) {
                        SimpleLimitedGroupedItemInv.this.insertionRules.add(new InsertionRule(filter, max));
                    }
                    return this;
                }
            };
        }
        return new LimitedGroupedItemInv.ItemLimitRule(){

            @Override
            public LimitedGroupedItemInv.ItemLimitRule setMinimum(int min) {
                SimpleLimitedGroupedItemInv.this.extractionRules.add(new ExtractionRule(filter, min));
                return this;
            }

            @Override
            public LimitedGroupedItemInv.ItemLimitRule limitInsertionCount(int max) {
                SimpleLimitedGroupedItemInv.this.insertionRules.add(new InsertionRule(filter, max));
                return this;
            }
        };
    }

    static final class ExtractionRule {
        final ItemFilter filter;
        final int minimumAmount;

        public ExtractionRule(ItemFilter filter, int minimumAmount) {
            this.filter = filter;
            this.minimumAmount = minimumAmount;
        }
    }

    static final class InsertionRule {
        final ItemFilter filter;
        final int maximumInsertion;

        public InsertionRule(ItemFilter filter, int maximumInsertion) {
            this.filter = filter;
            this.maximumInsertion = maximumInsertion;
        }
    }
}

