/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.FixedItemInvView;
import alexiil.mc.lib.attributes.item.InvMarkDirtyListener;
import alexiil.mc.lib.attributes.item.ItemInvSlotChangeListener;
import alexiil.mc.lib.attributes.item.ItemStackUtil;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.DelegatingFixedItemInv;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.class_1799;

public class SimpleLimitedFixedItemInv
extends DelegatingFixedItemInv
implements LimitedFixedItemInv {
    private static final byte MAX_AMOUNT = 64;
    private boolean isImmutable = false;
    protected final ItemFilter[] insertionFilters;
    protected final ItemFilter[] extractionFilters;
    protected final byte[] maxInsertionAmounts;
    protected final byte[] minimumAmounts;

    public SimpleLimitedFixedItemInv(FixedItemInv delegate) {
        super(delegate);
        this.insertionFilters = new ItemFilter[delegate.getSlotCount()];
        this.extractionFilters = new ItemFilter[delegate.getSlotCount()];
        this.maxInsertionAmounts = new byte[delegate.getSlotCount()];
        this.minimumAmounts = new byte[delegate.getSlotCount()];
        Arrays.fill(this.maxInsertionAmounts, (byte)64);
    }

    public static SimpleLimitedFixedItemInv createLimited(FixedItemInv inv) {
        if (inv instanceof FixedItemInv.ModifiableFixedItemInv) {
            return new OfModifiable((FixedItemInv.ModifiableFixedItemInv)inv);
        }
        if (inv instanceof FixedItemInv.CopyingFixedItemInv) {
            return new OfCopying((FixedItemInv.CopyingFixedItemInv)inv);
        }
        return new SimpleLimitedFixedItemInv(inv);
    }

    @Override
    public SimpleLimitedFixedItemInv markFinal() {
        this.isImmutable = true;
        return this;
    }

    protected void assertMutable() {
        if (this.isImmutable) {
            throw new IllegalStateException("This object has already been marked as immutable, so no further changes are permitted!");
        }
    }

    @Override
    public LimitedFixedItemInv copy() {
        SimpleLimitedFixedItemInv inv = this instanceof OfModifiable ? new OfModifiable((FixedItemInv.ModifiableFixedItemInv)this.delegate) : (this instanceof OfCopying ? new OfCopying((FixedItemInv.CopyingFixedItemInv)this.delegate) : new SimpleLimitedFixedItemInv(this.delegate));
        inv.isImmutable = this.isImmutable;
        for (int i = 0; i < inv.getSlotCount(); ++i) {
            inv.insertionFilters[i] = this.insertionFilters[i];
            inv.maxInsertionAmounts[i] = this.maxInsertionAmounts[i];
            inv.minimumAmounts[i] = this.minimumAmounts[i];
        }
        return inv;
    }

    @Override
    public boolean isItemValidForSlot(int slot, class_1799 stack) {
        return (stack.method_7960() || this.getFilterForSlot(slot).matches(stack)) && this.delegate.isItemValidForSlot(slot, stack);
    }

    @Override
    public ItemFilter getFilterForSlot(int slot) {
        ItemFilter filter = this.insertionFilters[slot];
        if (filter != null) {
            return super.getFilterForSlot(slot).and(filter);
        }
        return super.getFilterForSlot(slot);
    }

    @Override
    public boolean setInvStack(int slot, class_1799 to, Simulation simulation) {
        boolean isInserting;
        class_1799 current = this.getInvStack(slot);
        boolean same = ItemStackUtil.areEqualIgnoreAmounts(current, to);
        boolean isExtracting = !current.method_7960() && (!same || to.method_7947() < current.method_7947());
        boolean bl = isInserting = !to.method_7960() && (!same || to.method_7947() > current.method_7947());
        if (isExtracting) {
            if (same ? to.method_7947() < this.minimumAmounts[slot] : this.minimumAmounts[slot] > 0) {
                return false;
            }
            if (this.extractionFilters[slot] != null && !this.extractionFilters[slot].matches(current)) {
                return false;
            }
        }
        if (isInserting) {
            if (to.method_7947() > this.maxInsertionAmounts[slot]) {
                return false;
            }
            if (!this.isItemValidForSlot(slot, to)) {
                return false;
            }
        }
        return super.setInvStack(slot, to, simulation);
    }

    @Override
    public class_1799 insertStack(int slot, class_1799 stack, Simulation simulation) {
        int currentCount;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 current = this.getInvStack(slot);
        int n = currentCount = current.method_7960() ? 0 : current.method_7947();
        if (currentCount >= this.maxInsertionAmounts[slot]) {
            return stack;
        }
        if (this.insertionFilters[slot] != null && !this.insertionFilters[slot].matches(stack)) {
            return stack;
        }
        int cannotAddAmount = Math.max(0, currentCount + stack.method_7947() - this.maxInsertionAmounts[slot]);
        class_1799 cannotAdd = null;
        if (cannotAddAmount > 0) {
            stack = stack.method_7972();
            cannotAdd = stack.method_7971(cannotAddAmount);
        }
        class_1799 excess = super.insertStack(slot, stack, simulation);
        if (cannotAdd != null) {
            if (!excess.method_7960()) {
                cannotAdd.method_7933(excess.method_7947());
            }
            return cannotAdd;
        }
        return excess;
    }

    @Override
    public class_1799 extractStack(int slot, @Nullable ItemFilter filter, class_1799 mergeWith, int maxCount, Simulation simulation) {
        class_1799 current = this.getInvStack(slot);
        if (current.method_7960()) {
            return mergeWith;
        }
        if ((maxCount = Math.min(maxCount, current.method_7947() - this.minimumAmounts[slot])) <= 0) {
            return mergeWith;
        }
        if (this.extractionFilters[slot] != null && !this.extractionFilters[slot].matches(current)) {
            return mergeWith;
        }
        return super.extractStack(slot, filter, mergeWith, maxCount, simulation);
    }

    @Override
    public int getMaxAmount(int slot, class_1799 stack) {
        byte ourMax = this.maxInsertionAmounts[slot];
        int delegateMax = super.getMaxAmount(slot, stack);
        return Math.min(ourMax, delegateMax);
    }

    @Override
    public LimitedFixedItemInv.ItemSlotLimitRule getRule(final int slot) {
        return new LimitedFixedItemInv.ItemSlotLimitRule(){

            @Override
            public LimitedFixedItemInv.ItemSlotLimitRule setMinimum(int min) {
                SimpleLimitedFixedItemInv.this.assertMutable();
                SimpleLimitedFixedItemInv.this.minimumAmounts[slot] = (byte)Math.max(0, Math.min(64, min));
                return this;
            }

            @Override
            public LimitedFixedItemInv.ItemSlotLimitRule limitInsertionCount(int max) {
                SimpleLimitedFixedItemInv.this.assertMutable();
                SimpleLimitedFixedItemInv.this.maxInsertionAmounts[slot] = (byte)Math.max(0, Math.min(64, max));
                return this;
            }

            @Override
            public LimitedFixedItemInv.ItemSlotLimitRule filterInserts(ItemFilter filter) {
                SimpleLimitedFixedItemInv.this.assertMutable();
                if (filter == ConstantItemFilter.ANYTHING) {
                    filter = null;
                }
                SimpleLimitedFixedItemInv.this.insertionFilters[slot] = filter;
                return this;
            }

            @Override
            public LimitedFixedItemInv.ItemSlotLimitRule filterExtracts(ItemFilter filter) {
                SimpleLimitedFixedItemInv.this.assertMutable();
                if (filter == ConstantItemFilter.ANYTHING) {
                    filter = null;
                }
                SimpleLimitedFixedItemInv.this.extractionFilters[slot] = filter;
                return this;
            }
        };
    }

    @Override
    public LimitedFixedItemInv.ItemSlotLimitRule getSubRule(final int from, final int to) {
        return new LimitedFixedItemInv.ItemSlotLimitRule(){

            @Override
            public LimitedFixedItemInv.ItemSlotLimitRule setMinimum(int min) {
                SimpleLimitedFixedItemInv.this.assertMutable();
                byte value = (byte)Math.max(0, Math.min(64, min));
                Arrays.fill(SimpleLimitedFixedItemInv.this.minimumAmounts, from, to, value);
                return this;
            }

            @Override
            public LimitedFixedItemInv.ItemSlotLimitRule limitInsertionCount(int max) {
                SimpleLimitedFixedItemInv.this.assertMutable();
                byte value = (byte)Math.max(0, Math.min(64, max));
                Arrays.fill(SimpleLimitedFixedItemInv.this.maxInsertionAmounts, from, to, value);
                return this;
            }

            @Override
            public LimitedFixedItemInv.ItemSlotLimitRule filterInserts(ItemFilter filter) {
                SimpleLimitedFixedItemInv.this.assertMutable();
                if (filter == ConstantItemFilter.ANYTHING) {
                    filter = null;
                }
                Arrays.fill(SimpleLimitedFixedItemInv.this.insertionFilters, from, to, filter);
                return this;
            }

            @Override
            public LimitedFixedItemInv.ItemSlotLimitRule filterExtracts(ItemFilter filter) {
                SimpleLimitedFixedItemInv.this.assertMutable();
                if (filter == ConstantItemFilter.ANYTHING) {
                    filter = null;
                }
                Arrays.fill(SimpleLimitedFixedItemInv.this.extractionFilters, from, to, filter);
                return this;
            }
        };
    }

    public static class OfModifiable
    extends SimpleLimitedFixedItemInv
    implements FixedItemInv.ModifiableFixedItemInv {
        public OfModifiable(FixedItemInv.ModifiableFixedItemInv delegate) {
            super(delegate);
        }

        @Override
        public void markDirty() {
            ((FixedItemInv.ModifiableFixedItemInv)this.delegate).markDirty();
        }

        @Override
        public ListenerToken addListener(InvMarkDirtyListener listener, ListenerRemovalToken removalToken) {
            OfModifiable wrapper = this;
            return ((FixedItemInv.ModifiableFixedItemInv)this.delegate).addListener(inv -> listener.onMarkDirty(wrapper), removalToken);
        }
    }

    public static class OfCopying
    extends SimpleLimitedFixedItemInv
    implements FixedItemInv.CopyingFixedItemInv {
        public OfCopying(FixedItemInv.CopyingFixedItemInv delegate) {
            super(delegate);
        }

        @Override
        public class_1799 getUnmodifiableInvStack(int slot) {
            return ((FixedItemInv.CopyingFixedItemInv)this.delegate).getUnmodifiableInvStack(slot);
        }

        @Override
        public ListenerToken addListener(ItemInvSlotChangeListener listener, ListenerRemovalToken removalToken) {
            OfCopying wrapper = this;
            return ((FixedItemInv.CopyingFixedItemInv)this.delegate).addListener((FixedItemInvView realInv, int slot, class_1799 previous, class_1799 current) -> listener.onChange(wrapper, slot, previous, current), removalToken);
        }
    }
}

