/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.GroupedItemInv;
import alexiil.mc.lib.attributes.item.GroupedItemInvView;
import alexiil.mc.lib.attributes.item.ItemInvAmountChangeListener;
import alexiil.mc.lib.attributes.item.ItemStackCollections;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.misc.Saveable;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class SimpleGroupedItemInv
implements GroupedItemInv,
Saveable {
    private static final ItemInvAmountChangeListener[] NO_LISTENERS = new ItemInvAmountChangeListener[0];
    private static final ItemInvAmountChangeListener[] INVALIDATING_LISTENERS = new ItemInvAmountChangeListener[0];
    public final int maxItemTypes;
    public final int maxItems;
    private int cachedItemCount;
    private int changes;
    private ItemInvAmountChangeListener ownerListener;
    private final Map<ItemInvAmountChangeListener, ListenerRemovalToken> listeners = new Object2ObjectLinkedOpenCustomHashMap(class_156.method_655());
    private ItemInvAmountChangeListener[] bakedListeners = NO_LISTENERS;
    private final Object2IntMap<class_1799> stacks = ItemStackCollections.intMap();

    public SimpleGroupedItemInv(int maxItemTypes, int maxItems) {
        this.maxItemTypes = maxItemTypes;
        this.maxItems = maxItems;
        this.stacks.defaultReturnValue(-1);
    }

    @Override
    public Set<class_1799> getStoredStacks() {
        return this.stacks.keySet();
    }

    @Override
    public int getTotalCapacity() {
        return this.maxItems;
    }

    @Override
    public GroupedItemInvView.ItemInvStatistic getStatistics(ItemFilter filter) {
        int totalCount = 0;
        int totalSpace = this.maxItems;
        for (Object2IntMap.Entry entry : this.stacks.object2IntEntrySet()) {
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (filter.matches(stack)) {
                totalCount += count;
                continue;
            }
            totalSpace -= count;
        }
        return new GroupedItemInvView.ItemInvStatistic(filter, totalCount, 0, totalSpace);
    }

    @Override
    public class_1799 attemptInsertion(class_1799 stack, Simulation simulation) {
        int current = this.stacks.getInt((Object)stack);
        if (current < 0 && this.stacks.size() >= this.maxItemTypes) {
            return stack;
        }
        int insertable = Math.min(stack.method_7947(), this.maxItems - this.cachedItemCount);
        if (insertable <= 0) {
            return stack;
        }
        stack = stack.method_7972();
        class_1799 insStack = stack.method_7971(insertable);
        assert (insStack.method_7947() == insertable);
        if (simulation == Simulation.ACTION) {
            this.stacks.put((Object)insStack, insertable + (current < 0 ? 0 : current));
            this.cachedItemCount += insertable;
            this.fireAmountChange(stack, current, current + insertable);
        }
        return stack;
    }

    @Override
    public class_1799 attemptExtraction(ItemFilter filter, int maxAmount, Simulation simulation) {
        for (Object2IntMap.Entry entry : this.stacks.object2IntEntrySet()) {
            class_1799 stack = (class_1799)entry.getKey();
            if (!filter.matches(stack)) continue;
            int current = entry.getIntValue();
            int extracted = Math.min(current, maxAmount);
            if (simulation == Simulation.ACTION) {
                if (extracted == current) {
                    this.stacks.removeInt((Object)stack);
                } else {
                    entry.setValue(current - extracted);
                }
                this.cachedItemCount -= extracted;
                this.fireAmountChange(stack, current, current - extracted);
            }
            stack = stack.method_7972();
            stack.method_7939(extracted);
            return stack;
        }
        return class_1799.field_8037;
    }

    @Override
    public ListenerToken addListener(ItemInvAmountChangeListener listener, ListenerRemovalToken removalToken) {
        if (this.bakedListeners == INVALIDATING_LISTENERS) {
            return null;
        }
        ListenerRemovalToken previous = this.listeners.put(listener, removalToken);
        if (previous == null) {
            this.bakeListeners();
        } else assert (previous == removalToken) : "The same listener object must be registered with the same removal token";
        return () -> {
            ListenerRemovalToken token = this.listeners.remove(listener);
            if (token != null) {
                assert (token == removalToken);
                this.bakeListeners();
                removalToken.onListenerRemoved();
            }
        };
    }

    public void setOwnerListener(ItemInvAmountChangeListener ownerListener) {
        this.ownerListener = ownerListener;
    }

    private void bakeListeners() {
        this.bakedListeners = this.listeners.keySet().toArray(new ItemInvAmountChangeListener[0]);
    }

    public void invalidateListeners() {
        this.bakedListeners = INVALIDATING_LISTENERS;
        ListenerRemovalToken[] removalTokens = this.listeners.values().toArray(new ListenerRemovalToken[0]);
        this.listeners.clear();
        for (ListenerRemovalToken token : removalTokens) {
            token.onListenerRemoved();
        }
        this.bakedListeners = NO_LISTENERS;
    }

    @Override
    public int getChangeValue() {
        return this.changes;
    }

    protected final void fireAmountChange(class_1799 stack, int previous, int current) {
        ItemInvAmountChangeListener[] baked;
        ++this.changes;
        if (this.ownerListener != null) {
            this.ownerListener.onChange(this, stack, previous, current);
        }
        for (ItemInvAmountChangeListener listener : baked = this.bakedListeners) {
            listener.onChange(this, stack, previous, current);
        }
    }

    public class_2487 toTag(class_2487 tag) {
        class_2499 items = new class_2499();
        for (Object2IntMap.Entry entry : this.stacks.object2IntEntrySet()) {
            class_1799 stack = (class_1799)entry.getKey();
            int count = entry.getIntValue();
            if (count <= 0) continue;
            class_2487 itemTag = stack.method_7953(new class_2487());
            itemTag.method_10569("Count", count);
            items.add((Object)itemTag);
        }
        if (!items.isEmpty()) {
            tag.method_10566("items", (class_2520)items);
        }
        return tag;
    }

    public void fromTag(class_2487 tag) {
        class_2499 items = tag.method_10554("items", (int)new class_2487().method_10711());
        for (int i = 0; i < items.size(); ++i) {
            class_2487 itemTag = items.method_10602(i);
            int count = itemTag.method_10550("Count");
            itemTag.method_10567("Count", (byte)1);
            class_1799 stack = class_1799.method_7915((class_2487)itemTag);
            if (stack.method_7960()) continue;
            this.stacks.put((Object)stack, count);
        }
        for (int count : this.stacks.values().toIntArray()) {
            this.cachedItemCount += count;
        }
    }
}

