/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.FixedItemInvView;
import alexiil.mc.lib.attributes.item.ItemInvSlotChangeListener;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.MappedFixedItemInvView;
import java.util.Arrays;
import net.minecraft.class_1799;

public class MappedFixedItemInv
extends MappedFixedItemInvView
implements FixedItemInv {
    public MappedFixedItemInv(FixedItemInv inv, int[] slots) {
        super(inv, slots);
    }

    @Override
    public boolean setInvStack(int slot, class_1799 to, Simulation simulation) {
        return ((FixedItemInv)this.inv).setInvStack(this.getInternalSlot(slot), to, simulation);
    }

    @Override
    public FixedItemInv getSubInv(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (fromIndex == 0 && toIndex == this.getSlotCount()) {
            return this;
        }
        int[] nSlots = new int[toIndex - fromIndex];
        int i = 0;
        for (int s = fromIndex; s < toIndex; ++s) {
            nSlots[i++] = this.getInternalSlot(s);
        }
        return MappedFixedItemInv.create((FixedItemInv)this.inv, nSlots);
    }

    @Override
    public FixedItemInv getMappedInv(int ... slots) {
        if (slots.length == 0) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (FixedItemInvView.areSlotArraysEqual(this, slots)) {
            return this;
        }
        slots = Arrays.copyOf(slots, slots.length);
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = this.getInternalSlot(slots[i]);
        }
        if (FixedItemInvView.areSlotArraysEqual(this.inv, slots)) {
            return (FixedItemInv)this.inv;
        }
        return MappedFixedItemInv.create((FixedItemInv)this.inv, slots);
    }

    public static MappedFixedItemInv create(FixedItemInv inv, int[] slots) {
        if (inv instanceof FixedItemInv.ModifiableFixedItemInv) {
            return new OfModifiable((FixedItemInv.ModifiableFixedItemInv)inv, slots);
        }
        if (inv instanceof FixedItemInv.CopyingFixedItemInv) {
            return new OfCopying((FixedItemInv.CopyingFixedItemInv)inv, slots);
        }
        return new MappedFixedItemInv(inv, slots);
    }

    public static class OfModifiable
    extends MappedFixedItemInv
    implements FixedItemInv.ModifiableFixedItemInv {
        public OfModifiable(FixedItemInv.ModifiableFixedItemInv inv, int[] slots) {
            super(inv, slots);
        }

        @Override
        public void markDirty() {
            ((FixedItemInv.ModifiableFixedItemInv)this.inv).markDirty();
        }
    }

    public static class OfCopying
    extends MappedFixedItemInv
    implements FixedItemInv.CopyingFixedItemInv {
        public OfCopying(FixedItemInv.CopyingFixedItemInv inv, int[] slots) {
            super(inv, slots);
        }

        @Override
        public class_1799 getUnmodifiableInvStack(int slot) {
            return ((FixedItemInv.CopyingFixedItemInv)this.inv).getUnmodifiableInvStack(this.getInternalSlot(slot));
        }

        @Override
        public ListenerToken addListener(ItemInvSlotChangeListener listener, ListenerRemovalToken removalToken) {
            OfCopying wrapper = this;
            return ((FixedItemInv.CopyingFixedItemInv)this.inv).addListener((FixedItemInvView realInv, int slot, class_1799 previous, class_1799 current) -> {
                assert (realInv == this.inv);
                int exposedSlot = this.inverseSlotMap.get(slot);
                if (exposedSlot >= 0) {
                    listener.onChange(wrapper, exposedSlot, previous, current);
                }
            }, removalToken);
        }
    }
}

