/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.AttributeUtil;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1799;

public final class ItemInvModificationTracker {
    private static final boolean ENABLED = AttributeUtil.EXPENSIVE_DEBUG_CHECKS;
    private static final Map<class_1799, TrackedItemStackState> stacks = Collections.synchronizedMap(new WeakHashMap());

    private ItemInvModificationTracker() {
    }

    public static void trackNeverChanging(class_1799 stack) {
        if (!ENABLED || stack == null) {
            return;
        }
        TrackedItemStackState ref = stacks.get(stack);
        if (ref != null) {
            ref.check(stack);
        } else {
            stacks.put(stack, new TrackedItemStackState(stack, new Throwable().fillInStackTrace()));
        }
    }

    public static String stackToFullString(class_1799 stack) {
        if (stack.method_7960()) {
            return "Empty";
        }
        int amount = stack.method_7947();
        String stackStr = amount + "x" + stack.method_7922();
        return stackStr + " tag = " + stack.method_7969();
    }

    static final class TrackedItemStackState {
        final class_1799 copy;
        final Throwable stack;

        public TrackedItemStackState(class_1799 referent, Throwable stack) {
            this.copy = referent.method_7972();
            this.stack = stack;
        }

        void check(class_1799 current) {
            if (class_1799.method_7973((class_1799)current, (class_1799)this.copy)) {
                return;
            }
            throw new IllegalStateException("The ItemStack that is stored has been changed! (\n\tOriginal = " + ItemInvModificationTracker.stackToFullString(this.copy) + ", \n\tChanged = " + ItemInvModificationTracker.stackToFullString(current) + ")", this.stack);
        }
    }
}

