/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.FixedItemInvView;
import alexiil.mc.lib.attributes.item.GroupedItemInvView;
import alexiil.mc.lib.attributes.item.InvMarkDirtyListener;
import alexiil.mc.lib.attributes.item.ItemInvAmountChangeListener;
import alexiil.mc.lib.attributes.item.ItemStackCollections;
import alexiil.mc.lib.attributes.item.filter.AggregateItemFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.filter.ItemStackFilterUtil;
import alexiil.mc.lib.attributes.misc.OpenWrapper;
import java.util.Set;
import net.minecraft.class_1799;

public class GroupedItemInvViewFixedWrapper
implements GroupedItemInvView,
OpenWrapper {
    final FixedItemInvView inv;

    public GroupedItemInvViewFixedWrapper(FixedItemInvView inv) {
        this.inv = inv;
    }

    @Override
    public Set<class_1799> getStoredStacks() {
        Set<class_1799> set = ItemStackCollections.set();
        for (int s = 0; s < this.inv.getSlotCount(); ++s) {
            class_1799 stack = this.inv.getInvStack(s);
            if (stack.method_7960()) continue;
            set.add(stack);
        }
        return set;
    }

    @Override
    public int getTotalCapacity() {
        int total = 0;
        for (int i = 0; i < this.inv.getSlotCount(); ++i) {
            total += this.inv.getMaxAmount(i, class_1799.field_8037);
        }
        return total;
    }

    @Override
    public GroupedItemInvView.ItemInvStatistic getStatistics(ItemFilter filter) {
        int amount = 0;
        int space = 0;
        int totalSpace = 0;
        boolean totalSpaceValid = true;
        for (int s = 0; s < this.inv.getSlotCount(); ++s) {
            class_1799 stack = this.inv.getInvStack(s);
            if (!stack.method_7960()) {
                if (!filter.matches(stack)) continue;
                amount += stack.method_7947();
                int max = this.inv.getMaxAmount(s, stack);
                space += max - stack.method_7947();
                continue;
            }
            ItemFilter realFilter = AggregateItemFilter.and(filter, this.inv.getFilterForSlot(s));
            int max = ItemStackFilterUtil.findMaximumStackAmount(realFilter);
            if ((max = Math.min(max, this.inv.getMaxAmount(s, stack))) < 0) {
                totalSpaceValid = true;
                continue;
            }
            totalSpace += max;
        }
        return new GroupedItemInvView.ItemInvStatistic(filter, amount, space, totalSpaceValid ? totalSpace : -1);
    }

    @Override
    public int getChangeValue() {
        return this.inv.getChangeValue();
    }

    @Override
    public ListenerToken addListener(InvMarkDirtyListener listener, ListenerRemovalToken removalToken) {
        return this.inv.addListener(i -> listener.onMarkDirty(this), removalToken);
    }

    @Override
    public ListenerToken addListener(ItemInvAmountChangeListener listener, ListenerRemovalToken removalToken) {
        if (!(this.inv instanceof FixedItemInv.CopyingFixedItemInv)) {
            return null;
        }
        return ((FixedItemInv.CopyingFixedItemInv)this.inv).addListener((FixedItemInvView i, int slot, class_1799 previous, class_1799 current) -> {
            if (previous.method_7960()) {
                if (!current.method_7960()) {
                    int currentAmount = this.getAmount(current);
                    listener.onChange(this, current, currentAmount - current.method_7947(), currentAmount);
                }
            } else if (current.method_7960()) {
                int previousAmount = this.getAmount(previous);
                listener.onChange(this, previous, previousAmount + previous.method_7947(), previousAmount);
            } else if (class_1799.method_7973((class_1799)previous, (class_1799)current)) {
                int currentAmount = this.getAmount(current);
                int diff = current.method_7947() - previous.method_7947();
                listener.onChange(this, current, currentAmount - diff, currentAmount);
            } else {
                int currentAmount = this.getAmount(current);
                int previousAmount = this.getAmount(previous);
                listener.onChange(this, current, currentAmount - current.method_7947(), currentAmount);
                listener.onChange(this, previous, previousAmount + previous.method_7947(), previousAmount);
            }
        }, removalToken);
    }

    public Object getWrapped() {
        return this.inv;
    }
}

