/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.AttributeUtil;
import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.GroupedItemInv;
import alexiil.mc.lib.attributes.item.ItemInvSlotChangeListener;
import alexiil.mc.lib.attributes.item.ItemStackUtil;
import alexiil.mc.lib.attributes.item.ItemTransferable;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.GroupedItemInvFixedWrapper;
import alexiil.mc.lib.attributes.item.impl.ItemInvModificationTracker;
import alexiil.mc.lib.attributes.misc.Saveable;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class FullFixedItemInv
implements FixedItemInv.CopyingFixedItemInv,
ItemTransferable,
Saveable {
    private static final ItemInvSlotChangeListener[] NO_LISTENERS = new ItemInvSlotChangeListener[0];
    private static final ItemInvSlotChangeListener[] INVALIDATING_LISTENERS = new ItemInvSlotChangeListener[0];
    protected final class_2371<class_1799> slots;
    private final GroupedItemInv groupedVersion = new GroupedItemInvFixedWrapper(this);
    private int changes = 0;
    private ItemInvSlotChangeListener ownerListener;
    private final Map<ItemInvSlotChangeListener, ListenerRemovalToken> listeners = new Object2ObjectLinkedOpenCustomHashMap(class_156.method_655());
    private ItemInvSlotChangeListener[] bakedListeners = NO_LISTENERS;

    public FullFixedItemInv(int invSize) {
        Class<?> cls;
        this.slots = class_2371.method_10213((int)invSize, (Object)class_1799.field_8037);
        if (AttributeUtil.EXPENSIVE_DEBUG_CHECKS && (cls = this.getClass()) != FullFixedItemInv.class) {
            try {
                boolean overriden2;
                Method method1 = cls.getMethod("isItemValidForSlot", Integer.TYPE, class_1799.class);
                Method method2 = cls.getMethod("getFilterForSlot", Integer.TYPE);
                boolean overriden1 = method1.getDeclaringClass() != FullFixedItemInv.class;
                boolean bl = overriden2 = method2.getDeclaringClass() != FullFixedItemInv.class;
                if (overriden1 != overriden2) {
                    throw new IllegalStateException("The subclass " + method2.getDeclaringClass() + " has overriden isItemValidForSlot() or getFilterForSlot() without overriding the other!");
                }
            }
            catch (ReflectiveOperationException roe) {
                throw new Error("Failed to get the isItemValidForSlot method! I'm not sure what to do now, as this shouldn't happen normally :(", roe);
            }
        }
    }

    @Override
    public final int getSlotCount() {
        return this.slots.size();
    }

    @Override
    public class_1799 getUnmodifiableInvStack(int slot) {
        class_1799 stack = (class_1799)this.slots.get(slot);
        ItemInvModificationTracker.trackNeverChanging(stack);
        return stack;
    }

    @Override
    public boolean isItemValidForSlot(int slot, class_1799 item) {
        return true;
    }

    @Override
    public ItemFilter getFilterForSlot(int slot) {
        return ConstantItemFilter.ANYTHING;
    }

    @Override
    public GroupedItemInv getGroupedInv() {
        return this.groupedVersion;
    }

    @Override
    public int getChangeValue() {
        return this.changes;
    }

    @Override
    public ListenerToken addListener(ItemInvSlotChangeListener listener, ListenerRemovalToken removalToken) {
        if (this.bakedListeners == INVALIDATING_LISTENERS) {
            return null;
        }
        ListenerRemovalToken previous = this.listeners.put(listener, removalToken);
        if (previous == null) {
            this.bakeListeners();
        } else assert (previous == removalToken) : "The same listener object must be registered with the same removal token";
        return () -> {
            ListenerRemovalToken token = this.listeners.remove(listener);
            if (token != null) {
                assert (token == removalToken);
                this.bakeListeners();
                removalToken.onListenerRemoved();
            }
        };
    }

    public void setOwnerListener(ItemInvSlotChangeListener ownerListener) {
        this.ownerListener = ownerListener;
    }

    private void bakeListeners() {
        this.bakedListeners = this.listeners.keySet().toArray(new ItemInvSlotChangeListener[0]);
    }

    public void invalidateListeners() {
        this.bakedListeners = INVALIDATING_LISTENERS;
        ListenerRemovalToken[] removalTokens = this.listeners.values().toArray(new ListenerRemovalToken[0]);
        this.listeners.clear();
        for (ListenerRemovalToken token : removalTokens) {
            token.onListenerRemoved();
        }
        this.bakedListeners = NO_LISTENERS;
    }

    protected final void fireSlotChange(int slot, class_1799 previous, class_1799 current) {
        ItemInvSlotChangeListener[] baked;
        ++this.changes;
        if (this.ownerListener != null) {
            this.ownerListener.onChange(this, slot, previous, current);
        }
        for (ItemInvSlotChangeListener listener : baked = this.bakedListeners) {
            listener.onChange(this, slot, previous, current);
        }
    }

    @Override
    public boolean setInvStack(int slot, class_1799 to, Simulation simulation) {
        boolean allowed = false;
        if (to.method_7960()) {
            allowed = true;
        } else {
            class_1799 current = this.getInvStack(slot);
            if (!current.method_7960() && current.method_7947() > to.method_7947() && ItemStackUtil.areEqualIgnoreAmounts(to, current)) {
                allowed = true;
            } else if (this.isItemValidForSlot(slot, to) && to.method_7947() <= this.getMaxAmount(slot, to)) {
                allowed = true;
            }
        }
        if (allowed) {
            if (simulation == Simulation.ACTION) {
                class_1799 before = (class_1799)this.slots.get(slot);
                ItemInvModificationTracker.trackNeverChanging(before);
                ItemInvModificationTracker.trackNeverChanging(to);
                this.slots.set(slot, (Object)to);
                this.fireSlotChange(slot, before, to);
                ItemInvModificationTracker.trackNeverChanging(before);
                ItemInvModificationTracker.trackNeverChanging(to);
            }
            return true;
        }
        return false;
    }

    public final class_2487 toTag() {
        return this.toTag(new class_2487());
    }

    public class_2487 toTag(class_2487 tag) {
        class_2499 slotsTag = new class_2499();
        for (class_1799 stack : this.slots) {
            ItemInvModificationTracker.trackNeverChanging(stack);
            if (stack.method_7960()) {
                slotsTag.add((Object)new class_2487());
                continue;
            }
            slotsTag.add((Object)stack.method_7953(new class_2487()));
        }
        tag.method_10566("slots", (class_2520)slotsTag);
        return tag;
    }

    public void fromTag(class_2487 tag) {
        int i;
        class_2499 slotsTag = tag.method_10554("slots", (int)new class_2487().method_10711());
        for (i = 0; i < slotsTag.size() && i < this.slots.size(); ++i) {
            this.slots.set(i, (Object)class_1799.method_7915((class_2487)slotsTag.method_10602(i)));
        }
        for (i = slotsTag.size(); i < this.slots.size(); ++i) {
            this.slots.set(i, (Object)class_1799.field_8037);
        }
    }

    @Override
    public class_1799 attemptInsertion(class_1799 stack, Simulation simulation) {
        return this.groupedVersion.attemptInsertion(stack, simulation);
    }

    @Override
    public ItemFilter getInsertionFilter() {
        return this.groupedVersion.getInsertionFilter();
    }

    @Override
    public class_1799 attemptExtraction(ItemFilter filter, int maxAmount, Simulation simulation) {
        return this.groupedVersion.attemptExtraction(filter, maxAmount, simulation);
    }

    @Override
    public class_1799 attemptAnyExtraction(int maxAmount, Simulation simulation) {
        return this.groupedVersion.attemptAnyExtraction(maxAmount, simulation);
    }
}

