/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.item.GroupedItemInvView;
import alexiil.mc.lib.attributes.item.ItemInvAmountChangeListener;
import alexiil.mc.lib.attributes.item.ItemStackCollections;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.misc.AbstractCombined;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1799;

public class CombinedGroupedItemInvView
extends AbstractCombined<GroupedItemInvView>
implements GroupedItemInvView {
    public CombinedGroupedItemInvView(List<? extends GroupedItemInvView> inventories) {
        super(inventories);
    }

    @Override
    public int getAmount(ItemFilter filter) {
        int total = 0;
        for (GroupedItemInvView view : this.list) {
            total += view.getAmount(filter);
        }
        return total;
    }

    @Override
    public int getAmount(class_1799 stack) {
        int total = 0;
        for (GroupedItemInvView view : this.list) {
            total += view.getAmount(stack);
        }
        return total;
    }

    @Override
    public int getSpace(class_1799 stack) {
        int total = 0;
        for (GroupedItemInvView view : this.list) {
            total += view.getSpace(stack);
        }
        return total;
    }

    @Override
    public int getCapacity(class_1799 stack) {
        int total = 0;
        for (GroupedItemInvView view : this.list) {
            total += view.getCapacity(stack);
        }
        return total;
    }

    @Override
    public int getTotalCapacity() {
        int total = 0;
        for (GroupedItemInvView view : this.list) {
            total += view.getTotalCapacity();
        }
        return total;
    }

    @Override
    public GroupedItemInvView.ItemInvStatistic getStatistics(ItemFilter filter) {
        int amount = 0;
        int spaceAddable = 0;
        int spaceTotal = 0;
        for (GroupedItemInvView stats : this.list) {
            GroupedItemInvView.ItemInvStatistic stat = stats.getStatistics(filter);
            amount += stat.amount;
            spaceAddable += stat.spaceAddable;
            spaceTotal += stat.spaceTotal;
        }
        return new GroupedItemInvView.ItemInvStatistic(filter, amount, spaceAddable, spaceTotal);
    }

    @Override
    public Set<class_1799> getStoredStacks() {
        Set<class_1799> set = ItemStackCollections.set();
        for (GroupedItemInvView stats : this.list) {
            set.addAll(stats.getStoredStacks());
        }
        return set;
    }

    @Override
    public int getChangeValue() {
        int total = 0;
        for (GroupedItemInvView inv : this.list) {
            total += inv.getChangeValue();
        }
        return total;
    }

    @Override
    public ListenerToken addListener(ItemInvAmountChangeListener listener, final ListenerRemovalToken removalToken) {
        final ListenerToken[] tokens = new ListenerToken[this.list.size()];
        ListenerRemovalToken ourRemToken = new ListenerRemovalToken(){
            boolean hasAlreadyRemoved = false;

            public void onListenerRemoved() {
                for (ListenerToken token : tokens) {
                    if (token == null) {
                        return;
                    }
                    token.removeListener();
                }
                if (!this.hasAlreadyRemoved) {
                    this.hasAlreadyRemoved = true;
                    removalToken.onListenerRemoved();
                }
            }
        };
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = ((GroupedItemInvView)this.list.get(i)).addListener((GroupedItemInvView inv, class_1799 stack, int previous, int current) -> {
                int totalCurrent = this.getAmount(stack);
                listener.onChange(this, stack, totalCurrent - current + previous, totalCurrent);
            }, ourRemToken);
            if (tokens[i] != null) continue;
            for (int j = 0; j < i; ++j) {
                tokens[j].removeListener();
            }
            return null;
        }
        return () -> {
            for (ListenerToken token : tokens) {
                token.removeListener();
            }
        };
    }
}

