/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.FixedItemInvView;
import alexiil.mc.lib.attributes.item.InvMarkDirtyListener;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.CombinedFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.MappedFixedItemInvView;
import alexiil.mc.lib.attributes.misc.AbstractCombined;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;

public class CombinedFixedItemInvView<InvType extends FixedItemInvView>
extends AbstractCombined<InvType>
implements FixedItemInvView {
    public final List<? extends InvType> views;
    protected final int[] subSlotStartIndex;
    protected final int invSize;

    public CombinedFixedItemInvView(List<? extends InvType> views) {
        super(views);
        this.views = views;
        this.subSlotStartIndex = new int[views.size()];
        int size = 0;
        for (int i = 0; i < views.size(); ++i) {
            this.subSlotStartIndex[i] = size;
            FixedItemInvView view = (FixedItemInvView)views.get(i);
            int s = view.getSlotCount();
            size += s;
        }
        this.invSize = size;
    }

    public static FixedItemInvView createView(List<? extends FixedItemInvView> list) {
        if (list.isEmpty()) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        ArrayList<FixedItemInv> normal = new ArrayList<FixedItemInv>();
        for (FixedItemInvView fixedItemInvView : list) {
            if (fixedItemInvView instanceof FixedItemInv) {
                normal.add((FixedItemInv)fixedItemInvView);
                continue;
            }
            return new CombinedFixedItemInvView<FixedItemInvView>(list);
        }
        return CombinedFixedItemInv.create(normal);
    }

    @Override
    public int getSlotCount() {
        return this.invSize;
    }

    protected int getInvIndex(int slot) {
        if (slot < 0) {
            throw new IllegalArgumentException("Slot must be non-negative! (was " + slot + ")");
        }
        for (int i = 1; i < this.subSlotStartIndex.length; ++i) {
            int startIndex = this.subSlotStartIndex[i];
            if (slot >= startIndex) continue;
            return i - 1;
        }
        if (slot < this.invSize) {
            return this.views.size() - 1;
        }
        throw new IllegalArgumentException("Slot must be less than getInvSize() (was " + slot + ", maximum slot is " + (this.invSize - 1) + ")");
    }

    protected InvType getInv(int slot) {
        return (InvType)((FixedItemInvView)this.views.get(this.getInvIndex(slot)));
    }

    protected int getSubSlot(int slot) {
        if (slot < 0) {
            throw new IllegalArgumentException("Slot must be non-negative! (was " + slot + ")");
        }
        for (int i = 0; i < this.subSlotStartIndex.length; ++i) {
            int startIndex = this.subSlotStartIndex[i];
            if (slot >= startIndex) continue;
            if (i == 0) {
                return slot;
            }
            return slot - this.subSlotStartIndex[i - 1];
        }
        if (slot < this.invSize) {
            return slot - this.subSlotStartIndex[this.subSlotStartIndex.length - 1];
        }
        throw new IllegalArgumentException("Slot must be less than getInvSize() (was " + slot + ", maximum slot is " + (this.invSize - 1) + ")");
    }

    @Override
    public class_1799 getInvStack(int slot) {
        return this.getInv(slot).getInvStack(this.getSubSlot(slot));
    }

    @Override
    public boolean isItemValidForSlot(int slot, class_1799 item) {
        return this.getInv(slot).isItemValidForSlot(this.getSubSlot(slot), item);
    }

    @Override
    public ItemFilter getFilterForSlot(int slot) {
        return this.getInv(slot).getFilterForSlot(this.getSubSlot(slot));
    }

    @Override
    public int getMaxAmount(int slot, class_1799 stack) {
        return this.getInv(slot).getMaxAmount(this.getSubSlot(slot), stack);
    }

    @Override
    public int getChangeValue() {
        int count = 0;
        for (FixedItemInvView inv : this.views) {
            count += inv.getChangeValue();
        }
        return count;
    }

    @Override
    public ListenerToken addListener(InvMarkDirtyListener listener, final ListenerRemovalToken removalToken) {
        final ListenerToken[] tokens = new ListenerToken[this.views.size()];
        ListenerRemovalToken ourRemToken = new ListenerRemovalToken(){
            boolean hasAlreadyRemoved = false;

            public void onListenerRemoved() {
                for (ListenerToken token : tokens) {
                    if (token == null) {
                        return;
                    }
                    token.removeListener();
                }
                if (!this.hasAlreadyRemoved) {
                    this.hasAlreadyRemoved = true;
                    removalToken.onListenerRemoved();
                }
            }
        };
        CombinedFixedItemInvView wrapper = this;
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = ((FixedItemInvView)this.views.get(i)).addListener(inv -> listener.onMarkDirty(wrapper), ourRemToken);
            if (tokens[i] != null) continue;
            for (int j = 0; j < i; ++j) {
                tokens[j].removeListener();
            }
            return null;
        }
        return () -> {
            for (ListenerToken token : tokens) {
                token.removeListener();
            }
        };
    }

    @Override
    public FixedItemInvView getSubInv(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (fromIndex == 0 && toIndex == this.getSlotCount()) {
            return this;
        }
        int invFrom = this.getInvIndex(fromIndex);
        int invTo = this.getInvIndex(toIndex - 1);
        int slotFrom = this.getSubSlot(fromIndex);
        int slotTo = this.getSubSlot(toIndex - 1) + 1;
        if (invFrom == invTo) {
            return ((FixedItemInvView)this.views.get(invFrom)).getSubInv(slotFrom, slotTo);
        }
        List<InvType> subList = this.views.subList(invFrom, invTo + 1);
        if (slotFrom == 0 && slotTo == ((FixedItemInvView)subList.get(subList.size() - 1)).getSlotCount()) {
            return CombinedFixedItemInvView.createView(subList);
        }
        ArrayList<InvType> list = new ArrayList<InvType>(subList);
        list.set(0, ((FixedItemInvView)list.get(0)).getSubInv(slotFrom, ((FixedItemInvView)list.get(0)).getSlotCount()));
        list.set(list.size() - 1, ((FixedItemInvView)list.get(list.size() - 1)).getSubInv(0, slotTo));
        return CombinedFixedItemInvView.createView(list);
    }

    @Override
    public FixedItemInvView getMappedInv(int ... slots) {
        int i;
        if (slots.length == 0) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (FixedItemInvView.areSlotArraysEqual(this, slots)) {
            return this;
        }
        Int2ObjectRBTreeMap invSlotCount = new Int2ObjectRBTreeMap();
        int[] inventoryIndexes = new int[slots.length];
        int[] inventorySlots = new int[slots.length];
        IntOpenHashSet seenSlots = new IntOpenHashSet();
        for (int i2 = 0; i2 < slots.length; ++i2) {
            if (!seenSlots.add(slots[i2])) {
                throw new IllegalArgumentException("Duplicate slot " + slots[i2] + " " + Arrays.toString(slots));
            }
            int inv = this.getInvIndex(slots[i2]);
            IntList list = (IntList)invSlotCount.get(inv);
            if (list == null) {
                list = new IntArrayList();
                invSlotCount.put(inv, (Object)list);
            }
            int sub = this.getSubSlot(slots[i2]);
            list.add(sub);
            inventoryIndexes[i2] = inv;
            inventorySlots[i2] = sub;
        }
        if (invSlotCount.size() == 1) {
            return ((FixedItemInvView)this.views.get(invSlotCount.keySet().iterator().nextInt())).getMappedInv(inventorySlots);
        }
        ArrayList<FixedItemInvView> invs = new ArrayList<FixedItemInvView>();
        for (Int2ObjectMap.Entry entry : invSlotCount.int2ObjectEntrySet()) {
            int inv = entry.getIntKey();
            IntList invSlots = (IntList)entry.getValue();
            invs.add(((FixedItemInvView)this.views.get(inv)).getMappedInv(invSlots.toIntArray()));
        }
        int[] mappedSlots = new int[slots.length];
        int[] inventorySlotCounter = new int[invs.size()];
        int[] inventoryStartIndexes = new int[invs.size()];
        int currentIndex = 0;
        for (i = 0; i < invs.size(); ++i) {
            inventoryIndexes[i] = currentIndex;
            currentIndex += ((FixedItemInvView)invs.get(i)).getSlotCount();
        }
        for (i = 0; i < slots.length; ++i) {
            int invCount;
            int inv;
            int n = inv = inventoryIndexes[i];
            inventorySlotCounter[n] = inventorySlotCounter[n] + 1;
            mappedSlots[i] = invCount + inventoryStartIndexes[inv];
        }
        FixedItemInvView combined = CombinedFixedItemInvView.createView(invs);
        return MappedFixedItemInvView.createView(combined, mappedSlots);
    }
}

