/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.filter;

import alexiil.mc.lib.attributes.item.filter.AggregateItemFilter;
import alexiil.mc.lib.attributes.item.filter.InvertedItemFilter;
import java.util.function.Predicate;
import net.minecraft.class_1799;

@FunctionalInterface
public interface ItemFilter {
    public boolean matches(class_1799 var1);

    default public ItemFilter negate() {
        return new InvertedItemFilter(this);
    }

    default public ItemFilter and(ItemFilter other) {
        return AggregateItemFilter.and(this, other);
    }

    default public ItemFilter or(ItemFilter other) {
        return AggregateItemFilter.or(this, other);
    }

    default public Predicate<class_1799> asPredicate() {
        return new ItemFilterAsPredicate(this);
    }

    public static final class ItemFilterAsPredicate
    implements Predicate<class_1799> {
        public final ItemFilter filter;

        public ItemFilterAsPredicate(ItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean test(class_1799 stack) {
            if (stack == null || stack.method_7960()) {
                return false;
            }
            return this.filter.matches(stack);
        }

        @Override
        public Predicate<class_1799> negate() {
            return this.filter.negate().asPredicate();
        }

        @Override
        public Predicate<class_1799> and(Predicate<? super class_1799> other) {
            if (other instanceof ItemFilter) {
                return this.filter.and((ItemFilter)((Object)other)).asPredicate();
            }
            if (other instanceof ItemFilterAsPredicate) {
                return this.filter.and(((ItemFilterAsPredicate)other).filter).asPredicate();
            }
            return Predicate.super.and(other);
        }

        @Override
        public Predicate<class_1799> or(Predicate<? super class_1799> other) {
            if (other instanceof ItemFilter) {
                return this.filter.or((ItemFilter)((Object)other)).asPredicate();
            }
            if (other instanceof ItemFilterAsPredicate) {
                return this.filter.or(((ItemFilterAsPredicate)other).filter).asPredicate();
            }
            return Predicate.super.and(other);
        }
    }
}

