/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.filter;

import alexiil.mc.lib.attributes.AggregateFilterType;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ExactItemFilter;
import alexiil.mc.lib.attributes.item.filter.ExactItemStackFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.filter.ReadableItemFilter;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public final class AggregateItemFilter
implements ReadableItemFilter,
Iterable<ItemFilter> {
    public final AggregateFilterType type;
    private final ItemFilter[] filters;

    public AggregateItemFilter(AggregateFilterType type, ItemFilter ... filters) {
        if (filters.length < 2) {
            throw new IllegalArgumentException("There's no reason to construct an aggregate stack filter that matches " + filters.length + " filters!");
        }
        this.type = type;
        this.filters = filters;
    }

    public static ItemFilter and(ItemFilter filterA, ItemFilter filterB) {
        return AggregateItemFilter.combine(AggregateFilterType.ALL, filterA, filterB);
    }

    public static ItemFilter or(ItemFilter filterA, ItemFilter filterB) {
        return AggregateItemFilter.combine(AggregateFilterType.ANY, filterA, filterB);
    }

    public static ItemFilter combine(AggregateFilterType type, ItemFilter filterA, ItemFilter filterB) {
        boolean all;
        boolean bl = all = type == AggregateFilterType.ALL;
        if (filterA == filterB) {
            return filterA;
        }
        if (filterA == ConstantItemFilter.ANYTHING) {
            return all ? filterB : ConstantItemFilter.ANYTHING;
        }
        if (filterB == ConstantItemFilter.ANYTHING) {
            return all ? filterA : ConstantItemFilter.ANYTHING;
        }
        if (filterA == ConstantItemFilter.NOTHING) {
            return all ? ConstantItemFilter.NOTHING : filterB;
        }
        if (filterB == ConstantItemFilter.NOTHING) {
            return all ? ConstantItemFilter.NOTHING : filterA;
        }
        if (filterA instanceof AggregateItemFilter && ((AggregateItemFilter)filterA).type == type) {
            if (filterB instanceof AggregateItemFilter && ((AggregateItemFilter)filterB).type == type) {
                ItemFilter[] filtersA = ((AggregateItemFilter)filterA).filters;
                ItemFilter[] filtersB = ((AggregateItemFilter)filterB).filters;
                ItemFilter[] filters = new ItemFilter[filtersA.length + filtersB.length];
                System.arraycopy(filtersA, 0, filters, 0, filtersA.length);
                System.arraycopy(filtersB, 0, filters, filtersA.length, filtersB.length);
                return new AggregateItemFilter(type, filters);
            }
            ItemFilter[] from = ((AggregateItemFilter)filterA).filters;
            ItemFilter[] filters = new ItemFilter[from.length + 1];
            System.arraycopy(from, 0, filters, 0, from.length);
            filters[from.length] = filterB;
            return new AggregateItemFilter(type, filters);
        }
        if (filterB instanceof AggregateItemFilter && ((AggregateItemFilter)filterB).type == type) {
            ItemFilter[] from = ((AggregateItemFilter)filterB).filters;
            ItemFilter[] filters = new ItemFilter[from.length + 1];
            System.arraycopy(from, 0, filters, 0, from.length);
            filters[from.length] = filterA;
            return new AggregateItemFilter(type, filters);
        }
        if (filterA instanceof ExactItemStackFilter) {
            class_1799 exactA = ((ExactItemStackFilter)filterA).stack;
            if (filterB.matches(exactA)) {
                return filterA;
            }
            if (all) {
                return ConstantItemFilter.NOTHING;
            }
        }
        if (filterB instanceof ExactItemStackFilter) {
            class_1799 exactB = ((ExactItemStackFilter)filterB).stack;
            if (filterA.matches(exactB)) {
                return filterB;
            }
            if (all) {
                return ConstantItemFilter.NOTHING;
            }
        }
        return new AggregateItemFilter(type, filterA, filterB);
    }

    public static ItemFilter allOf(ItemFilter ... filters) {
        return AggregateItemFilter.combine(AggregateFilterType.ALL, filters);
    }

    public static ItemFilter anyOf(ItemFilter ... filters) {
        return AggregateItemFilter.combine(AggregateFilterType.ANY, filters);
    }

    public static ItemFilter anyOf(class_1799 ... stacks) {
        if (stacks == null || stacks.length == 0) {
            return ConstantItemFilter.NOTHING;
        }
        if (stacks.length == 1) {
            return new ExactItemStackFilter(stacks[0]);
        }
        ItemFilter[] filters = new ItemFilter[stacks.length];
        int i = 0;
        for (class_1799 item : stacks) {
            filters[i++] = new ExactItemStackFilter(item);
        }
        return AggregateItemFilter.anyOf(filters);
    }

    public static ItemFilter anyOf(class_1792 ... items) {
        if (items == null || items.length == 0) {
            return ConstantItemFilter.NOTHING;
        }
        if (items.length == 1) {
            return new ExactItemFilter(items[0]);
        }
        ItemFilter[] filters = new ItemFilter[items.length];
        int i = 0;
        for (class_1792 item : items) {
            filters[i++] = new ExactItemFilter(item);
        }
        return AggregateItemFilter.anyOf(filters);
    }

    public static ItemFilter combine(AggregateFilterType type, ItemFilter ... filters) {
        return AggregateItemFilter.combine(type, Arrays.asList(filters));
    }

    public static ItemFilter allOf(List<? extends ItemFilter> filters) {
        return AggregateItemFilter.combine(AggregateFilterType.ALL, filters);
    }

    public static ItemFilter anyOf(List<? extends ItemFilter> filters) {
        return AggregateItemFilter.combine(AggregateFilterType.ANY, filters);
    }

    public static ItemFilter combine(AggregateFilterType type, List<? extends ItemFilter> filters) {
        if (!(filters instanceof RandomAccess)) {
            filters = Arrays.asList(filters.toArray(new ItemFilter[0]));
        }
        switch (filters.size()) {
            case 0: {
                return ConstantItemFilter.ANYTHING;
            }
            case 1: {
                return filters.get(0);
            }
            case 2: {
                return AggregateItemFilter.combine(type, filters.get(0), filters.get(1));
            }
        }
        ItemFilter filter = filters.get(0);
        for (int i = 1; i < filters.size(); ++i) {
            filter = AggregateItemFilter.combine(type, filter, filters.get(i));
        }
        return filter;
    }

    @Override
    public boolean matches(class_1799 stack) {
        if (this.type == AggregateFilterType.ALL) {
            for (ItemFilter filter : this.filters) {
                if (filter.matches(stack)) continue;
                return false;
            }
            return true;
        }
        for (ItemFilter filter : this.filters) {
            if (!filter.matches(stack)) continue;
            return true;
        }
        return false;
    }

    public int getFilterCount() {
        return this.filters.length;
    }

    public ItemFilter getFilter(int index) {
        return this.filters[index];
    }

    @Override
    public Iterator<ItemFilter> iterator() {
        return Iterators.forArray((Object[])this.filters);
    }
}

