/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.compat;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.compat.InventoryFixedWrapper;
import java.util.Arrays;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public abstract class SidedInventoryFixedWrapper
extends InventoryFixedWrapper
implements class_1278 {
    private int[][] availableSlots;

    public SidedInventoryFixedWrapper(FixedItemInv inv) {
        super(inv);
        this.resetSlotsToAll();
    }

    private static int[][] createFullArray(FixedItemInv inv) {
        int[] a = SidedInventoryFixedWrapper.createSingleArray(inv);
        return new int[][]{a, a, a, a, a, a, a};
    }

    private static int[] createSingleArray(FixedItemInv inv) {
        int[] a = new int[inv.getSlotCount()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        return a;
    }

    public SidedInventoryFixedWrapper(FixedItemInv inv, int[][] slotMap) {
        super(inv);
        this.resetSlotsTo(slotMap);
    }

    protected void resetSlotsToAll() {
        this.availableSlots = SidedInventoryFixedWrapper.createFullArray(this.inv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetSlotsTo(int[][] slotMap) {
        if (slotMap != null && slotMap.length != 0) {
            if (slotMap.length != 6 && slotMap.length != 7) throw new IllegalArgumentException("The given slot map was of an invalid length (" + slotMap.length + ")!\n\tIt must be either 0, 6, or 7!");
            int[][] nArray = slotMap;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] arr;
                for (int slot : arr = nArray[i]) {
                    if (slot >= 0 && slot < this.inv.getSlotCount()) continue;
                    throw new IllegalArgumentException("Invalid slot index (" + slot + ", max = " + (this.inv.getSlotCount() - 1) + ") in the slot map " + Arrays.deepToString((Object[])slotMap));
                }
            }
            this.availableSlots = slotMap.length == 6 ? (Object)new int[][]{slotMap[0], slotMap[1], slotMap[2], slotMap[3], slotMap[4], slotMap[5], SidedInventoryFixedWrapper.createSingleArray(this.inv)} : slotMap;
            return;
        } else {
            this.availableSlots = SidedInventoryFixedWrapper.createFullArray(this.inv);
        }
    }

    public int[] method_5494(class_2350 dir) {
        return SidedInventoryFixedWrapper.copy(this.getSlotsInternal(dir));
    }

    private int[] getSlotsInternal(class_2350 dir) {
        return this.availableSlots[dir == null ? 6 : dir.ordinal()];
    }

    private static int[] copy(int[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        int[] slots;
        for (int s : slots = this.getSlotsInternal(dir)) {
            if (s != slot) continue;
            return this.inv.insertStack(s, stack, Simulation.SIMULATE).method_7960();
        }
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        int[] slots;
        for (int s : slots = this.getSlotsInternal(dir)) {
            if (s != slot) continue;
            return !this.inv.extractStack(slot, null, class_1799.field_8037, 1, Simulation.SIMULATE).method_7960();
        }
        return false;
    }
}

