/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item.compat;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.impl.ItemInvModificationTracker;
import alexiil.mc.lib.attributes.misc.OpenWrapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

public abstract class InventoryFixedWrapper
implements class_1263,
OpenWrapper {
    protected final FixedItemInv inv;
    private final Int2ObjectMap<SlotStatus> slotStatus = new Int2ObjectOpenHashMap();

    public InventoryFixedWrapper(FixedItemInv inv) {
        this.inv = inv;
    }

    public void method_5448() {
        for (int s = 0; s < this.inv.getSlotCount(); ++s) {
            this.inv.setInvStack(s, class_1799.field_8037, Simulation.ACTION);
        }
        this.slotStatus.clear();
    }

    public int method_5439() {
        return this.inv.getSlotCount();
    }

    public boolean method_5442() {
        for (int s = 0; s < this.inv.getSlotCount(); ++s) {
            if (this.inv.getInvStack(s).method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        SlotStatus prev = (SlotStatus)this.slotStatus.remove(slot);
        if (prev != null) {
            prev.process(this, slot);
        }
        class_1799 current = this.inv.getInvStack(slot);
        SlotStatus status = new SlotStatus(current);
        this.slotStatus.put(slot, (Object)status);
        return status.returned;
    }

    public class_1799 method_5434(int slot, int amount) {
        SlotStatus status = (SlotStatus)this.slotStatus.remove(slot);
        if (status != null) {
            status.validate(this, slot);
        }
        return this.inv.extractStack(slot, null, class_1799.field_8037, amount, Simulation.ACTION);
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack = this.method_5438(slot);
        this.method_5447(slot, class_1799.field_8037);
        return stack;
    }

    public void method_5447(int slot, class_1799 to) {
        SlotStatus status = (SlotStatus)this.slotStatus.remove(slot);
        if (status != null) {
            status.validate(this, slot);
        }
        status = new SlotStatus(to.method_7972(), to);
        this.slotStatus.put(slot, (Object)status);
        this.setInvStackInternal(slot, status.originalCopy);
    }

    public boolean softSetInvStack(int slot, class_1799 to) {
        SlotStatus status = (SlotStatus)this.slotStatus.remove(slot);
        if (status != null) {
            status.validate(this, slot);
        }
        status = new SlotStatus(to.method_7972(), to);
        if (this.inv.setInvStack(slot, status.originalCopy, Simulation.ACTION)) {
            this.slotStatus.put(slot, (Object)status);
            return true;
        }
        return false;
    }

    void setInvStackInternal(int slot, class_1799 to) {
        if (!this.inv.setInvStack(slot, to, Simulation.ACTION)) {
            throw new IllegalStateException("The FixedItemInv " + this.inv.getClass() + " didn't accept the stack " + to + " in slot " + slot + "! The inventory may be in a duped (invalid) state!");
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.inv.isItemValidForSlot(slot, stack);
    }

    public void method_5431() {
        if (this.slotStatus.isEmpty()) {
            return;
        }
        for (int slot : this.slotStatus.keySet().toIntArray()) {
            ((SlotStatus)this.slotStatus.remove(slot)).process(this, slot);
        }
        assert (this.slotStatus.isEmpty());
    }

    public Object getWrapped() {
        return this.inv;
    }

    static final class SlotStatus {
        final class_1799 originalCopy;
        final class_1799 returned;

        public SlotStatus(class_1799 current) {
            this(current.method_7972(), current.method_7972());
        }

        public SlotStatus(class_1799 originalCopy, class_1799 returned) {
            this.originalCopy = originalCopy;
            this.returned = returned;
        }

        void validate(InventoryFixedWrapper inv, int slot) {
            class_1799 current = inv.inv.getInvStack(slot);
            if (!class_1799.method_7973((class_1799)this.originalCopy, (class_1799)current) && !class_1799.method_7973((class_1799)this.originalCopy, (class_1799)this.returned)) {
                throw new IllegalStateException("The inventory has been modifed in two places at once! (\n\tcurrent = " + ItemInvModificationTracker.stackToFullString(current) + ", \n\toriginal = " + ItemInvModificationTracker.stackToFullString(this.originalCopy) + ", \n\tnew = " + ItemInvModificationTracker.stackToFullString(this.returned) + ")");
            }
        }

        void process(InventoryFixedWrapper inv, int slot) {
            this.validate(inv, slot);
            if (class_1799.method_7973((class_1799)this.returned, (class_1799)this.originalCopy)) {
                return;
            }
            inv.setInvStackInternal(slot, this.returned);
            ItemInvModificationTracker.trackNeverChanging(this.returned);
        }
    }
}

