/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.ItemExtractable;
import alexiil.mc.lib.attributes.item.ItemInsertable;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.FilteredItemTransferable;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;

public interface ItemTransferable
extends ItemInsertable,
ItemExtractable {
    @Override
    default public ItemTransferable filtered(ItemFilter filter) {
        return new FilteredItemTransferable(this, filter);
    }

    @Nonnull
    public static ItemTransferable from(final ItemInsertable insertable) {
        return new ItemTransferable(){

            @Override
            public class_1799 attemptInsertion(class_1799 stack, Simulation simulation) {
                return insertable.attemptInsertion(stack, simulation);
            }

            @Override
            public ItemFilter getInsertionFilter() {
                return insertable.getInsertionFilter();
            }

            @Override
            public class_1799 attemptExtraction(ItemFilter filter, int maxAmount, Simulation simulation) {
                return class_1799.field_8037;
            }
        };
    }

    @Nonnull
    public static ItemTransferable from(final ItemExtractable extractable) {
        return new ItemTransferable(){

            @Override
            public class_1799 attemptInsertion(class_1799 stack, Simulation simulation) {
                return stack;
            }

            @Override
            public ItemFilter getInsertionFilter() {
                return ConstantItemFilter.NOTHING;
            }

            @Override
            public class_1799 attemptExtraction(ItemFilter filter, int maxAmount, Simulation simulation) {
                return extractable.attemptExtraction(filter, maxAmount, simulation);
            }

            @Override
            public class_1799 attemptAnyExtraction(int maxAmount, Simulation simulation) {
                return extractable.attemptAnyExtraction(maxAmount, simulation);
            }
        };
    }

    @Nonnull
    public static ItemTransferable from(final ItemInsertable insertable, final ItemExtractable extractable) {
        if (insertable == extractable && insertable instanceof ItemTransferable) {
            return (ItemTransferable)insertable;
        }
        return new ItemTransferable(){

            @Override
            public class_1799 attemptInsertion(class_1799 stack, Simulation simulation) {
                return insertable.attemptInsertion(stack, simulation);
            }

            @Override
            public ItemFilter getInsertionFilter() {
                return insertable.getInsertionFilter();
            }

            @Override
            public class_1799 attemptExtraction(ItemFilter filter, int maxAmount, Simulation simulation) {
                return extractable.attemptExtraction(filter, maxAmount, simulation);
            }

            @Override
            public class_1799 attemptAnyExtraction(int maxAmount, Simulation simulation) {
                return extractable.attemptAnyExtraction(maxAmount, simulation);
            }
        };
    }
}

