/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.FixedItemInvView;
import alexiil.mc.lib.attributes.item.ItemExtractable;
import alexiil.mc.lib.attributes.item.ItemInsertable;
import alexiil.mc.lib.attributes.item.filter.AggregateItemFilter;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ExactItemStackFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.misc.PlayerInvUtil;
import alexiil.mc.lib.attributes.misc.Reference;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public final class ItemInvUtil {
    private ItemInvUtil() {
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static Consumer<class_1799> createPlayerInsertable(class_1657 player) {
        return PlayerInvUtil.createPlayerInsertable((class_1657)player);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static Reference<class_1799> referenceHand(class_1657 player, class_1268 hand) {
        return PlayerInvUtil.referenceHand((class_1657)player, (class_1268)hand);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static Reference<class_1799> referenceGuiCursor(class_3222 player) {
        return PlayerInvUtil.referenceGuiCursor((class_3222)player);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static void insertItemIntoPlayerInventory(class_1657 player, class_1799 stack) {
        PlayerInvUtil.insertItemIntoPlayerInventory((class_1657)player, (class_1799)stack);
    }

    public static int move(ItemExtractable from, ItemInsertable to, int maximum) {
        return ItemInvUtil.move(from, to, null, maximum);
    }

    public static int move(ItemExtractable from, ItemInsertable to, ItemFilter filter, int maximum) {
        return ItemInvUtil.move(from, to, filter, maximum, Simulation.ACTION);
    }

    public static int move(ItemExtractable from, ItemInsertable to, ItemFilter filter, int maximum, Simulation simulation) {
        class_1799 extracted;
        if (maximum <= 0) {
            return 0;
        }
        ItemFilter insertionFilter = to.getInsertionFilter();
        if (filter != null && filter != ConstantItemFilter.ANYTHING) {
            insertionFilter = AggregateItemFilter.and(insertionFilter, filter);
        }
        if ((extracted = from.attemptExtraction(insertionFilter, maximum, Simulation.SIMULATE)).method_7960()) {
            return 0;
        }
        class_1799 leftover = to.attemptInsertion(extracted, simulation);
        int insertedAmount = extracted.method_7947() - (leftover.method_7960() ? 0 : leftover.method_7947());
        if (insertedAmount == 0) {
            return 0;
        }
        class_1799 reallyExtracted = from.attemptExtraction(new ExactItemStackFilter(extracted), insertedAmount, simulation);
        if (reallyExtracted.method_7960()) {
            throw ItemInvUtil.throwBadImplException("Tried to extract the filter (C) from A but it returned an empty item stack after we have already inserted the expected stack into B!\nThe inventory is now in an invalid (duped) state!", new String[]{"from A", "to B", "filter C"}, new Object[]{from, to, filter});
        }
        if (reallyExtracted.method_7947() != insertedAmount) {
            throw ItemInvUtil.throwBadImplException("Tried to extract " + insertedAmount + " but we actually extracted " + reallyExtracted.method_7947() + "!\nThe inventory is now in an invalid (duped) state!", new String[]{"from A", "to B", "filter C", "originally extracted", "really extracted"}, new Object[]{from, to, insertionFilter, extracted, reallyExtracted});
        }
        return insertedAmount;
    }

    public static MultiMoveResult moveMultiple(ItemExtractable from, ItemInsertable to) {
        return ItemInvUtil.moveMultiple(from, to, ConstantItemFilter.ANYTHING, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static MultiMoveResult moveMultiple(ItemExtractable from, ItemInsertable to, int maxStacks, int maxTotal) {
        return ItemInvUtil.moveMultiple(from, to, ConstantItemFilter.ANYTHING, maxStacks, maxTotal);
    }

    public static MultiMoveResult moveMultiple(ItemExtractable from, ItemInsertable to, ItemFilter filter, int maxStacks, int maxTotal) {
        int moved;
        int stacks;
        int itemsMoved = 0;
        for (stacks = 0; stacks < maxStacks && (moved = ItemInvUtil.move(from, to, filter, maxTotal - itemsMoved)) > 0; ++stacks) {
            itemsMoved += moved;
        }
        return new MultiMoveResult(stacks, itemsMoved);
    }

    public static void copyAll(FixedItemInvView inv, List<class_1799> dest) {
        for (int slot = 0; slot < inv.getSlotCount(); ++slot) {
            class_1799 stack = inv.getInvStack(slot);
            if (!(inv instanceof FixedItemInv.CopyingFixedItemInv)) {
                stack = stack.method_7972();
            }
            if (stack.method_7960()) continue;
            dest.add(stack);
        }
    }

    @Deprecated(since="0.8.0", forRemoval=true)
    public static class_1799 insertSingle(FixedItemInv inv, int slot, class_1799 toInsert, Simulation simulation) {
        return inv.insertStack(slot, toInsert, simulation);
    }

    @Deprecated(since="0.8.0", forRemoval=true)
    public static class_1799 extractSingle(FixedItemInv inv, int slot, @Nullable ItemFilter filter, class_1799 toAddWith, int maxAmount, Simulation simulation) {
        return inv.extractStack(slot, filter, toAddWith, maxAmount, simulation);
    }

    private static IllegalStateException throwBadImplException(String reason, String[] names, Object[] objs) {
        Object detail = "\n";
        int max = Math.max(names.length, objs.length);
        for (int i = 0; i < max; ++i) {
            String name = names.length <= i ? "?" : names[i];
            String obj = objs.length <= i ? "" : objs[i];
            detail = (String)detail + "\n" + name + " = " + obj;
        }
        throw new IllegalStateException(reason + (String)detail);
    }

    public static final class MultiMoveResult {
        public final int stacksMoved;
        public final int itemsMoved;

        public MultiMoveResult(int stacksMoved, int itemsMoved) {
            this.stacksMoved = stacksMoved;
            this.itemsMoved = itemsMoved;
        }

        public boolean didMoveAny() {
            return this.itemsMoved > 0;
        }
    }
}

