/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item;

import alexiil.mc.lib.attributes.Attribute;
import alexiil.mc.lib.attributes.AttributeCombiner;
import alexiil.mc.lib.attributes.AttributeSourceType;
import alexiil.mc.lib.attributes.Attributes;
import alexiil.mc.lib.attributes.CombinableAttribute;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.FixedItemInvView;
import alexiil.mc.lib.attributes.item.GroupedItemInv;
import alexiil.mc.lib.attributes.item.GroupedItemInvView;
import alexiil.mc.lib.attributes.item.ItemExtractable;
import alexiil.mc.lib.attributes.item.ItemInsertable;
import alexiil.mc.lib.attributes.item.compat.FixedInventoryVanillaWrapper;
import alexiil.mc.lib.attributes.item.compat.FixedSidedInventoryVanillaWrapper;
import alexiil.mc.lib.attributes.item.compat.mod.LbaItemModCompat;
import alexiil.mc.lib.attributes.item.filter.AggregateItemFilter;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.CombinedFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.CombinedFixedItemInvView;
import alexiil.mc.lib.attributes.item.impl.CombinedGroupedItemInv;
import alexiil.mc.lib.attributes.item.impl.CombinedGroupedItemInvView;
import alexiil.mc.lib.attributes.item.impl.CombinedItemExtractable;
import alexiil.mc.lib.attributes.item.impl.CombinedItemInsertable;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.EmptyGroupedItemInv;
import alexiil.mc.lib.attributes.item.impl.EmptyItemExtractable;
import alexiil.mc.lib.attributes.item.impl.RejectingItemInsertable;
import alexiil.mc.lib.attributes.misc.LibBlockAttributes;
import alexiil.mc.lib.attributes.misc.Reference;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3954;

public final class ItemAttributes {
    public static final CombinableAttribute<FixedItemInvView> FIXED_INV_VIEW = ItemAttributes.create(FixedItemInvView.class, EmptyFixedItemInv.INSTANCE, list -> new CombinedFixedItemInvView(list), inv -> inv);
    public static final CombinableAttribute<FixedItemInv> FIXED_INV = ItemAttributes.create(FixedItemInv.class, EmptyFixedItemInv.INSTANCE, list -> new CombinedFixedItemInv(list), Function.identity());
    public static final CombinableAttribute<GroupedItemInvView> GROUPED_INV_VIEW = ItemAttributes.create(GroupedItemInvView.class, EmptyGroupedItemInv.INSTANCE, list -> new CombinedGroupedItemInvView(list), FixedItemInv::getGroupedInv);
    public static final CombinableAttribute<GroupedItemInv> GROUPED_INV = ItemAttributes.create(GroupedItemInv.class, EmptyGroupedItemInv.INSTANCE, list -> new CombinedGroupedItemInv(list), FixedItemInv::getGroupedInv);
    public static final CombinableAttribute<ItemInsertable> INSERTABLE = ItemAttributes.create(ItemInsertable.class, RejectingItemInsertable.NULL, list -> new CombinedItemInsertable(list), FixedItemInv::getInsertable);
    public static final CombinableAttribute<ItemExtractable> EXTRACTABLE = ItemAttributes.create(ItemExtractable.class, EmptyItemExtractable.NULL, list -> new CombinedItemExtractable(list), FixedItemInv::getExtractable);
    public static final CombinableAttribute<ItemFilter> FILTER = Attributes.createCombinable(ItemFilter.class, (Object)ConstantItemFilter.NOTHING, list -> AggregateItemFilter.allOf(list));
    public static final List<CombinableAttribute<?>> INVENTORY_BASED = Arrays.asList(FIXED_INV_VIEW, FIXED_INV, GROUPED_INV_VIEW, GROUPED_INV, INSERTABLE, EXTRACTABLE);
    public static final List<CombinableAttribute<?>> GROUPED_INVENTORY_BASED = Arrays.asList(GROUPED_INV_VIEW, GROUPED_INV, INSERTABLE, EXTRACTABLE);

    private ItemAttributes() {
    }

    public static void forEachInv(Consumer<? super CombinableAttribute<?>> consumer) {
        INVENTORY_BASED.forEach(consumer);
    }

    public static void forEachGroupedInv(Consumer<? super CombinableAttribute<?>> consumer) {
        GROUPED_INVENTORY_BASED.forEach(consumer);
    }

    private static <T> CombinableAttribute<T> create(Class<T> clazz, @Nonnull T defaultValue, AttributeCombiner<T> combiner, Function<FixedItemInv, T> convertor) {
        CombinableAttribute attribute = Attributes.createCombinable(clazz, defaultValue, combiner);
        AttributeSourceType srcType = AttributeSourceType.COMPAT_WRAPPER;
        attribute.putBlockClassAdder(srcType, class_3954.class, true, (w, p, s, l) -> {
            class_3954 provider = (class_3954)s.method_26204();
            class_1278 inventory = provider.method_17680(s, (class_1936)w, p);
            if (inventory != null) {
                if (inventory.method_5439() > 0) {
                    class_2350 direction = l.getSearchDirection();
                    class_2350 blockSide = direction == null ? null : direction.method_10153();
                    FixedItemInv wrapper = direction != null ? FixedSidedInventoryVanillaWrapper.create(inventory, blockSide) : new FixedInventoryVanillaWrapper((class_1263)inventory);
                    l.add(convertor.apply(wrapper));
                } else {
                    l.add(attribute.defaultValue);
                }
            }
        });
        attribute.putBlockClassAdder(srcType, class_2281.class, true, (w, p, s, l) -> {
            boolean checkForBlockingCats = false;
            class_2281 chest = (class_2281)s.method_26204();
            class_1263 chestInv = class_2281.method_17458((class_2281)chest, (class_2680)s, (class_1937)w, (class_2338)p, (boolean)checkForBlockingCats);
            if (chestInv != null) {
                l.add(convertor.apply(new FixedInventoryVanillaWrapper(chestInv)));
            }
        });
        attribute.appendBlockAdder((w, p, s, l) -> {
            if (!s.method_31709()) {
                return;
            }
            class_2350 direction = l.getSearchDirection();
            class_2350 blockSide = direction == null ? null : direction.method_10153();
            class_2586 be = w.method_8321(p);
            if (be instanceof class_1278) {
                class_1278 sidedInv = (class_1278)be;
                FixedItemInv wrapper = direction != null ? FixedSidedInventoryVanillaWrapper.create(sidedInv, blockSide) : new FixedInventoryVanillaWrapper((class_1263)sidedInv);
                l.add(convertor.apply(wrapper));
            } else if (be instanceof class_1263) {
                l.add(convertor.apply(new FixedInventoryVanillaWrapper((class_1263)be)));
            }
        });
        attribute.addItemPredicateAdder(srcType, true, ItemAttributes::isShulkerBox, (ref, excess, list) -> list.add(convertor.apply(new ShulkerBoxItemInv((Reference<class_1799>)ref))));
        return attribute;
    }

    static boolean isShulkerBox(class_1792 item) {
        return class_2248.method_9503((class_1792)item) instanceof class_2480;
    }

    private static void validateEnvironment() throws Error {
        URL coreLoc;
        FabricLoader loader = FabricLoader.getInstance();
        if (loader.getAllMods().isEmpty()) {
            return;
        }
        ModContainer allModule = LibBlockAttributes.LbaModule.ALL.getModContainer();
        ModContainer coreModule = LibBlockAttributes.LbaModule.CORE.getModContainer();
        ModContainer itemsModule = LibBlockAttributes.LbaModule.ITEMS.getModContainer();
        if (itemsModule == null || coreModule == null) {
            if (allModule == null) {
                throw new Error("(No LBA modules present?)\n\nLoaded the LBA FatJar outside of a development environment!\nThis can cause stability issues when older or newer versions\nof the different submodules are present on the classpath, as\nfabric loader cannot load the seperate modules correctly. (Which\nthen causes NoSuchMethodError's, or other strange behaviour)");
            }
            if ("$version".equals(allModule.getMetadata().getVersion().getFriendlyString())) {
                return;
            }
            throw new Error("(Only 'all' present!)\n\nLoaded the LBA FatJar outside of a development environment!\nThis can cause stability issues when older or newer versions\nof the different submodules are present on the classpath, as\nfabric loader cannot load the seperate modules correctly. (Which\nthen causes NoSuchMethodError's, or other strange behaviour)");
        }
        if (loader.isDevelopmentEnvironment()) {
            return;
        }
        Class<FluidAttributes> itemsClass = FluidAttributes.class;
        Class<Attribute> coreClass = Attribute.class;
        URL itemsLoc = itemsClass.getProtectionDomain().getCodeSource().getLocation();
        if (itemsLoc.equals(coreLoc = coreClass.getProtectionDomain().getCodeSource().getLocation())) {
            throw new Error("(core and items have the same path " + itemsLoc + ")\n\nLoaded the LBA FatJar outside of a development environment!\nThis can cause stability issues when older or newer versions\nof the different submodules are present on the classpath, as\nfabric loader cannot load the seperate modules correctly. (Which\nthen causes NoSuchMethodError's, or other strange behaviour)");
        }
    }

    static {
        LbaItemModCompat.load();
        ItemAttributes.validateEnvironment();
    }

    static final class ShulkerBoxItemInv
    implements FixedItemInv.CopyingFixedItemInv {
        private final Reference<class_1799> ref;

        private ShulkerBoxItemInv(Reference<class_1799> ref) {
            this.ref = ref;
        }

        @Override
        public int getSlotCount() {
            return 27;
        }

        @Override
        public class_1799 getInvStack(int slot) {
            assert (0 <= slot && slot < 27);
            class_1799 stack = (class_1799)this.ref.get();
            class_2487 tag = stack.method_7941("BlockEntityTag");
            if (tag == null || stack.method_7960() || stack.method_7947() != 1 || !ItemAttributes.isShulkerBox(stack.method_7909())) {
                return class_1799.field_8037;
            }
            class_2371 list = class_2371.method_10211();
            class_1262.method_5429((class_2487)tag, (class_2371)list);
            if (slot >= list.size()) {
                return class_1799.field_8037;
            }
            return (class_1799)list.get(slot);
        }

        @Override
        public class_1799 getUnmodifiableInvStack(int slot) {
            return this.getInvStack(slot);
        }

        @Override
        public boolean isItemValidForSlot(int slot, class_1799 stack) {
            return stack.method_7960() || GROUPED_INV_VIEW.getFirstOrNull(stack) == null;
        }

        @Override
        public boolean setInvStack(int slot, class_1799 to, Simulation simulation) {
            class_2487 tag;
            if (slot <= 0 || slot > 27) {
                return false;
            }
            if (!this.isItemValidForSlot(slot, to)) {
                return false;
            }
            class_1799 stack = (class_1799)this.ref.get();
            if (!stack.method_7960() || stack.method_7947() != 1 || !ItemAttributes.isShulkerBox(stack.method_7909())) {
                return false;
            }
            if (simulation == Simulation.ACTION) {
                stack = stack.method_7972();
            }
            if ((tag = stack.method_7941("BlockEntityTag")) == null) {
                tag = simulation == Simulation.ACTION ? stack.method_7911("BlockEntityTag") : new class_2487();
            } else if (simulation == Simulation.SIMULATE) {
                tag = new class_2487().method_10543(tag);
            }
            class_2371 list = class_2371.method_10211();
            class_1262.method_5429((class_2487)tag, (class_2371)list);
            while (slot >= list.size()) {
                list.add((Object)class_1799.field_8037);
            }
            list.set(slot, (Object)to);
            class_1262.method_5426((class_2487)tag, (class_2371)list);
            return this.ref.set((Object)stack, simulation);
        }
    }
}

