/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.item.AbstractItemInvView;
import alexiil.mc.lib.attributes.item.InvMarkDirtyListener;
import alexiil.mc.lib.attributes.item.ItemInvAmountChangeListener;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ExactItemStackFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import java.util.Collections;
import java.util.Set;
import net.minecraft.class_1799;

public interface GroupedItemInvView
extends AbstractItemInvView {
    public Set<class_1799> getStoredStacks();

    default public int getAmount(class_1799 stack) {
        ItemInvStatistic stats = this.getStatistics(new ExactItemStackFilter(stack));
        if (!2.$assertionsDisabled && stats.spaceTotal < 0) {
            throw new AssertionError();
        }
        return stats.amount;
    }

    default public int getCapacity(class_1799 stack) {
        ItemInvStatistic stats = this.getStatistics(new ExactItemStackFilter(stack));
        if (!2.$assertionsDisabled && stats.spaceTotal < 0) {
            throw new AssertionError();
        }
        return stats.amount + stats.spaceAddable + stats.spaceTotal;
    }

    public int getTotalCapacity();

    default public int getSpace(class_1799 stack) {
        return this.getCapacity(stack) - this.getAmount(stack);
    }

    public ItemInvStatistic getStatistics(ItemFilter var1);

    default public ItemInvStatistic getStatistics(class_1799 stack) {
        return this.getStatistics(new ExactItemStackFilter(stack));
    }

    default public int getAmount(ItemFilter filter) {
        return this.getStatistics((ItemFilter)filter).amount;
    }

    default public boolean isEmpty() {
        return this.getAmount(ConstantItemFilter.ANYTHING) > 0;
    }

    @Override
    default public ListenerToken addListener(InvMarkDirtyListener listener, ListenerRemovalToken removalToken) {
        return this.addListener(new ItemInvAmountChangeListener.MarkDirtyWrapper(listener), removalToken);
    }

    default public ListenerToken addListener(ItemInvAmountChangeListener listener, ListenerRemovalToken removalToken) {
        return null;
    }

    default public GroupedItemInvView getGroupedView() {
        final GroupedItemInvView real = this;
        return new GroupedItemInvView(){

            @Override
            public GroupedItemInvView getGroupedView() {
                return this;
            }

            @Override
            public int getAmount(class_1799 stack) {
                return real.getAmount(stack);
            }

            @Override
            public int getAmount(ItemFilter filter) {
                return real.getAmount(filter);
            }

            @Override
            public int getCapacity(class_1799 stack) {
                return real.getCapacity(stack);
            }

            @Override
            public int getSpace(class_1799 stack) {
                return real.getSpace(stack);
            }

            @Override
            public int getTotalCapacity() {
                return real.getTotalCapacity();
            }

            @Override
            public Set<class_1799> getStoredStacks() {
                return Collections.unmodifiableSet(real.getStoredStacks());
            }

            @Override
            public ItemInvStatistic getStatistics(ItemFilter filter) {
                return real.getStatistics(filter);
            }

            @Override
            public int getChangeValue() {
                return real.getChangeValue();
            }

            @Override
            public ListenerToken addListener(InvMarkDirtyListener listener, ListenerRemovalToken removalToken) {
                1 view = this;
                return real.addListener((AbstractItemInvView inv) -> listener.onMarkDirty(view), removalToken);
            }

            @Override
            public ListenerToken addListener(ItemInvAmountChangeListener listener, ListenerRemovalToken removalToken) {
                1 view = this;
                return real.addListener((GroupedItemInvView inv, class_1799 stack, int prev, int curr) -> listener.onChange(view, stack, prev, curr), removalToken);
            }
        };
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class ItemInvStatistic {
        public final ItemFilter filter;
        public final int amount;
        public final int spaceAddable;
        public final int spaceTotal;

        public ItemInvStatistic(ItemFilter filter, int amount, int spaceAddable, int spaceTotal) {
            this.filter = filter;
            this.amount = amount;
            this.spaceAddable = spaceAddable;
            this.spaceTotal = spaceTotal;
        }
    }
}

