/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.CacheInfo;
import alexiil.mc.lib.attributes.Convertible;
import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.item.AbstractItemInvView;
import alexiil.mc.lib.attributes.item.GroupedItemInvView;
import alexiil.mc.lib.attributes.item.InvMarkDirtyListener;
import alexiil.mc.lib.attributes.item.SingleItemSlotView;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.GroupedItemInvViewFixedWrapper;
import alexiil.mc.lib.attributes.item.impl.MappedFixedItemInvView;
import alexiil.mc.lib.attributes.item.impl.SubFixedItemInvView;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_265;

public interface FixedItemInvView
extends Convertible,
AbstractItemInvView {
    public int getSlotCount();

    public class_1799 getInvStack(int var1);

    default public int getMaxAmount(int slot, class_1799 stack) {
        return stack.method_7960() ? 64 : stack.method_7914();
    }

    public boolean isItemValidForSlot(int var1, class_1799 var2);

    default public ItemFilter getFilterForSlot(int slot) {
        return stack -> this.isItemValidForSlot(slot, stack);
    }

    default public SingleItemSlotView getSlot(int slot) {
        return new SingleItemSlotView(this, slot);
    }

    default public Iterable<? extends SingleItemSlotView> slotIterable() {
        return () -> new Iterator<SingleItemSlotView>(){
            int index = 0;

            @Override
            public SingleItemSlotView next() {
                return FixedItemInvView.this.getSlot(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < FixedItemInvView.this.getSlotCount();
            }
        };
    }

    default public Iterable<class_1799> stackIterable() {
        return () -> new Iterator<class_1799>(){
            int index = 0;

            @Override
            public class_1799 next() {
                return FixedItemInvView.this.getInvStack(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < FixedItemInvView.this.getSlotCount();
            }
        };
    }

    default public GroupedItemInvView getGroupedInv() {
        return new GroupedItemInvViewFixedWrapper(this);
    }

    default public FixedItemInvView getSubInv(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (fromIndex == 0 && toIndex == this.getSlotCount()) {
            return this;
        }
        return new SubFixedItemInvView(this, fromIndex, toIndex);
    }

    default public FixedItemInvView getMappedInv(int ... slots) {
        if (slots.length == 0) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (FixedItemInvView.areSlotArraysEqual(this, slots)) {
            return this;
        }
        return new MappedFixedItemInvView(this, slots);
    }

    public static boolean areSlotArraysEqual(FixedItemInvView inv, int[] slots) {
        return FixedItemInvView.isFlatSlotArray(slots, inv.getSlotCount());
    }

    public static boolean isFlatSlotArray(int[] slots, int count) {
        if (slots.length == count) {
            for (int i = 0; i < slots.length; ++i) {
                if (slots[i] == i) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated(since="0.4.9", forRemoval=true)
    default public void offerSelfAsAttribute(AttributeList<?> list, @Nullable CacheInfo cacheInfo, @Nullable class_265 shape) {
        list.offer((Object)this, cacheInfo, shape);
    }

    default public <T> T convertTo(Class<T> otherType) {
        return (T)Convertible.offer(otherType, (Object)this.getGroupedInv());
    }

    default public FixedItemInvView getFixedView() {
        final FixedItemInvView real = this;
        return new FixedItemInvView(){

            @Override
            public int getSlotCount() {
                return real.getSlotCount();
            }

            @Override
            public class_1799 getInvStack(int slot) {
                return real.getInvStack(slot);
            }

            @Override
            public boolean isItemValidForSlot(int slot, class_1799 item) {
                return real.isItemValidForSlot(slot, item);
            }

            @Override
            public int getMaxAmount(int slot, class_1799 stack) {
                return real.getMaxAmount(slot, stack);
            }

            @Override
            public ItemFilter getFilterForSlot(int slot) {
                return real.getFilterForSlot(slot);
            }

            @Override
            public GroupedItemInvView getGroupedInv() {
                return new GroupedItemInvViewFixedWrapper(this);
            }

            @Override
            public ListenerToken addListener(InvMarkDirtyListener listener, ListenerRemovalToken removalToken) {
                3 wrapper = this;
                return real.addListener(inv -> listener.onMarkDirty(wrapper), removalToken);
            }

            @Override
            public int getChangeValue() {
                return real.getChangeValue();
            }
        };
    }
}

