/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.item;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInvView;
import alexiil.mc.lib.attributes.item.GroupedItemInv;
import alexiil.mc.lib.attributes.item.InvMarkDirtyListener;
import alexiil.mc.lib.attributes.item.ItemExtractable;
import alexiil.mc.lib.attributes.item.ItemInsertable;
import alexiil.mc.lib.attributes.item.ItemInvSlotChangeListener;
import alexiil.mc.lib.attributes.item.ItemStackUtil;
import alexiil.mc.lib.attributes.item.ItemTransferable;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import alexiil.mc.lib.attributes.item.SingleCopyingItemSlot;
import alexiil.mc.lib.attributes.item.SingleItemSlot;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.GroupedItemInvFixedWrapper;
import alexiil.mc.lib.attributes.item.impl.ItemInvModificationTracker;
import alexiil.mc.lib.attributes.item.impl.MappedFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.SimpleLimitedFixedItemInv;
import alexiil.mc.lib.attributes.item.impl.SubFixedItemInv;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1799;

public interface FixedItemInv
extends FixedItemInvView {
    @Override
    public class_1799 getInvStack(int var1);

    @Override
    public boolean isItemValidForSlot(int var1, class_1799 var2);

    public boolean setInvStack(int var1, class_1799 var2, Simulation var3);

    default public void forceSetInvStack(int slot, class_1799 to) {
        if (!this.setInvStack(slot, to, Simulation.ACTION)) {
            throw new IllegalStateException("Unable to force-set the slot " + slot + " to " + ItemInvModificationTracker.stackToFullString(to) + "!");
        }
    }

    default public void modifySlot(int slot, Function<class_1799, class_1799> function) {
        this.forceSetInvStack(slot, function.apply(this.getInvStack(slot)));
    }

    default public class_1799 insertStack(int slot, class_1799 stack, Simulation simulation) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 inSlot = this.getInvStack(slot);
        int current = inSlot.method_7960() ? 0 : inSlot.method_7947();
        int max = Math.min(current + stack.method_7947(), this.getMaxAmount(slot, stack));
        int addable = max - current;
        if (addable <= 0) {
            return stack;
        }
        if (current > 0 && !ItemStackUtil.areEqualIgnoreAmounts(stack, inSlot)) {
            return stack;
        }
        if (inSlot.method_7960()) {
            inSlot = stack.method_7972();
            inSlot.method_7939(addable);
        } else {
            inSlot = inSlot.method_7972();
            inSlot.method_7933(addable);
        }
        if (this.setInvStack(slot, inSlot, simulation)) {
            stack = stack.method_7972();
            stack.method_7934(addable);
            if (stack.method_7960()) {
                return class_1799.field_8037;
            }
        }
        return stack;
    }

    default public class_1799 extractStack(int slot, @Nullable ItemFilter filter, class_1799 mergeWith, int maxCount, Simulation simulation) {
        class_1799 inSlot = this.getInvStack(slot);
        if (inSlot.method_7960()) {
            return mergeWith;
        }
        if (!mergeWith.method_7960()) {
            if (!ItemStackUtil.areEqualIgnoreAmounts(mergeWith, inSlot)) {
                return mergeWith;
            }
            if ((maxCount = Math.min(maxCount, mergeWith.method_7914() - mergeWith.method_7947())) <= 0) {
                return mergeWith;
            }
        }
        if (filter != null && !filter.matches(inSlot)) {
            return mergeWith;
        }
        inSlot = inSlot.method_7972();
        class_1799 addable = inSlot.method_7971(maxCount);
        if (this.setInvStack(slot, inSlot, simulation)) {
            if (mergeWith.method_7960()) {
                mergeWith = addable;
            } else {
                mergeWith.method_7933(addable.method_7947());
            }
        }
        return mergeWith;
    }

    @Override
    default public SingleItemSlot getSlot(int slot) {
        return new SingleItemSlot(this, slot);
    }

    default public Iterable<? extends SingleItemSlot> slotIterable() {
        return () -> new Iterator<SingleItemSlot>(){
            int index = 0;

            @Override
            public SingleItemSlot next() {
                return FixedItemInv.this.getSlot(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < FixedItemInv.this.getSlotCount();
            }
        };
    }

    default public LimitedFixedItemInv createLimitedFixedInv() {
        return SimpleLimitedFixedItemInv.createLimited(this);
    }

    default public ItemInsertable getInsertable() {
        return this.getGroupedInv();
    }

    default public ItemExtractable getExtractable() {
        return this.getGroupedInv();
    }

    default public ItemTransferable getTransferable() {
        return this.getGroupedInv();
    }

    @Override
    default public GroupedItemInv getGroupedInv() {
        return new GroupedItemInvFixedWrapper(this);
    }

    @Override
    default public FixedItemInv getSubInv(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (fromIndex == 0 && toIndex == this.getSlotCount()) {
            return this;
        }
        return SubFixedItemInv.create(this, fromIndex, toIndex);
    }

    @Override
    default public FixedItemInv getMappedInv(int ... slots) {
        if (slots.length == 0) {
            return EmptyFixedItemInv.INSTANCE;
        }
        if (slots.length == this.getSlotCount()) {
            boolean isThis = true;
            for (int i = 0; i < slots.length; ++i) {
                if (slots[i] == i) continue;
                isThis = false;
                break;
            }
            if (isThis) {
                return this;
            }
        }
        return MappedFixedItemInv.create(this, slots);
    }

    public static interface CopyingFixedItemInv
    extends FixedItemInv {
        @Override
        default public class_1799 getInvStack(int slot) {
            return this.getUnmodifiableInvStack(slot).method_7972();
        }

        public class_1799 getUnmodifiableInvStack(int var1);

        @Override
        default public SingleCopyingItemSlot getSlot(int slot) {
            return new SingleCopyingItemSlot(this, slot);
        }

        @Override
        default public ListenerToken addListener(InvMarkDirtyListener listener, ListenerRemovalToken removalToken) {
            CopyingFixedItemInv wrapper = this;
            return this.addListener((FixedItemInvView inv, int slot, class_1799 before, class_1799 after) -> listener.onMarkDirty(wrapper), removalToken);
        }

        default public ListenerToken addListener(ItemInvSlotChangeListener listener, ListenerRemovalToken removalToken) {
            return null;
        }
    }

    public static interface ModifiableFixedItemInv
    extends FixedItemInv {
        @Override
        public class_1799 getInvStack(int var1);

        @Override
        public boolean isItemValidForSlot(int var1, class_1799 var2);

        @Override
        default public ItemFilter getFilterForSlot(int slot) {
            return FixedItemInv.super.getFilterForSlot(slot);
        }

        @Override
        public boolean setInvStack(int var1, class_1799 var2, Simulation var3);

        public void markDirty();
    }
}

