/*
 * Decompiled with CFR 0.152.
 */
package com.notker.xp_storage.blocks;

import com.notker.xp_storage.XpFunctions;
import com.notker.xp_storage.blocks.StorageBlockEntity;
import com.notker.xp_storage.fluids.Xp_fluid;
import com.notker.xp_storage.items.Xp_removerItem;
import com.notker.xp_storage.regestry.ModFluids;
import com.notker.xp_storage.regestry.ModItems;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class StorageBlock
extends class_2383
implements class_2343,
class_3737 {
    public static final class_2746 CHARGED = class_2746.method_11825((String)"charged");

    public StorageBlock(class_4970.class_2251 settings) {
        super(settings.method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        boolean bl = fluidState.method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(bl));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (!((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && fluidState.method_15772() == class_3612.field_15910) {
            class_2680 blockState = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
            world.method_8652(pos, blockState, 3);
            world.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)world));
            return true;
        }
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ctx) {
        class_265 bottom = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        class_265 top = class_2248.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        return class_259.method_1084((class_265)bottom, (class_265)top);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        StorageBlockEntity tile = (StorageBlockEntity)world.method_8321(pos);
        if (tile == null) {
            return;
        }
        class_1799 drop = new class_1799((class_1935)this.method_8389());
        if (tile.containerExperience > 0 || !tile.player_uuid.equals(class_156.field_25140)) {
            class_2487 stackTag = new class_2487();
            stackTag.method_10566("BlockEntityTag", (class_2520)tile.getNbtData());
            drop.method_7980(stackTag);
        }
        StorageBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)drop);
        super.method_9576(world, pos, state, player);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{class_2741.field_12481});
        stateManager.method_11667(new class_2769[]{CHARGED});
        stateManager.method_11667(new class_2769[]{class_2741.field_12508});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        StorageBlockEntity tile = (StorageBlockEntity)world.method_8321(pos);
        if (tile == null) {
            return;
        }
        if (tile.containerExperience != 0) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(true)));
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            boolean isSurvival;
            StorageBlockEntity tile = (StorageBlockEntity)world.method_8321(pos);
            if (tile == null) {
                return class_1269.field_5814;
            }
            int itemCountInHand = player.method_5998(hand).method_7947();
            boolean tileIsLocked = !tile.player_uuid.equals(class_156.field_25140);
            boolean isTileOwner = tile.player_uuid.equals(player.method_5667());
            boolean bl = isSurvival = !player.method_7337() && !player.method_7325();
            if (player.method_24518((class_1792)ModItems.INSPECTOR)) {
                return this.displayContainerInfo(world, pos, player, tile);
            }
            if (tileIsLocked && !isTileOwner && !player.method_7337()) {
                return this.containerAccessDenied(world, pos, player);
            }
            if (player.method_24518((class_1792)ModItems.KEY) && (isTileOwner || player.method_7337())) {
                return this.unlockContainer(world, pos, player, hand, isSurvival, itemCountInHand, tile);
            }
            if (isSurvival) {
                if (player.method_24518((class_1792)ModItems.LOCK)) {
                    if (tileIsLocked) {
                        return this.containerIsAlreadyLocked(world, pos, player);
                    }
                    return this.lockContainer(world, pos, player, hand, itemCountInHand, tile);
                }
                if (player.method_24518((class_1792)ModItems.XP_REMOVER)) {
                    class_1799 stack = player.method_5998(hand);
                    if (stack.method_7985() && Objects.requireNonNull(stack.method_7969()).method_10577(Xp_removerItem.tagId)) {
                        return this.containerXpToPlayer(itemCountInHand, state, world, pos, player, tile);
                    }
                    return this.playerXpToContainer(itemCountInHand, state, world, pos, player, tile);
                }
                if (player.method_24518(class_1802.field_8287)) {
                    return this.insertBottleXP(itemCountInHand, state, world, pos, player, hand, tile);
                }
                if (player.method_24518(class_1802.field_8550) && tile.containerExperience >= Xp_fluid.XpPerBucket) {
                    return this.fillBucketOnContainer(state, world, pos, player, hand, tile);
                }
                if (player.method_24518(ModFluids.XP_BUCKET)) {
                    return this.emptyBucketOnContainer(state, world, pos, player, hand, tile);
                }
            }
        }
        return class_1269.field_21466;
    }

    private class_1269 containerIsAlreadyLocked(class_1937 world, class_2338 pos, class_1657 player) {
        player.method_7353((class_2561)new class_2588("text.storageBlock.isLocked"), true);
        world.method_8396(null, pos, class_3417.field_28081, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    private class_1269 containerAccessDenied(class_1937 world, class_2338 pos, class_1657 player) {
        player.method_7353((class_2561)new class_2588("text.storageBlock.denied"), true);
        world.method_8396(null, pos, class_3417.field_28081, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    private class_1269 emptyBucketOnContainer(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, StorageBlockEntity tile) {
        tile.addXpToContainer(Xp_fluid.XpPerBucket);
        player.method_5998(hand).method_7939(0);
        player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8550));
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(tile.containerExperience != 0)));
        world.method_8396(null, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    private class_1269 fillBucketOnContainer(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, StorageBlockEntity tile) {
        tile.containerExperience -= Xp_fluid.XpPerBucket;
        tile.method_5431();
        tile.method_38235();
        player.method_5998(hand).method_7934(1);
        player.method_31548().method_7398(new class_1799((class_1935)ModFluids.XP_BUCKET));
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(tile.containerExperience != 0)));
        world.method_8396(null, pos, class_3417.field_15126, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    private class_1269 insertBottleXP(int itemCount, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, StorageBlockEntity tile) {
        class_1799 emptyBottles = new class_1799((class_1935)class_1802.field_8469);
        emptyBottles.method_7939(itemCount);
        int xpToInsert = 0;
        for (int i = 0; i < itemCount; ++i) {
            xpToInsert += 3 + world.field_9229.nextInt(5) + world.field_9229.nextInt(5);
        }
        tile.addXpToContainer(xpToInsert);
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(tile.containerExperience != 0)));
        world.method_8396(null, pos, class_3417.field_14978, class_3419.field_15245, 1.0f, 1.0f);
        player.method_5998(hand).method_7939(0);
        StorageBlock.method_36992((class_1937)world, (class_2338)pos, (class_2350)player.method_5735().method_10153(), (class_1799)emptyBottles);
        return class_1269.field_5812;
    }

    private class_1269 containerXpToPlayer(int itemCount, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, StorageBlockEntity tile) {
        if (tile.containerExperience > 0) {
            for (int i = 0; i < itemCount; ++i) {
                int xpToNextLevel = XpFunctions.exp_to_reach_next_lvl(player.method_7349(), player.field_7510);
                int storageXP = tile.containerExperience;
                if (storageXP == 0) break;
                if (storageXP >= xpToNextLevel) {
                    tile.containerExperience -= xpToNextLevel;
                    player.method_7255(xpToNextLevel);
                } else {
                    player.method_7255(storageXP);
                    tile.containerExperience = 0;
                }
                tile.method_5431();
                tile.method_38235();
            }
            world.method_8396(null, pos, class_3417.field_23117, class_3419.field_15245, 0.125f, 1.0f);
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(tile.containerExperience != 0)));
        }
        return class_1269.field_5812;
    }

    private class_1269 playerXpToContainer(int itemCount, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, StorageBlockEntity tile) {
        if (XpFunctions.get_total_xp(player.field_7520, player.method_7349(), player.field_7510) > 0) {
            int xpToInsert = 0;
            for (int i = 0; i < itemCount; ++i) {
                int totalPlayerXp = XpFunctions.get_total_xp(player.field_7520, player.method_7349(), player.field_7510);
                int xpExchange = XpFunctions.xp_value_from_bar(player.method_7349(), player.field_7510);
                if (xpExchange == 0) {
                    xpExchange = XpFunctions.getToNextLowerExperienceLevel(player.field_7520);
                    player.field_7510 = 0.0f;
                }
                if (totalPlayerXp >= xpExchange) {
                    player.method_7255(-xpExchange);
                    xpToInsert += xpExchange;
                    continue;
                }
                player.method_7255(-totalPlayerXp);
                xpToInsert += totalPlayerXp;
            }
            tile.addXpToContainer(xpToInsert);
            world.method_8396(null, pos, class_3417.field_23116, class_3419.field_15245, 0.125f, 1.0f);
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CHARGED, (Comparable)Boolean.valueOf(tile.containerExperience != 0)));
        }
        return class_1269.field_5812;
    }

    private class_1269 unlockContainer(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, boolean isSurvival, int itemCountInHand, StorageBlockEntity tile) {
        tile.setUuidAndNameTo();
        player.method_7353((class_2561)new class_2588("text.storageBlock.isOpen"), true);
        world.method_8396(null, pos, class_3417.field_22463, class_3419.field_15245, 1.0f, 1.0f);
        if (isSurvival) {
            player.method_5998(hand).method_7939(itemCountInHand > 1 ? itemCountInHand - 1 : 0);
        }
        return class_1269.field_5812;
    }

    private class_1269 lockContainer(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, int itemCountInHand, StorageBlockEntity tile) {
        tile.setUuidAndNameTo(player.method_5667(), player.method_5477());
        player.method_7353((class_2561)new class_2588("text.storageBlock.locked"), true);
        world.method_8396(null, pos, class_3417.field_22463, class_3419.field_15245, 1.0f, 1.0f);
        player.method_5998(hand).method_7939(itemCountInHand > 1 ? itemCountInHand - 1 : 0);
        return class_1269.field_5812;
    }

    private class_1269 displayContainerInfo(class_1937 world, class_2338 pos, class_1657 player, StorageBlockEntity tile) {
        int totalXp = XpFunctions.get_total_xp(player.field_7520, player.method_7349(), player.field_7510);
        if (!tile.player_uuid.equals(class_156.field_25140)) {
            player.method_9203((class_2561)new class_2588("item.tooltip.owner", new Object[]{tile.playerName.method_10851()}), class_156.field_25140);
            player.method_9203((class_2561)new class_2585("UUid: " + tile.player_uuid), class_156.field_25140);
        } else {
            player.method_9203((class_2561)new class_2588("item.debug_info.xp.container_no_owner"), class_156.field_25140);
        }
        String xp = String.format(Locale.GERMAN, "%,d", tile.containerExperience);
        String max = String.format(Locale.GERMAN, "%,d", Integer.MAX_VALUE);
        String playerXp = String.format(Locale.GERMAN, "%,d", totalXp);
        player.method_9203((class_2561)new class_2588("item.debug_info.xp.container_info", new Object[]{xp, max}), class_156.field_25140);
        player.method_9203((class_2561)new class_2588("item.debug_info.xp.container_fill", new Object[]{tile.getContainerFillPercentage()}), class_156.field_25140);
        player.method_9203((class_2561)new class_2588("item.debug_info.xp.player_info", new Object[]{playerXp}), class_156.field_25140);
        world.method_8396(null, pos, class_3417.field_17482, class_3419.field_15245, 0.5f, 1.0f);
        return class_1269.field_5812;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new StorageBlockEntity(pos, state);
    }
}

