/*
 * Decompiled with CFR 0.152.
 */
package com.notker.xp_storage;

import com.google.common.math.BigIntegerMath;
import com.google.common.math.LongMath;
import com.notker.xp_storage.blocks.StorageBlockEntity;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Locale;
import net.minecraft.class_2588;

public final class XpFunctions {
    private static final BigInteger B72 = BigInteger.valueOf(72L);
    private static final BigInteger B54215 = BigInteger.valueOf(54215L);
    private static final BigInteger B325 = BigInteger.valueOf(325L);
    private static final BigInteger B18 = BigInteger.valueOf(18L);

    public static int exp_to_reach_next_lvl(int nextLevelExp, float progress) {
        return nextLevelExp - XpFunctions.xp_value_from_bar(nextLevelExp, progress);
    }

    public static int xp_value_from_bar(int nextLevelExp, float progress) {
        return (int)((float)nextLevelExp * progress);
    }

    public static int get_total_xp_value_from_level(int level) {
        if (level >= 1 && level <= 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level >= 17 && level <= 31) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        if (level >= 32) {
            return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        return 0;
    }

    public static int get_total_xp(int level, int nextLevelExp, float progress) {
        return XpFunctions.get_total_xp_value_from_level(level) + XpFunctions.xp_value_from_bar(nextLevelExp, progress);
    }

    public static int getToNextLowerExperienceLevel(int actLevel) {
        int level = actLevel > 0 ? actLevel - 1 : actLevel;
        return XpFunctions.getToNextExperienceLevel(level);
    }

    public static int getToNextExperienceLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getLevelFromExp(long exp) {
        if (exp > 0x1C71C71C71C71C7L) {
            return BigIntegerMath.sqrt((BigInteger)BigInteger.valueOf(exp).multiply(B72).subtract(B54215), (RoundingMode)RoundingMode.DOWN).add(B325).divide(B18).intValueExact();
        }
        if (exp > Integer.MAX_VALUE) {
            return (int)((LongMath.sqrt((long)(72L * exp - 54215L), (RoundingMode)RoundingMode.DOWN) + 325L) / 18L);
        }
        if (exp > 1395L) {
            return (int)((Math.sqrt(72L * exp - 54215L) + 325.0) / 18.0);
        }
        if (exp > 315L) {
            return (int)(Math.sqrt(40L * exp - 7839L) / 10.0 + 8.1);
        }
        if (exp > 0L) {
            return (int)(Math.sqrt(exp + 9L) - 3.0);
        }
        return 0;
    }

    public static class_2588 xp_to_text(StorageBlockEntity tile) {
        return XpFunctions.xp_to_text(tile.containerExperience);
    }

    public static class_2588 xp_to_text(int value) {
        int containerLevel = XpFunctions.getLevelFromExp(value);
        int container_excess_xp = value - XpFunctions.get_total_xp_value_from_level(containerLevel);
        int container_next_level_xp = XpFunctions.getToNextExperienceLevel(containerLevel);
        float container_progress = 100.0f / (float)container_next_level_xp * (float)container_excess_xp;
        String percentage = String.format(Locale.US, "%.2f", Float.valueOf(container_progress));
        if (value == 0) {
            return new class_2588("text.storageBlock.empty");
        }
        if (container_excess_xp == 0) {
            return new class_2588("text.storageBlock.level", new Object[]{containerLevel});
        }
        return new class_2588("text.storageBlock.data", new Object[]{containerLevel, percentage});
    }
}

