/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.util.tradehelper.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.util.forgehelper.CraftingHelper;
import com.jab125.util.tradehelper.TradeSerializer;
import com.jab125.util.tradehelper.UpgradedGoblinTradeIfInNotEnd;
import com.jab125.util.tradehelper.type.ITradeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class UpgradedOnlyInEndBasicTrade
implements ITradeType<UpgradedGoblinTradeIfInNotEnd> {
    public static final Serializer SERIALIZER = new Serializer();
    private final class_1799 offerStack;
    private final class_1799 paymentStack;
    private final class_1799 secondaryPaymentStack;
    private final float priceMultiplier;
    private final int maxTrades;
    private final int merchantExperience;
    private final int playerExperience;
    private final class_1889[] enchantments;
    private final Collection<class_1293> mobEffects;

    public UpgradedOnlyInEndBasicTrade(class_1799 offerStack, class_1799 paymentStack, class_1799 secondaryPaymentStack, float priceMultiplier, int maxTrades, int merchantExperience, int playerExperience, class_1889[] enchantments, Collection<class_1293> mobEffects) {
        this.offerStack = offerStack;
        this.paymentStack = paymentStack;
        this.secondaryPaymentStack = secondaryPaymentStack;
        this.priceMultiplier = priceMultiplier;
        this.maxTrades = maxTrades;
        this.merchantExperience = merchantExperience;
        this.playerExperience = playerExperience;
        this.enchantments = enchantments;
        this.mobEffects = mobEffects;
    }

    @Override
    public UpgradedGoblinTradeIfInNotEnd createTradeOffer() {
        class_1799 offerStack = this.offerStack.method_7972();
        if (this.enchantments.length > 0) {
            if (offerStack.method_7909() == class_1802.field_8598) {
                class_1890.method_8214(Stream.of(this.enchantments).collect(Collectors.toMap(o -> o.field_9093, e -> e.field_9094)), (class_1799)offerStack);
            } else {
                for (class_1889 data : this.enchantments) {
                    offerStack.method_7978(data.field_9093, data.field_9094);
                }
            }
        }
        if (this.mobEffects.size() > 0) {
            class_1844.method_8056((class_1799)offerStack, this.mobEffects);
        }
        return new UpgradedGoblinTradeIfInNotEnd(offerStack, this.paymentStack.method_7972(), this.secondaryPaymentStack.method_7972(), this.maxTrades, this.merchantExperience, this.playerExperience, this.priceMultiplier);
    }

    @Override
    public JsonObject serialize() {
        return SERIALIZER.serialize(this);
    }

    public static class Serializer
    extends TradeSerializer<UpgradedOnlyInEndBasicTrade> {
        Serializer() {
            super(new class_2960("goblintraders", "upgraded_only_in_end_basic"));
        }

        @Override
        public UpgradedOnlyInEndBasicTrade deserialize(JsonObject object) {
            Builder builder = Builder.create();
            builder.setOfferStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"offer_item"), true));
            builder.setPaymentStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"payment_item"), true));
            if (class_3518.method_15294((JsonObject)object, (String)"secondary_payment_item")) {
                builder.setSecondaryPaymentStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"secondary_payment_item"), true));
            }
            builder.setPriceMultiplier(class_3518.method_15277((JsonObject)object, (String)"price_multiplier", (float)0.05f));
            builder.setMaxTrades(class_3518.method_15282((JsonObject)object, (String)"max_trades", (int)12));
            builder.setMerchantExperience(class_3518.method_15282((JsonObject)object, (String)"merchant_experience", (int)0));
            builder.setPlayerExperience(class_3518.method_15282((JsonObject)object, (String)"player_experience", (int)0));
            if (class_3518.method_15294((JsonObject)object, (String)"enchantments")) {
                Collection<class_1889> enchantments = this.getEnchantments(class_3518.method_15261((JsonObject)object, (String)"enchantments"));
                for (class_1889 enchantment : enchantments) {
                    builder.addEnchantment(enchantment);
                }
            }
            if (class_3518.method_15294((JsonObject)object, (String)"potion_effects")) {
                Collection<class_1293> effects = this.getPotionEffects(class_3518.method_15261((JsonObject)object, (String)"potion_effects"));
                for (class_1293 effect : effects) {
                    builder.addPotionEffect(effect);
                }
            }
            return builder.build();
        }

        @Override
        public JsonObject serialize(UpgradedOnlyInEndBasicTrade trade) {
            JsonObject object = super.serialize(trade);
            object.add("offer_item", (JsonElement)this.serializeItemStack(trade.offerStack));
            object.add("payment_item", (JsonElement)this.serializeItemStack(trade.paymentStack));
            if (!trade.secondaryPaymentStack.method_7960()) {
                object.add("secondary_payment_item", (JsonElement)this.serializeItemStack(trade.secondaryPaymentStack));
            }
            if (trade.priceMultiplier != 0.05f) {
                object.addProperty("price_multiplier", (Number)Float.valueOf(trade.priceMultiplier));
            }
            if (trade.maxTrades != 12) {
                object.addProperty("max_trades", (Number)trade.maxTrades);
            }
            if (trade.merchantExperience != 0) {
                object.addProperty("merchant_experience", (Number)trade.merchantExperience);
            }
            if (trade.playerExperience != 0) {
                object.addProperty("player_experience", (Number)trade.playerExperience);
            }
            if (trade.enchantments.length > 0) {
                JsonArray enchantmentArray = new JsonArray();
                for (class_1889 enchantment : trade.enchantments) {
                    enchantmentArray.add((JsonElement)this.serializeEnchantment(enchantment));
                }
                object.add("enchantments", (JsonElement)enchantmentArray);
            }
            if (trade.mobEffects.size() > 0) {
                JsonArray effectArray = new JsonArray();
                for (class_1293 effect : trade.mobEffects) {
                    effectArray.add((JsonElement)this.serializePotionEffect(effect));
                }
                object.add("potion_effects", (JsonElement)effectArray);
            }
            return object;
        }

        private JsonObject serializeItemStack(class_1799 stack) {
            JsonObject object = new JsonObject();
            object.addProperty("item", Objects.requireNonNull(class_2378.field_11142.method_10221((Object)stack.method_7909())).toString());
            object.addProperty("count", (Number)stack.method_7947());
            if (stack.method_7985()) {
                object.addProperty("nbt", Objects.requireNonNull(stack.method_7969()).toString());
            }
            return object;
        }

        private JsonObject serializeEnchantment(class_1889 enchantment) {
            JsonObject object = new JsonObject();
            object.addProperty("id", Objects.requireNonNull(class_2378.field_11160.method_10221((Object)enchantment.field_9093)).toString());
            object.addProperty("level", (Number)enchantment.field_9094);
            return object;
        }

        private JsonObject serializePotionEffect(class_1293 effect) {
            JsonObject object = new JsonObject();
            object.addProperty("id", Objects.requireNonNull(class_2378.field_11159.method_10221((Object)effect.method_5579())).toString());
            object.addProperty("duration", (Number)effect.method_5584());
            object.addProperty("amplifier", (Number)effect.method_5578());
            object.addProperty("show_particles", Boolean.valueOf(effect.method_5581()));
            return object;
        }

        private Collection<class_1889> getEnchantments(JsonArray enchantmentArray) {
            ArrayList<class_1889> enchantments = new ArrayList<class_1889>();
            for (JsonElement enchantmentElement : enchantmentArray) {
                JsonObject enchantmentObject = enchantmentElement.getAsJsonObject();
                String id = class_3518.method_15265((JsonObject)enchantmentObject, (String)"id");
                class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(new class_2960(id));
                if (enchantment == null) continue;
                int level = class_3518.method_15282((JsonObject)enchantmentObject, (String)"level", (int)1);
                enchantments.add(new class_1889(enchantment, level));
            }
            return enchantments;
        }

        private Collection<class_1293> getPotionEffects(JsonArray effectsArray) {
            ArrayList<class_1293> effects = new ArrayList<class_1293>();
            for (JsonElement effectElement : effectsArray) {
                JsonObject effectObject = effectElement.getAsJsonObject();
                String id = class_3518.method_15265((JsonObject)effectObject, (String)"id");
                class_1291 effect = (class_1291)class_2378.field_11159.method_10223(new class_2960(id));
                if (effect == null) continue;
                int duration = class_3518.method_15282((JsonObject)effectObject, (String)"duration", (int)1);
                int amplifier = class_3518.method_15282((JsonObject)effectObject, (String)"amplifier", (int)1);
                boolean showParticles = class_3518.method_15258((JsonObject)effectObject, (String)"show_particles", (boolean)true);
                effects.add(new class_1293(effect, duration, amplifier, false, showParticles));
            }
            return effects;
        }
    }

    public static class Builder {
        private class_1799 offerStack;
        private class_1799 paymentStack;
        private class_1799 secondaryPaymentStack = class_1799.field_8037;
        private float priceMultiplier = 0.0f;
        private int maxTrades = 12;
        private int merchantExperience = 10;
        private int playerExperience = 10;
        private List<class_1889> enchantments = new ArrayList<class_1889>();
        private List<class_1293> modEffects = new ArrayList<class_1293>();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public UpgradedOnlyInEndBasicTrade build() {
            return new UpgradedOnlyInEndBasicTrade(this.offerStack, this.paymentStack, this.secondaryPaymentStack, this.priceMultiplier, this.maxTrades, this.merchantExperience, this.playerExperience, this.enchantments.toArray(new class_1889[0]), this.modEffects);
        }

        public Builder setOfferStack(class_1799 offerStack) {
            this.offerStack = offerStack;
            return this;
        }

        public Builder setPaymentStack(class_1799 paymentStack) {
            this.paymentStack = paymentStack;
            return this;
        }

        public Builder setSecondaryPaymentStack(class_1799 secondaryPaymentStack) {
            this.secondaryPaymentStack = secondaryPaymentStack;
            return this;
        }

        public Builder setPriceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder setMaxTrades(int maxTrades) {
            this.maxTrades = maxTrades;
            return this;
        }

        @Deprecated
        public Builder setExperience(int merchantExperience) {
            return this.setMerchantExperience(merchantExperience);
        }

        public Builder setMerchantExperience(int merchantExperience) {
            this.merchantExperience = merchantExperience;
            return this;
        }

        public Builder setPlayerExperience(int playerExperience) {
            this.playerExperience = playerExperience;
            return this;
        }

        public Builder addEnchantment(class_1889 enchantment) {
            this.enchantments.add(enchantment);
            return this;
        }

        public Builder addEnchantment(class_1889 enchantment, boolean doIt) {
            if (doIt) {
                this.enchantments.add(enchantment);
            }
            return this;
        }

        public Builder addPotionEffect(class_1293 effect) {
            this.modEffects.add(effect);
            return this;
        }
    }
}

