/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.util.tradehelper.type;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.util.forgehelper.CraftingHelper;
import com.jab125.util.tradehelper.TradeSerializer;
import com.jab125.util.tradehelper.UpgradedGoblinTrade;
import com.jab125.util.tradehelper.type.ITradeType;
import java.util.Objects;
import net.hat.gt.datagen.GoblinTradeProvider;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class UpgradedEnchantedItemTrade
implements ITradeType<UpgradedGoblinTrade> {
    public static final Serializer SERIALIZER = new Serializer();
    private final class_1799 itemStack;
    private final float priceMultiplier;
    private final int maxTrades;
    private final int merchantExperience;
    private final int playerExperience;
    private final class_1887 enchantment;
    private final int payLevel;
    private final int sellLevel;

    public UpgradedEnchantedItemTrade(class_1799 itemStack, float priceMultiplier, int maxTrades, int merchantExperience, int playerExperience, class_1887 enchantment, int payLevel, int sellLevel) {
        this.payLevel = payLevel;
        this.sellLevel = sellLevel;
        this.itemStack = itemStack;
        this.priceMultiplier = priceMultiplier;
        this.maxTrades = maxTrades;
        this.merchantExperience = merchantExperience;
        this.playerExperience = playerExperience;
        this.enchantment = enchantment;
    }

    @Override
    public JsonObject serialize() {
        return SERIALIZER.serialize(this);
    }

    @Override
    public UpgradedGoblinTrade createTradeOffer() {
        class_1799 enchantedBook = new class_1799((class_1935)class_1802.field_8598);
        class_1799 sellItem = this.itemStack.method_7972();
        class_1890.method_8214(GoblinTradeProvider.toHashMap(new class_1889(this.enchantment, this.payLevel)), (class_1799)enchantedBook);
        class_1890.method_8214(GoblinTradeProvider.toHashMap(new class_1889(this.enchantment, this.sellLevel)), (class_1799)sellItem);
        return new UpgradedGoblinTrade(sellItem, this.itemStack.method_7972(), enchantedBook, this.maxTrades, this.merchantExperience, this.playerExperience, this.priceMultiplier);
    }

    public static class Serializer
    extends TradeSerializer<UpgradedEnchantedItemTrade> {
        Serializer() {
            super(new class_2960("goblintraders", "upgraded_enchanted_item"));
        }

        @Override
        public UpgradedEnchantedItemTrade deserialize(JsonObject object) {
            Builder builder = Builder.create();
            builder.setStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"item"), true));
            builder.setEnchantment((class_1887)class_2378.field_11160.method_10223(new class_2960(class_3518.method_15253((JsonObject)object, (String)"enchantment", (String)class_2378.field_11160.method_10221((Object)class_1893.field_9119).toString()))));
            builder.setOfferLevel(class_3518.method_15282((JsonObject)object, (String)"offer_level", (int)1));
            builder.setPaymentLevel(class_3518.method_15282((JsonObject)object, (String)"payment_level", (int)1));
            builder.setPriceMultiplier(class_3518.method_15277((JsonObject)object, (String)"price_multiplier", (float)0.05f));
            builder.setMaxTrades(class_3518.method_15282((JsonObject)object, (String)"max_trades", (int)12));
            builder.setMerchantExperience(class_3518.method_15282((JsonObject)object, (String)"merchant_experience", (int)0));
            builder.setPlayerExperience(class_3518.method_15282((JsonObject)object, (String)"player_experience", (int)0));
            return builder.build();
        }

        @Override
        public JsonObject serialize(UpgradedEnchantedItemTrade trade) {
            JsonObject object = super.serialize(trade);
            object.add("item", (JsonElement)this.serializeItemStack(trade.itemStack));
            if (trade.priceMultiplier != 0.05f) {
                object.addProperty("price_multiplier", (Number)Float.valueOf(trade.priceMultiplier));
            }
            if (trade.maxTrades != 12) {
                object.addProperty("max_trades", (Number)trade.maxTrades);
            }
            if (trade.merchantExperience != 0) {
                object.addProperty("merchant_experience", (Number)trade.merchantExperience);
            }
            if (trade.playerExperience != 0) {
                object.addProperty("player_experience", (Number)trade.playerExperience);
            }
            object.addProperty("enchantment", class_2378.field_11160.method_10221((Object)trade.enchantment).toString());
            object.addProperty("offer_level", (Number)trade.sellLevel);
            object.addProperty("payment_level", (Number)trade.payLevel);
            return object;
        }

        private JsonObject serializeItemStack(class_1799 stack) {
            JsonObject object = new JsonObject();
            object.addProperty("item", Objects.requireNonNull(class_2378.field_11142.method_10221((Object)stack.method_7909())).toString());
            object.addProperty("count", (Number)stack.method_7947());
            if (stack.method_7985()) {
                object.addProperty("nbt", Objects.requireNonNull(stack.method_7969()).toString());
            }
            return object;
        }
    }

    public static class Builder {
        private class_1799 offerStack;
        private class_1887 enchantment;
        private int offerLevel;
        private int paymentLevel;
        private float priceMultiplier = 0.0f;
        private int maxTrades = 12;
        private int merchantExperience = 10;
        private int playerExperience = 10;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public UpgradedEnchantedItemTrade build() {
            return new UpgradedEnchantedItemTrade(this.offerStack, this.priceMultiplier, this.maxTrades, this.merchantExperience, this.playerExperience, this.enchantment, this.paymentLevel, this.offerLevel);
        }

        public Builder setStack(class_1799 offerStack) {
            this.offerStack = offerStack;
            return this;
        }

        public Builder setPriceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder setMaxTrades(int maxTrades) {
            this.maxTrades = maxTrades;
            return this;
        }

        @Deprecated
        public Builder setExperience(int merchantExperience) {
            return this.setMerchantExperience(merchantExperience);
        }

        public Builder setMerchantExperience(int merchantExperience) {
            this.merchantExperience = merchantExperience;
            return this;
        }

        public Builder setPlayerExperience(int playerExperience) {
            this.playerExperience = playerExperience;
            return this;
        }

        public Builder setOfferLevel(int offerLevel) {
            this.offerLevel = offerLevel;
            return this;
        }

        public Builder setPaymentLevel(int paymentLevel) {
            this.paymentLevel = paymentLevel;
            return this;
        }

        public Builder setEnchantment(class_1887 enchantment) {
            this.enchantment = enchantment;
            return this;
        }
    }
}

