/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.util.tradehelper.type;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.util.forgehelper.CraftingHelper;
import com.jab125.util.tradehelper.GoblinTrade;
import com.jab125.util.tradehelper.TradeSerializer;
import com.jab125.util.tradehelper.type.ITradeType;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class PotionTrade
implements ITradeType<GoblinTrade> {
    public static final Serializer SERIALIZER = new Serializer();
    private final class_1799 offerStack;
    private final class_1799 paymentStack;
    private final class_1799 secondaryPaymentStack;
    private final float priceMultiplier;
    private final int maxTrades;
    private final int experience;
    private final class_1842 potionType;

    public PotionTrade(class_1799 offerStack, class_1799 paymentStack, class_1799 secondaryPaymentStack, float priceMultiplier, int maxTrades, int experience, class_1842 potionType) {
        this.offerStack = offerStack;
        this.paymentStack = paymentStack;
        this.secondaryPaymentStack = secondaryPaymentStack;
        this.priceMultiplier = priceMultiplier;
        this.maxTrades = maxTrades;
        this.experience = experience;
        this.potionType = potionType;
    }

    @Override
    public JsonObject serialize() {
        return SERIALIZER.serialize(this);
    }

    @Override
    public GoblinTrade createTradeOffer() {
        class_1799 potion = this.offerStack.method_7972();
        class_1844.method_8061((class_1799)potion, (class_1842)this.potionType);
        return new GoblinTrade(potion.method_7972(), this.paymentStack.method_7972(), this.secondaryPaymentStack.method_7972(), this.maxTrades, this.experience, this.priceMultiplier);
    }

    public static class Serializer
    extends TradeSerializer<PotionTrade> {
        Serializer() {
            super(new class_2960("goblintraders", "potion"));
        }

        @Override
        public PotionTrade deserialize(JsonObject object) {
            Builder builder = Builder.create();
            builder.setOfferStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"offer_item"), true));
            builder.setPaymentStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"payment_item"), true));
            if (class_3518.method_15294((JsonObject)object, (String)"secondary_payment_item")) {
                builder.setSecondaryPaymentStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"secondary_payment_item"), true));
            }
            builder.setPotion((class_1842)class_2378.field_11143.method_10223(new class_2960(class_3518.method_15253((JsonObject)object, (String)"potion", (String)class_2378.field_11143.method_10221((Object)class_1847.field_8999).toString()))));
            builder.setPriceMultiplier(class_3518.method_15277((JsonObject)object, (String)"price_multiplier", (float)0.05f));
            builder.setMaxTrades(class_3518.method_15282((JsonObject)object, (String)"max_trades", (int)12));
            builder.setExperience(class_3518.method_15282((JsonObject)object, (String)"experience", (int)0));
            return builder.build();
        }

        @Override
        public JsonObject serialize(PotionTrade trade) {
            JsonObject object = super.serialize(trade);
            object.add("offer_item", (JsonElement)this.serializeItemStack(trade.offerStack));
            object.add("payment_item", (JsonElement)this.serializeItemStack(trade.paymentStack));
            if (!trade.secondaryPaymentStack.method_7960()) {
                object.add("secondary_payment_item", (JsonElement)this.serializeItemStack(trade.secondaryPaymentStack));
            }
            if (trade.priceMultiplier != 0.05f) {
                object.addProperty("price_multiplier", (Number)Float.valueOf(trade.priceMultiplier));
            }
            if (trade.maxTrades != 12) {
                object.addProperty("max_trades", (Number)trade.maxTrades);
            }
            if (trade.experience != 0) {
                object.addProperty("experience", (Number)trade.experience);
            }
            if (trade.potionType != null) {
                object.addProperty("potion", this.serializePotion(trade.potionType));
            }
            return object;
        }

        private JsonObject serializeItemStack(class_1799 stack) {
            JsonObject object = new JsonObject();
            object.addProperty("item", Objects.requireNonNull(class_2378.field_11142.method_10221((Object)stack.method_7909())).toString());
            object.addProperty("count", (Number)stack.method_7947());
            if (stack.method_7985()) {
                object.addProperty("nbt", Objects.requireNonNull(stack.method_7969()).toString());
            }
            return object;
        }

        private String serializePotion(class_1842 potion) {
            return class_2378.field_11143.method_10221((Object)potion).toString();
        }
    }

    public static class Builder {
        private class_1799 offerStack;
        private class_1799 paymentStack;
        private class_1799 secondaryPaymentStack = class_1799.field_8037;
        private class_1842 potion;
        private float priceMultiplier = 0.0f;
        private int maxTrades = 12;
        private int experience = 10;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public PotionTrade build() {
            return new PotionTrade(this.offerStack, this.paymentStack, this.secondaryPaymentStack, this.priceMultiplier, this.maxTrades, this.experience, this.potion);
        }

        public Builder setOfferStack(class_1799 offerStack) {
            if (!(offerStack.method_7909() instanceof class_1812)) {
                throw new RuntimeException("ItemStack need to be of minecraft:potion!");
            }
            this.offerStack = offerStack;
            return this;
        }

        public Builder setPaymentStack(class_1799 paymentStack) {
            this.paymentStack = paymentStack;
            return this;
        }

        public Builder setSecondaryPaymentStack(class_1799 secondaryPaymentStack) {
            this.secondaryPaymentStack = secondaryPaymentStack;
            return this;
        }

        public Builder setPriceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder setMaxTrades(int maxTrades) {
            this.maxTrades = maxTrades;
            return this;
        }

        @Deprecated
        public Builder setExperience(int experience) {
            return this.setMerchantExperience(experience);
        }

        public Builder setMerchantExperience(int merchantExperience) {
            this.experience = merchantExperience;
            return this;
        }

        public Builder setPlayerExperience(int playerExperience) {
            return this;
        }

        public Builder setPotion(class_1842 potion) {
            this.potion = potion;
            return this;
        }
    }
}

