/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.dmlSimulacrum.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.nathanpb.dml.enums.DataModelTier;
import io.github.projectet.dmlSimulacrum.block.entity.SimulationChamberEntity;
import io.github.projectet.dmlSimulacrum.dmlSimulacrum;
import io.github.projectet.dmlSimulacrum.gui.SimulationChamberScreenHandler;
import io.github.projectet.dmlSimulacrum.util.Animation;
import io.github.projectet.dmlSimulacrum.util.DataModelUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class SimulationChamberScreen
extends class_465<SimulationChamberScreenHandler> {
    public static final class_2960 GUI = dmlSimulacrum.id("textures/gui/simulation_chamber_base.png");
    public static final class_2960 defaultGUI = dmlSimulacrum.id("textures/gui/default_gui.png");
    private static final int WIDTH = 232;
    private static final int HEIGHT = 230;
    private final double maxEnergy;
    SimulationChamberEntity blockEntity;
    private HashMap<String, Animation> animationList;
    private class_1799 currentDataModel = class_1799.field_8037;
    private final class_327 renderer;
    private final class_1937 world;
    private final SimulationChamberScreenHandler handler;

    public SimulationChamberScreen(SimulationChamberScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.blockEntity = (SimulationChamberEntity)class_310.method_1551().field_1687.method_8321(handler.blockPos);
        this.maxEnergy = this.blockEntity.energyStorage.getCapacity();
        this.animationList = new HashMap();
        this.world = this.blockEntity.method_10997();
        this.renderer = class_310.method_1551().field_1772;
        this.handler = handler;
        this.field_2792 = 232;
        this.field_2779 = 230;
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        DecimalFormat f = new DecimalFormat("0.#");
        int x = this.field_2776 + 8;
        int spacing = 12;
        int yStart = this.field_2800 - 3;
        if (this.dataModelChanged()) {
            this.resetAnimations();
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.method_25302(matrices, x, this.field_2800, 0, 0, 216, 141);
        this.method_25302(matrices, x, this.field_2800 + 145, 0, 141, 18, 18);
        int energyBarHeight = dmlSimulacrum.ensureRange((int)((double)this.handler.getSyncedEnergy() / (this.maxEnergy - 64.0) * 87.0), 0, 87);
        int energyBarOffset = 87 - energyBarHeight;
        this.method_25302(matrices, x + 203, this.field_2800 + 48 + energyBarOffset, 25, 141, 7, energyBarHeight);
        if (!this.blockEntity.hasDataModel()) {
            String[] lines = new String[]{"Please insert a data model", "to begin the simulation"};
            Animation a1 = this.getAnimation("pleaseInsert1");
            Animation a2 = this.getAnimation("pleaseInsert2");
            this.animateString(matrices, lines[0], a1, null, 1, false, x + 10, yStart + spacing, 0xFFFFFF);
            this.animateString(matrices, lines[1], a2, a1, 1, false, x + 10, yStart + spacing * 2, 0xFFFFFF);
        } else if (DataModelUtil.getTier(this.blockEntity.getDataModel()).equals((Object)DataModelTier.FAULTY)) {
            String[] lines = new String[]{"Insufficient data in model", "please insert a basic model", "or better "};
            Animation insufData = this.getAnimation("insufData1");
            Animation insufData2 = this.getAnimation("insufData2");
            Animation insufData3 = this.getAnimation("insufData3");
            this.animateString(matrices, lines[0], insufData, null, 1, false, x + 10, yStart + spacing, 0xFFFFFF);
            this.animateString(matrices, lines[1], insufData2, insufData, 1, false, x + 10, yStart + spacing * 2, 0xFFFFFF);
            this.animateString(matrices, lines[2], insufData3, insufData2, 1, false, x + 10, yStart + spacing * 3, 0xFFFFFF);
        } else {
            if (DataModelUtil.getTier(this.blockEntity.getDataModel()).equals((Object)DataModelTier.SELF_AWARE)) {
                this.method_25302(matrices, x + 6, this.field_2800 + 48, 18, 141, 7, 87);
            } else {
                int collectedData = DataModelUtil.getTierCount(this.blockEntity.getDataModel()) - DataModelUtil.getTier(this.blockEntity.getDataModel()).getDataAmount();
                int tierRoof = DataModelUtil.getTierRoof(this.blockEntity.getDataModel()) - DataModelUtil.getTier(this.blockEntity.getDataModel()).getDataAmount();
                int experienceBarHeight = (int)((float)collectedData / (float)tierRoof * 87.0f);
                int experienceBarOffset = 87 - experienceBarHeight;
                this.method_25302(matrices, x + 6, this.field_2800 + 48 + experienceBarOffset, 18, 141, 7, experienceBarHeight);
            }
            SimulationChamberScreen.method_27535((class_4587)matrices, (class_327)this.renderer, (class_2561)new class_2585("Tier: ").method_10852(DataModelUtil.textTier(this.blockEntity.getDataModel())), (int)(x + 10), (int)(yStart + spacing), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)("Iterations: " + f.format(DataModelUtil.getSimulationCount(this.blockEntity.getDataModel()))), (int)(x + 10), (int)(yStart + spacing * 2), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)("Pristine chance: " + dmlSimulacrum.pristineChance.get(DataModelUtil.getTier(this.blockEntity.getDataModel()).toString()) + "%"), (int)(x + 10), (int)(yStart + spacing * 3), (int)0xFFFFFF);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)defaultGUI);
        this.method_25302(matrices, x + 20, this.field_2800 + 145, 0, 0, 176, 90);
        this.drawConsoleText(matrices, x, this.field_2800, spacing);
    }

    private void resetAnimations() {
        this.animationList = new HashMap();
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        int x = mouseX - this.field_2776;
        int y = mouseY - this.field_2800;
        NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
        ArrayList<class_2585> tooltip = new ArrayList<class_2585>();
        if (47 <= y && y < 135) {
            if (13 <= x && x < 22) {
                if (this.blockEntity.hasDataModel()) {
                    if (!DataModelUtil.getTier(this.blockEntity.getDataModel()).equals((Object)DataModelTier.SELF_AWARE)) {
                        int currentTierCount = DataModelUtil.getTierCount(this.blockEntity.getDataModel()) - DataModelUtil.getTier(this.blockEntity.getDataModel()).getDataAmount();
                        int currentTierRoof = DataModelUtil.getTierRoof(this.blockEntity.getDataModel()) - DataModelUtil.getTier(this.blockEntity.getDataModel()).getDataAmount();
                        tooltip.add(new class_2585(currentTierCount + "/" + currentTierRoof + " Data collected"));
                    } else {
                        tooltip.add(new class_2585("This data model has reached the max tier."));
                    }
                } else {
                    tooltip.add(new class_2585("Machine is missing a data model"));
                }
                this.method_30901(matrices, tooltip, x + 2, y + 2);
            } else if (211 <= x && x < 220) {
                tooltip.add(new class_2585(f.format(this.handler.getSyncedEnergy()) + "/" + f.format(this.maxEnergy) + " E"));
                if (this.blockEntity.hasDataModel()) {
                    int data = DataModelUtil.getEnergyCost(this.blockEntity.getDataModel());
                    tooltip.add(new class_2585("Simulations with current data model drains " + f.format(data) + "E/t"));
                }
                this.method_30901(matrices, tooltip, x - 90, y - 16);
            }
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.method_2380(matrices, mouseX, mouseY);
    }

    private Animation getAnimation(String key) {
        if (!this.animationList.containsKey(key)) {
            this.animationList.put(key, new Animation());
        }
        return this.animationList.get(key);
    }

    private void animateString(class_4587 matrices, String string, Animation anim, Animation precedingAnim, int delay, boolean loop, int x, int y, int color) {
        String result;
        if (precedingAnim != null) {
            if (precedingAnim.hasFinished()) {
                result = anim.animate(string, delay, this.world.method_8401().method_188(), loop);
                SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)result, (int)x, (int)y, (int)color);
            } else {
                return;
            }
        }
        result = anim.animate(string, delay, this.world.method_8401().method_188(), loop);
        SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)result, (int)x, (int)y, (int)color);
    }

    private void drawConsoleText(class_4587 matrices, int x, int y, int spacing) {
        if (!this.blockEntity.hasDataModel() || DataModelUtil.getTier(this.blockEntity.getDataModel()).equals((Object)DataModelTier.FAULTY)) {
            this.animateString(matrices, "_", this.getAnimation("blinkingUnderline"), null, 16, true, x + 21, y + 49, 0xFFFFFF);
        } else if (!this.blockEntity.hasPolymerClay() && !this.blockEntity.isCrafting()) {
            String[] lines = new String[]{"Cannot begin simulation", "Missing polymer medium", "_"};
            Animation a1 = this.getAnimation("inputSlotEmpty1");
            Animation a2 = this.getAnimation("inputSlotEmpty2");
            Animation a3 = this.getAnimation("blinkingUnderline1");
            this.animateString(matrices, lines[0], a1, null, 1, false, x + 21, y + 51, 0xFFFFFF);
            this.animateString(matrices, lines[1], a2, a1, 1, false, x + 21, y + 51 + spacing, 0xFFFFFF);
            this.animateString(matrices, lines[2], a3, a2, 16, true, x + 21, y + 51 + spacing * 2, 0xFFFFFF);
        } else if (!this.hasEnergy() && !this.blockEntity.isCrafting()) {
            String[] lines = new String[]{"Cannot begin simulation", "System energy levels critical", "_"};
            Animation a1 = this.getAnimation("lowEnergy1");
            Animation a2 = this.getAnimation("lowEnergy2");
            Animation a3 = this.getAnimation("blinkingUnderline2");
            this.animateString(matrices, lines[0], a1, null, 1, false, x + 21, y + 51, 0xFFFFFF);
            this.animateString(matrices, lines[1], a2, a1, 1, false, x + 21, y + 51 + spacing, 0xFFFFFF);
            this.animateString(matrices, lines[2], a3, a2, 16, true, x + 21, y + 51 + spacing * 2, 0xFFFFFF);
        } else if (this.blockEntity.outputIsFull() || this.blockEntity.pristineIsFull()) {
            String[] lines = new String[]{"Cannot begin simulation", "Output or pristine buffer is full", "_"};
            Animation a1 = this.getAnimation("outputSlotFilled1");
            Animation a2 = this.getAnimation("outputSlotFilled2");
            Animation a3 = this.getAnimation("blinkingUnderline3");
            this.animateString(matrices, lines[0], a1, null, 1, false, x + 21, y + 51, 0xFFFFFF);
            this.animateString(matrices, lines[1], a2, a1, 1, false, x + 21, y + 51 + spacing, 0xFFFFFF);
            this.animateString(matrices, lines[2], a3, a2, 16, true, x + 21, y + 51 + spacing * 2, 0xFFFFFF);
        } else if (this.blockEntity.isCrafting()) {
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)(this.blockEntity.percentDone + "%"), (int)(x + 176), (int)(y + 123), (int)6478079);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("simulationProgressLine1"), (int)(x + 21), (int)(y + 51), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("simulationProgressLine1Version"), (int)(x + 124), (int)(y + 51), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("simulationProgressLine2"), (int)(x + 21), (int)(y + 51 + spacing), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("simulationProgressLine3"), (int)(x + 21), (int)(y + 51 + spacing * 2), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("simulationProgressLine4"), (int)(x + 21), (int)(y + 51 + spacing * 3), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("simulationProgressLine5"), (int)(x + 21), (int)(y + 51 + spacing * 4), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("simulationProgressLine6"), (int)(x + 21), (int)(y + 51 + spacing * 5), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("simulationProgressLine6Result"), (int)(x + 140), (int)(y + 51 + spacing * 5), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("simulationProgressLine7"), (int)(x + 21), (int)(y + 51 + spacing * 6), (int)0xFFFFFF);
            SimulationChamberScreen.method_25303((class_4587)matrices, (class_327)this.renderer, (String)this.blockEntity.getSimulationText("blinkingDots1"), (int)(x + 128), (int)(y + 51 + spacing * 6), (int)0xFFFFFF);
        } else {
            this.animateString(matrices, "_", this.getAnimation("blinkingUnderline"), null, 16, true, x + 21, y + 49, 0xFFFFFF);
        }
    }

    private boolean hasEnergy() {
        return this.blockEntity.hasEnergyForSimulation();
    }

    private boolean dataModelChanged() {
        if (class_1799.method_7987((class_1799)this.currentDataModel, (class_1799)this.blockEntity.getDataModel())) {
            return false;
        }
        this.currentDataModel = this.blockEntity.getDataModel();
        return true;
    }
}

