/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.dmlSimulacrum.config;

import io.github.projectet.dmlSimulacrum.dmlSimulacrum;
import java.lang.reflect.Field;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@me.shedaniel.autoconfig.annotation.Config(name="dml-simulacrum")
public class Config
implements ConfigData {
    @ConfigEntry.Gui.RequiresRestart
    @ConfigEntry.Category(value="default")
    @ConfigEntry.Gui.CollapsibleObject
    public MatterXP Matter_XP = new MatterXP();
    @ConfigEntry.Gui.RequiresRestart
    @ConfigEntry.Category(value="default")
    @ConfigEntry.Gui.CollapsibleObject
    public PristineChance Pristine_Chance = new PristineChance();
    @ConfigEntry.Gui.RequiresRestart
    @ConfigEntry.Category(value="default")
    @ConfigEntry.Gui.CollapsibleObject
    public EnergyCost Energy_Cost = new EnergyCost();

    public void validatePostLoad() {
        MatterXP StaticMatter = new MatterXP();
        PristineChance StaticPristine = new PristineChance();
        EnergyCost StaticCost = new EnergyCost();
        for (Field x : this.Matter_XP.getClass().getFields()) {
            try {
                int fieldValue = x.getInt(this.Matter_XP);
                if (dmlSimulacrum.inRange(fieldValue, 1, 999)) continue;
                x.set(this.Matter_XP, StaticMatter.getClass().getField(x.getName()).get(StaticMatter));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        for (Field x : this.Pristine_Chance.getClass().getFields()) {
            try {
                int fieldValue = x.getInt(this.Pristine_Chance);
                if (dmlSimulacrum.inRange(fieldValue, 0, 100)) continue;
                x.set(this.Pristine_Chance, StaticPristine.getClass().getField(x.getName()).get(StaticPristine));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        for (Field x : this.Energy_Cost.getClass().getFields()) {
            try {
                int fieldValue = x.getInt(this.Energy_Cost);
                if (dmlSimulacrum.inRange(fieldValue, 0, 6666)) continue;
                x.set(this.Energy_Cost, StaticCost.getClass().getField(x.getName()).get(StaticCost));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public static class MatterXP {
        @ConfigEntry.BoundedDiscrete(min=1L, max=999L)
        public int OverworldMatterXP = 10;
        @ConfigEntry.BoundedDiscrete(min=1L, max=999L)
        public int HellishMatterXP = 14;
        @ConfigEntry.BoundedDiscrete(min=1L, max=999L)
        public int ExtraMatterXP = 20;
    }

    public static class PristineChance {
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int BASIC = 5;
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int ADVANCED = 11;
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int SUPERIOR = 24;
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int SELF_AWARE = 42;
    }

    public static class EnergyCost {
        @ConfigEntry.BoundedDiscrete(min=0L, max=6666L)
        public int NETHER = 300;
        @ConfigEntry.BoundedDiscrete(min=0L, max=6666L)
        public int SLIMY = 160;
        @ConfigEntry.BoundedDiscrete(min=0L, max=6666L)
        public int OVERWORLD = 100;
        @ConfigEntry.BoundedDiscrete(min=0L, max=6666L)
        public int ZOMBIE = 300;
        @ConfigEntry.BoundedDiscrete(min=0L, max=6666L)
        public int SKELETON = 80;
        @ConfigEntry.BoundedDiscrete(min=0L, max=6666L)
        public int END = 512;
        @ConfigEntry.BoundedDiscrete(min=0L, max=6666L)
        public int GHOST = 372;
        @ConfigEntry.BoundedDiscrete(min=0L, max=6666L)
        public int ILLAGER = 412;
        @ConfigEntry.BoundedDiscrete(min=0L, max=6666L)
        public int OCEAN = 160;
    }
}

