/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.dmlSimulacrum.block.entity;

import dev.nathanpb.dml.item.ItemDataModel;
import dev.nathanpb.dml.item.ItemPristineMatter;
import io.github.projectet.dmlSimulacrum.dmlSimulacrum;
import io.github.projectet.dmlSimulacrum.gui.SimulationChamberScreenHandler;
import io.github.projectet.dmlSimulacrum.inventory.ImplementedInventory;
import io.github.projectet.dmlSimulacrum.item.ItemMatter;
import io.github.projectet.dmlSimulacrum.item.ItemPolymerClay;
import io.github.projectet.dmlSimulacrum.util.Animation;
import io.github.projectet.dmlSimulacrum.util.Constants;
import io.github.projectet.dmlSimulacrum.util.DataModelUtil;
import java.util.HashMap;
import java.util.Random;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class SimulationChamberEntity
extends class_2586
implements ImplementedInventory,
ExtendedScreenHandlerFactory,
Constants,
class_1278 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public int ticks = 0;
    public int percentDone = 0;
    private boolean isCrafting = false;
    private boolean byproductSuccess = false;
    private String currentDataModelType = "";
    public SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(2000000L, 25600L, 0L);
    private HashMap<String, String> simulationText = new HashMap();
    private HashMap<String, Animation> simulationAnimations = new HashMap();
    public class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return (int)SimulationChamberEntity.this.energyStorage.getAmount();
        }

        public void method_17391(int index, int value) {
            SimulationChamberEntity.this.energyStorage.amount = value;
        }

        public int method_17389() {
            return 1;
        }
    };

    public SimulationChamberEntity(class_2338 pos, class_2680 state) {
        super(dmlSimulacrum.SIMULATION_CHAMBER_ENTITY, pos, state);
    }

    private static boolean dataModelMatchesOutput(class_1799 stack, class_1799 output) {
        ItemMatter livingMatter = ((DataModelUtil.DataModel2Matter)dataModel.get(DataModelUtil.getEntityCategory(stack).toString())).getType().getItem();
        return class_2378.field_11142.method_10221((Object)livingMatter).equals((Object)class_2378.field_11142.method_10221((Object)output.method_7909()));
    }

    private static boolean dataModelMatchesPristine(class_1799 stack, class_1799 pristine) {
        ItemPristineMatter pristineMatter = ((DataModelUtil.DataModel2Matter)dataModel.get(DataModelUtil.getEntityCategory(stack).toString())).getPristine();
        return class_2378.field_11142.method_10221((Object)pristineMatter).equals((Object)class_2378.field_11142.method_10221((Object)pristine.method_7909()));
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, SimulationChamberEntity blockEntity) {
        ++blockEntity.ticks;
        if (!world.field_9236) {
            if (!blockEntity.isCrafting()) {
                if (blockEntity.canStartSimulation()) {
                    blockEntity.startSimulation();
                }
            } else {
                if (!blockEntity.canContinueSimulation() || blockEntity.dataModelTypeChanged()) {
                    blockEntity.finishSimulation(true);
                    return;
                }
                blockEntity.updateSimulationText(blockEntity.getDataModel());
                if (blockEntity.percentDone == 0) {
                    int chance;
                    Random rand = new Random();
                    int num = rand.nextInt(100);
                    blockEntity.byproductSuccess = num <= dmlSimulacrum.ensureRange(chance = dmlSimulacrum.pristineChance.get(DataModelUtil.getTier(blockEntity.getDataModel()).toString()).intValue(), 1, 100);
                }
                int energyTickCost = DataModelUtil.getEnergyCost(blockEntity.getDataModel());
                blockEntity.energyStorage.amount -= (long)energyTickCost;
                if (blockEntity.ticks % 3 == 0) {
                    ++blockEntity.percentDone;
                }
                if (blockEntity.ticks % 40 == 0) {
                    blockEntity.updateState();
                }
            }
            if (blockEntity.percentDone == 100) {
                blockEntity.finishSimulation(false);
                return;
            }
            blockEntity.method_5431();
        }
    }

    public void updateState() {
        class_2680 state = this.field_11863.method_8320(this.method_11016());
        this.field_11863.method_8413(this.method_11016(), state, state, 3);
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    private boolean dataModelTypeChanged() {
        return !this.currentDataModelType.equals(DataModelUtil.getEntityCategory(this.getDataModel()).toString());
    }

    public class_2487 createTagFromSimText() {
        class_2487 tag = new class_2487();
        this.simulationText.forEach((arg_0, arg_1) -> ((class_2487)tag).method_10582(arg_0, arg_1));
        return tag;
    }

    public void getSimTextfromTag(class_2487 tag) {
        this.simulationText.forEach((key, text) -> this.simulationText.put((String)key, tag.method_10558(key)));
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.energyStorage.amount = compound.method_10537("energy");
        this.byproductSuccess = compound.method_10577("byproductSuccess");
        this.isCrafting = compound.method_10577("isCrafting");
        this.percentDone = compound.method_10550("percentDone");
        this.currentDataModelType = compound.method_10558("currentDataModelType");
        this.getSimTextfromTag(compound.method_10562("simulationText"));
        class_1262.method_5429((class_2487)compound, this.inventory);
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10544("energy", this.energyStorage.amount);
        compound.method_10556("byproductSuccess", this.byproductSuccess);
        compound.method_10556("isCrafting", this.isCrafting);
        compound.method_10569("percentDone", this.percentDone);
        compound.method_10582("currentDataModelType", this.currentDataModelType);
        compound.method_10566("simulationText", (class_2520)this.createTagFromSimText());
        class_1262.method_5426((class_2487)compound, this.inventory);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        if (!this.field_11863.field_9236) {
            ((class_3215)this.field_11863.method_8398()).method_14128(this.method_11016());
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        return nbt;
    }

    private void updateSimulationText(class_1799 stack) {
        String[] lines = new String[]{"> Launching runtime", "v1.4.7", "> Iteration #" + (DataModelUtil.getSimulationCount(stack) + 1) + " started", "> Loading model from chip memory", "> Assessing threat level", "> Engaged enemy", "> Pristine procurement", this.byproductSuccess ? "succeeded" : "failed", "> Processing results", "..."};
        String resultPrefix = this.byproductSuccess ? "\u00a7a" : "\u00a7c";
        Animation aLine1 = this.getAnimation("simulationProgressLine1");
        Animation aLine1Version = this.getAnimation("simulationProgressLine1Version");
        Animation aLine2 = this.getAnimation("simulationProgressLine2");
        Animation aLine3 = this.getAnimation("simulationProgressLine3");
        Animation aLine4 = this.getAnimation("simulationProgressLine4");
        Animation aLine5 = this.getAnimation("simulationProgressLine5");
        Animation aLine6 = this.getAnimation("simulationProgressLine6");
        Animation aLine6Result = this.getAnimation("simulationProgressLine6Result");
        Animation aLine7 = this.getAnimation("simulationProgressLine7");
        Animation aLine8 = this.getAnimation("blinkingDots1");
        this.simulationText.put("simulationProgressLine1", this.animate(lines[0], aLine1, null, 1, false));
        this.simulationText.put("simulationProgressLine1Version", "\u00a76" + this.animate(lines[1], aLine1Version, aLine1, 1, false) + "\u00a7r");
        this.simulationText.put("simulationProgressLine2", this.animate(lines[2], aLine2, aLine1Version, 1, false));
        this.simulationText.put("simulationProgressLine3", this.animate(lines[3], aLine3, aLine2, 2, false));
        this.simulationText.put("simulationProgressLine4", this.animate(lines[4], aLine4, aLine3, 1, false));
        this.simulationText.put("simulationProgressLine5", this.animate(lines[5], aLine5, aLine4, 2, false));
        this.simulationText.put("simulationProgressLine6", this.animate(lines[6], aLine6, aLine5, 2, false));
        this.simulationText.put("simulationProgressLine6Result", resultPrefix + this.animate(lines[7], aLine6Result, aLine6, 2, false) + "\u00a7r");
        this.simulationText.put("simulationProgressLine7", this.animate(lines[8], aLine7, aLine6Result, 1, false));
        this.simulationText.put("blinkingDots1", this.animate(lines[9], aLine8, aLine7, 8, true));
    }

    private String animate(String string, Animation anim, @Nullable Animation precedingAnim, int delayInTicks, boolean loop) {
        if (precedingAnim != null) {
            if (precedingAnim.hasFinished()) {
                return anim.animate(string, delayInTicks, this.field_11863.method_8401().method_188(), loop);
            }
            return "";
        }
        return anim.animate(string, delayInTicks, this.field_11863.method_8401().method_188(), loop);
    }

    private Animation getAnimation(String key) {
        if (!this.simulationAnimations.containsKey(key)) {
            this.simulationAnimations.put(key, new Animation());
        }
        return this.simulationAnimations.get(key);
    }

    public String getSimulationText(String key) {
        if (!this.simulationText.containsKey(key)) {
            this.simulationText.put(key, "");
        }
        return this.simulationText.get(key);
    }

    private void startSimulation() {
        this.isCrafting = true;
        this.currentDataModelType = DataModelUtil.getEntityCategory(this.getDataModel()).toString();
        ((class_1799)this.inventory.get(1)).method_7939(this.getPolymerClay().method_7947() - 1);
        this.resetAnimations();
    }

    private void finishSimulation(boolean abort) {
        this.resetAnimations();
        this.percentDone = 0;
        this.isCrafting = false;
        if (!abort && !this.field_11863.field_9236) {
            DataModelUtil.updateSimulationCount(this.getDataModel());
            DataModelUtil.updateTierCount(this.getDataModel());
            if (((class_1799)this.inventory.get(2)).method_7909() instanceof ItemMatter) {
                ((class_1799)this.inventory.get(2)).method_7939(this.getLiving().method_7947() + 1);
            } else {
                this.inventory.set(2, (Object)new class_1799((class_1935)((DataModelUtil.DataModel2Matter)dataModel.get(this.currentDataModelType)).getType().getItem(), 1));
            }
            if (this.byproductSuccess) {
                this.byproductSuccess = false;
                if (((class_1799)this.inventory.get(3)).method_7909() instanceof ItemPristineMatter) {
                    ((class_1799)this.inventory.get(3)).method_7933(1);
                } else {
                    this.inventory.set(3, (Object)new class_1799((class_1935)((DataModelUtil.DataModel2Matter)dataModel.get(this.currentDataModelType)).getPristine(), 1));
                }
            }
            this.updateState();
        }
    }

    private boolean canStartSimulation() {
        return this.hasEnergyForSimulation() && this.canContinueSimulation() && !this.outputIsFull() && !this.pristineIsFull() && this.hasPolymerClay();
    }

    private boolean canContinueSimulation() {
        return this.hasDataModel() && !DataModelUtil.getTier(this.getDataModel()).toString().equalsIgnoreCase("faulty");
    }

    public boolean hasEnergyForSimulation() {
        if (this.hasDataModel()) {
            int ticksPerSimulation = 300;
            return this.energyStorage.amount > (long)ticksPerSimulation * (long)DataModelUtil.getEnergyCost(this.getDataModel());
        }
        return false;
    }

    public void resetAnimations() {
        this.simulationAnimations = new HashMap();
        this.simulationText = new HashMap();
    }

    public class_1799 getDataModel() {
        return this.method_5438(0);
    }

    private class_1799 getPolymerClay() {
        return this.method_5438(1);
    }

    private class_1799 getLiving() {
        return this.method_5438(2);
    }

    private class_1799 getPristine() {
        return this.method_5438(3);
    }

    public boolean hasDataModel() {
        return this.getDataModel().method_7909() instanceof ItemDataModel;
    }

    public boolean hasPolymerClay() {
        class_1799 stack = this.getPolymerClay();
        return stack.method_7909() instanceof ItemPolymerClay && stack.method_7947() > 0;
    }

    public boolean outputIsFull() {
        class_1799 stack = this.getLiving();
        if (stack.method_7960()) {
            return false;
        }
        boolean stackLimitReached = stack.method_7947() == this.getLiving().method_7914();
        boolean outputMatches = SimulationChamberEntity.dataModelMatchesOutput(this.getDataModel(), this.getLiving());
        return stackLimitReached || !outputMatches;
    }

    public boolean pristineIsFull() {
        class_1799 stack = this.getPristine();
        if (stack.method_7960()) {
            return false;
        }
        boolean stackLimitReached = stack.method_7947() == ((class_1799)this.inventory.get(3)).method_7914();
        boolean outputMatches = SimulationChamberEntity.dataModelMatchesPristine(this.getDataModel(), this.getPristine());
        return stackLimitReached || !outputMatches;
    }

    public class_2561 method_5476() {
        return new class_2585("Simulation Chamber");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new SimulationChamberScreenHandler(syncId, inv, this, this);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11036) {
            return new int[]{0, 1};
        }
        return new int[]{2, 3};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir == class_2350.field_11036) {
            return switch (slot) {
                case 0 -> {
                    if (stack.method_7909() instanceof ItemDataModel && DataModelUtil.getEntityCategory(stack) != null) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> stack.method_7909() instanceof ItemPolymerClay;
                default -> false;
            };
        }
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (dir != class_2350.field_11036) {
            return switch (slot) {
                case 2, 3 -> true;
                default -> false;
            };
        }
        return false;
    }
}

