/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.class_1257;
import net.minecraft.class_128;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1928;
import net.minecraft.class_1940;
import net.minecraft.class_2170;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2966;
import net.minecraft.class_2981;
import net.minecraft.class_31;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3283;
import net.minecraft.class_3286;
import net.minecraft.class_3312;
import net.minecraft.class_34;
import net.minecraft.class_3532;
import net.minecraft.class_3551;
import net.minecraft.class_3806;
import net.minecraft.class_3807;
import net.minecraft.class_3951;
import net.minecraft.class_5218;
import net.minecraft.class_5219;
import net.minecraft.class_5285;
import net.minecraft.class_5350;
import net.minecraft.class_5352;
import net.minecraft.class_5359;
import net.minecraft.class_5382;
import net.minecraft.class_5455;
import net.minecraft.class_6506;
import net.minecraft.class_6611;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger field_24625;

    /*
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] $$0) {
        class_155.method_36208();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$9 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$15 = $$1.accepts("jfrProfile");
        NonOptionArgumentSpec $$16 = $$1.nonOptions();
        try {
            void $$39;
            OptionSet $$17 = $$1.parse($$0);
            if ($$17.has((OptionSpec)$$9)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            class_128.method_24305();
            if ($$17.has((OptionSpec)$$15)) {
                class_6611.field_34923.method_37981(class_6506.field_34413);
            }
            class_2966.method_12851();
            class_2966.method_17598();
            class_156.method_29476();
            class_5455.class_5457 $$18 = class_5455.method_30528();
            Path $$19 = Paths.get("server.properties", new String[0]);
            class_3807 $$20 = new class_3807($$19);
            $$20.method_16719();
            Path $$21 = Paths.get("eula.txt", new String[0]);
            class_2981 $$22 = new class_2981($$21);
            if ($$17.has((OptionSpec)$$3)) {
                field_24625.info("Initialized '{}' and '{}'", (Object)$$19.toAbsolutePath(), (Object)$$21.toAbsolutePath());
                return;
            }
            if (!$$22.method_12866()) {
                field_24625.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$23 = new File((String)$$17.valueOf((OptionSpec)$$11));
            YggdrasilAuthenticationService $$24 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService $$25 = $$24.createMinecraftSessionService();
            GameProfileRepository $$26 = $$24.createProfileRepository();
            class_3312 $$27 = new class_3312($$26, new File($$23, MinecraftServer.field_4588.getName()));
            String $$28 = Optional.ofNullable((String)$$17.valueOf((OptionSpec)$$12)).orElse($$20.method_16717().field_16820);
            class_32 $$29 = class_32.method_26999($$23.toPath());
            class_32.class_5143 $$30 = $$29.method_27002($$28);
            class_34 $$31 = $$30.method_29584();
            if ($$31 != null) {
                if ($$31.method_255()) {
                    field_24625.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$31.method_38496()) {
                    field_24625.info("This world was created by an incompatible version.");
                    return;
                }
            }
            class_5359 $$32 = $$30.method_29585();
            boolean $$33 = $$17.has((OptionSpec)$$8);
            if ($$33) {
                field_24625.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            class_3283 $$34 = new class_3283(class_3264.field_14190, new class_3286(), new class_3279($$30.method_27010(class_5218.field_24186).toFile(), class_5352.field_25349));
            class_5359 $$35 = MinecraftServer.method_29736($$34, $$32 == null ? class_5359.field_25393 : $$32, $$33);
            CompletableFuture<class_5350> $$36 = class_5350.method_29466($$34.method_29211(), $$18, class_2170.class_5364.field_25420, $$20.method_16717().field_20324, class_156.method_18349(), Runnable::run);
            try {
                class_5350 $$37 = $$36.get();
            }
            catch (Exception $$38) {
                field_24625.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$38);
                $$34.close();
                return;
            }
            $$39.method_29475();
            class_5382<class_2520> $$40 = class_5382.method_36574(class_2509.field_11560, $$39.method_29474(), $$18);
            $$20.method_16717().method_37371($$18);
            class_5219 $$41 = $$30.method_27013($$40, $$35);
            if ($$41 == null) {
                class_5285 $$46;
                class_1940 $$45;
                if ($$17.has((OptionSpec)$$4)) {
                    class_1940 $$42 = MinecraftServer.field_17704;
                    class_5285 $$43 = class_5285.method_31112($$18);
                } else {
                    class_3806 $$44 = $$20.method_16717();
                    $$45 = new class_1940($$44.field_16820, $$44.field_16841, $$44.field_16838, $$44.field_16840, false, new class_1928(), $$35);
                    $$46 = $$17.has((OptionSpec)$$5) ? $$44.method_37371($$18).method_28036() : $$44.method_37371($$18);
                }
                $$41 = new class_31($$45, $$46, Lifecycle.stable());
            }
            if ($$17.has((OptionSpec)$$6)) {
                Main.method_29173($$30, class_3551.method_15450(), $$17.has((OptionSpec)$$7), () -> true, $$41.method_28057());
            }
            $$30.method_27425($$18, $$41);
            class_5219 $$47 = $$41;
            final class_3176 $$48 = MinecraftServer.method_29740(arg_0 -> Main.method_29734($$18, $$30, $$34, (class_5350)$$39, $$47, $$20, $$25, $$26, $$27, $$17, (OptionSpec)$$10, (OptionSpec)$$13, (OptionSpec)$$4, (OptionSpec)$$14, (OptionSpec)$$2, (OptionSpec)$$16, arg_0));
            Thread $$49 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$48.method_3747(true);
                }
            };
            $$49.setUncaughtExceptionHandler(new class_140(field_24625));
            Runtime.getRuntime().addShutdownHook($$49);
        }
        catch (Exception $$50) {
            field_24625.fatal("Failed to start the minecraft server", (Throwable)$$50);
        }
    }

    private static void method_29173(class_32.class_5143 $$0, DataFixer $$1, boolean $$2, BooleanSupplier $$3, class_5285 $$4) {
        field_24625.info("Forcing world upgrade!");
        class_1257 $$5 = new class_1257($$0, $$1, $$4, $$2);
        class_2561 $$6 = null;
        while (!$$5.method_5403()) {
            int $$8;
            class_2561 $$7 = $$5.method_5394();
            if ($$6 != $$7) {
                $$6 = $$7;
                field_24625.info($$5.method_5394().getString());
            }
            if (($$8 = $$5.method_5397()) > 0) {
                int $$9 = $$5.method_5400() + $$5.method_5399();
                field_24625.info("{}% completed ({} / {} chunks)...", (Object)class_3532.method_15375((float)$$9 / (float)$$8 * 100.0f), (Object)$$9, (Object)$$8);
            }
            if (!$$3.getAsBoolean()) {
                $$5.method_5402();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ class_3176 method_29734(class_5455.class_5457 $$0, class_32.class_5143 $$1, class_3283 $$2, class_5350 $$3, class_5219 $$4, class_3807 $$5, MinecraftSessionService $$6, GameProfileRepository $$7, class_3312 $$8, OptionSet $$9, OptionSpec $$10, OptionSpec $$11, OptionSpec $$12, OptionSpec $$13, OptionSpec $$14, OptionSpec $$15, Thread $$16) {
        boolean $$18;
        class_3176 $$17 = new class_3176($$16, $$0, $$1, $$2, $$3, $$4, $$5, class_3551.method_15450(), $$6, $$7, $$8, class_3951::new);
        $$17.method_3849((String)$$9.valueOf($$10));
        $$17.method_3779((Integer)$$9.valueOf($$11));
        $$17.method_3730($$9.has($$12));
        $$17.method_17819((String)$$9.valueOf($$13));
        boolean bl = $$18 = !$$9.has($$14) && !$$9.valuesOf($$15).contains("nogui");
        if ($$18 && !GraphicsEnvironment.isHeadless()) {
            $$17.method_13948();
        }
        return $$17;
    }

    static {
        class_156.method_39982();
        field_24625 = LogManager.getLogger();
    }
}

