/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_4485;
import net.minecraft.class_4486;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_2861
implements AutoCloseable {
    private static final Logger field_20434 = LogManager.getLogger();
    private static final int field_31418 = 4096;
    @VisibleForTesting
    protected static final int field_31417 = 1024;
    private static final int field_31419 = 5;
    private static final int field_31420 = 0;
    private static final ByteBuffer field_20435 = ByteBuffer.allocateDirect(1);
    private static final String field_31421 = ".mcc";
    private static final int field_31422 = 128;
    private static final int field_31423 = 256;
    private static final int field_31424 = 0;
    private final FileChannel field_20436;
    private final Path field_20657;
    final class_4486 field_20437;
    private final ByteBuffer field_20438 = ByteBuffer.allocateDirect(8192);
    private final IntBuffer field_20439;
    private final IntBuffer field_20440;
    @VisibleForTesting
    protected final class_4485 field_20441 = new class_4485();

    public class_2861(Path $$0, Path $$1, boolean $$2) throws IOException {
        this($$0, $$1, class_4486.field_20443, $$2);
    }

    public class_2861(Path $$0, Path $$1, class_4486 $$2, boolean $$3) throws IOException {
        this.field_20437 = $$2;
        if (!Files.isDirectory($$1, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + $$1.toAbsolutePath());
        }
        this.field_20657 = $$1;
        this.field_20439 = this.field_20438.asIntBuffer();
        this.field_20439.limit(1024);
        this.field_20438.position(4096);
        this.field_20440 = this.field_20438.asIntBuffer();
        this.field_20436 = $$3 ? FileChannel.open($$0, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open($$0, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.field_20441.method_21868(0, 2);
        this.field_20438.position(0);
        int $$4 = this.field_20436.read(this.field_20438, 0L);
        if ($$4 != -1) {
            if ($$4 != 8192) {
                field_20434.warn("Region file {} has truncated header: {}", (Object)$$0, (Object)$$4);
            }
            long $$5 = Files.size($$0);
            for (int $$6 = 0; $$6 < 1024; ++$$6) {
                int $$7 = this.field_20439.get($$6);
                if ($$7 == 0) continue;
                int $$8 = class_2861.method_21878($$7);
                int $$9 = class_2861.method_21871($$7);
                if ($$8 < 2) {
                    field_20434.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", (Object)$$0, (Object)$$6, (Object)$$8);
                    this.field_20439.put($$6, 0);
                    continue;
                }
                if ($$9 == 0) {
                    field_20434.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)$$0, (Object)$$6);
                    this.field_20439.put($$6, 0);
                    continue;
                }
                if ((long)$$8 * 4096L > $$5) {
                    field_20434.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", (Object)$$0, (Object)$$6, (Object)$$8);
                    this.field_20439.put($$6, 0);
                    continue;
                }
                this.field_20441.method_21868($$8, $$9);
            }
        }
    }

    private Path method_22413(class_1923 $$0) {
        String $$1 = "c." + $$0.field_9181 + "." + $$0.field_9180 + field_31421;
        return this.field_20657.resolve($$1);
    }

    @Nullable
    public synchronized DataInputStream method_21873(class_1923 $$0) throws IOException {
        int $$1 = this.method_12419($$0);
        if ($$1 == 0) {
            return null;
        }
        int $$2 = class_2861.method_21878($$1);
        int $$3 = class_2861.method_21871($$1);
        int $$4 = $$3 * 4096;
        ByteBuffer $$5 = ByteBuffer.allocate($$4);
        this.field_20436.read($$5, $$2 * 4096);
        $$5.flip();
        if ($$5.remaining() < 5) {
            field_20434.error("Chunk {} header is truncated: expected {} but read {}", (Object)$$0, (Object)$$4, (Object)$$5.remaining());
            return null;
        }
        int $$6 = $$5.getInt();
        byte $$7 = $$5.get();
        if ($$6 == 0) {
            field_20434.warn("Chunk {} is allocated, but stream is missing", (Object)$$0);
            return null;
        }
        int $$8 = $$6 - 1;
        if (class_2861.method_22407($$7)) {
            if ($$8 != 0) {
                field_20434.warn("Chunk has both internal and external streams");
            }
            return this.method_22408($$0, class_2861.method_22412($$7));
        }
        if ($$8 > $$5.remaining()) {
            field_20434.error("Chunk {} stream is truncated: expected {} but read {}", (Object)$$0, (Object)$$8, (Object)$$5.remaining());
            return null;
        }
        if ($$8 < 0) {
            field_20434.error("Declared size {} of chunk {} is negative", (Object)$$6, (Object)$$0);
            return null;
        }
        return this.method_22409($$0, $$7, class_2861.method_21876($$5, $$8));
    }

    private static int method_31739() {
        return (int)(class_156.method_659() / 1000L);
    }

    private static boolean method_22407(byte $$0) {
        return ($$0 & 0x80) != 0;
    }

    private static byte method_22412(byte $$0) {
        return (byte)($$0 & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream method_22409(class_1923 $$0, byte $$1, InputStream $$2) throws IOException {
        class_4486 $$3 = class_4486.method_21883($$1);
        if ($$3 == null) {
            field_20434.error("Chunk {} has invalid chunk stream version {}", (Object)$$0, (Object)$$1);
            return null;
        }
        return new DataInputStream($$3.method_21885($$2));
    }

    @Nullable
    private DataInputStream method_22408(class_1923 $$0, byte $$1) throws IOException {
        Path $$2 = this.method_22413($$0);
        if (!Files.isRegularFile($$2, new LinkOption[0])) {
            field_20434.error("External chunk path {} is not file", (Object)$$2);
            return null;
        }
        return this.method_22409($$0, $$1, Files.newInputStream($$2, new OpenOption[0]));
    }

    private static ByteArrayInputStream method_21876(ByteBuffer $$0, int $$1) {
        return new ByteArrayInputStream($$0.array(), $$0.position(), $$1);
    }

    private int method_21872(int $$0, int $$1) {
        return $$0 << 8 | $$1;
    }

    private static int method_21871(int $$0) {
        return $$0 & 0xFF;
    }

    private static int method_21878(int $$0) {
        return $$0 >> 8 & 0xFFFFFF;
    }

    private static int method_21880(int $$0) {
        return ($$0 + 4096 - 1) / 4096;
    }

    public boolean method_21879(class_1923 $$0) {
        int $$1 = this.method_12419($$0);
        if ($$1 == 0) {
            return false;
        }
        int $$2 = class_2861.method_21878($$1);
        int $$3 = class_2861.method_21871($$1);
        ByteBuffer $$4 = ByteBuffer.allocate(5);
        try {
            this.field_20436.read($$4, $$2 * 4096);
            $$4.flip();
            if ($$4.remaining() != 5) {
                return false;
            }
            int $$5 = $$4.getInt();
            byte $$6 = $$4.get();
            if (class_2861.method_22407($$6)) {
                if (!class_4486.method_21887(class_2861.method_22412($$6))) {
                    return false;
                }
                if (!Files.isRegularFile(this.method_22413($$0), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!class_4486.method_21887($$6)) {
                    return false;
                }
                if ($$5 == 0) {
                    return false;
                }
                int $$7 = $$5 - 1;
                if ($$7 < 0 || $$7 > 4096 * $$3) {
                    return false;
                }
            }
        }
        catch (IOException $$8) {
            return false;
        }
        return true;
    }

    public DataOutputStream method_21881(class_1923 $$0) throws IOException {
        return new DataOutputStream(this.field_20437.method_21886(new class_2862($$0)));
    }

    public void method_26981() throws IOException {
        this.field_20436.force(true);
    }

    public void method_31740(class_1923 $$0) throws IOException {
        int $$1 = class_2861.method_17909($$0);
        int $$2 = this.field_20439.get($$1);
        if ($$2 == 0) {
            return;
        }
        this.field_20439.put($$1, 0);
        this.field_20440.put($$1, class_2861.method_31739());
        this.method_21870();
        Files.deleteIfExists(this.method_22413($$0));
        this.field_20441.method_21869(class_2861.method_21878($$2), class_2861.method_21871($$2));
    }

    protected synchronized void method_21874(class_1923 $$0, ByteBuffer $$1) throws IOException {
        class_4549 $$13;
        int $$12;
        int $$2 = class_2861.method_17909($$0);
        int $$3 = this.field_20439.get($$2);
        int $$4 = class_2861.method_21878($$3);
        int $$5 = class_2861.method_21871($$3);
        int $$6 = $$1.remaining();
        int $$7 = class_2861.method_21880($$6);
        if ($$7 >= 256) {
            Path $$8 = this.method_22413($$0);
            field_20434.warn("Saving oversized chunk {} ({} bytes} to external file {}", (Object)$$0, (Object)$$6, (Object)$$8);
            $$7 = 1;
            int $$9 = this.field_20441.method_21867($$7);
            class_4549 $$10 = this.method_22410($$8, $$1);
            ByteBuffer $$11 = this.method_22406();
            this.field_20436.write($$11, $$9 * 4096);
        } else {
            $$12 = this.field_20441.method_21867($$7);
            $$13 = () -> Files.deleteIfExists(this.method_22413($$0));
            this.field_20436.write($$1, $$12 * 4096);
        }
        this.field_20439.put($$2, this.method_21872($$12, $$7));
        this.field_20440.put($$2, class_2861.method_31739());
        this.method_21870();
        $$13.run();
        if ($$4 != 0) {
            this.field_20441.method_21869($$4, $$5);
        }
    }

    private ByteBuffer method_22406() {
        ByteBuffer $$0 = ByteBuffer.allocate(5);
        $$0.putInt(1);
        $$0.put((byte)(this.field_20437.method_21882() | 0x80));
        $$0.flip();
        return $$0;
    }

    private class_4549 method_22410(Path $$0, ByteBuffer $$1) throws IOException {
        Path $$2 = Files.createTempFile(this.field_20657, "tmp", null, new FileAttribute[0]);
        try (FileChannel $$3 = FileChannel.open($$2, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            $$1.position(5);
            $$3.write($$1);
        }
        return () -> Files.move($$2, $$0, StandardCopyOption.REPLACE_EXISTING);
    }

    private void method_21870() throws IOException {
        this.field_20438.position(0);
        this.field_20436.write(this.field_20438, 0L);
    }

    private int method_12419(class_1923 $$0) {
        return this.field_20439.get(class_2861.method_17909($$0));
    }

    public boolean method_12423(class_1923 $$0) {
        return this.method_12419($$0) != 0;
    }

    private static int method_17909(class_1923 $$0) {
        return $$0.method_17887() + $$0.method_17888() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.method_21877();
        }
        finally {
            try {
                this.field_20436.force(true);
            }
            finally {
                this.field_20436.close();
            }
        }
    }

    private void method_21877() throws IOException {
        int $$1;
        int $$0 = (int)this.field_20436.size();
        if ($$0 != ($$1 = class_2861.method_21880($$0) * 4096)) {
            ByteBuffer $$2 = field_20435.duplicate();
            $$2.position(0);
            this.field_20436.write($$2, $$1 - 1);
        }
    }

    class class_2862
    extends ByteArrayOutputStream {
        private final class_1923 field_17656;

        public class_2862(class_1923 $$0) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(class_2861.this.field_20437.method_21882());
            this.field_17656 = $$0;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer $$0 = ByteBuffer.wrap(this.buf, 0, this.count);
            $$0.putInt(0, this.count - 5 + 1);
            class_2861.this.method_21874(this.field_17656, $$0);
        }
    }

    static interface class_4549 {
        public void run() throws IOException;
    }
}

