/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.world;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4543;
import net.minecraft.class_5217;
import net.minecraft.class_5455;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_6328;
import net.minecraft.class_6756;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

@class_6328
public class MockDelegationWorld
implements class_1936 {
    private final class_1936 delegate;
    private final Map<class_2338, BlockInfo> posToBlock;

    public MockDelegationWorld(class_1936 delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.posToBlock = new HashMap<class_2338, BlockInfo>();
    }

    public Set<Map.Entry<class_2338, BlockInfo>> entrySet() {
        return Collections.unmodifiableSet(this.posToBlock.entrySet());
    }

    public class_1936 getDelegate() {
        return this.delegate;
    }

    public void method_8396(@Nullable class_1657 player, class_2338 pos, class_3414 soundIn, class_3419 category, float volume, float pitch) {
    }

    public void method_8406(class_2394 particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void method_8444(@Nullable class_1657 p_217378_1_, int p_217378_2_, class_2338 p_217378_3_, int p_217378_4_) {
    }

    public void method_32888(@Nullable class_1297 p_151549_, class_5712 p_151550_, class_2338 p_151551_) {
    }

    public List<class_1297> method_8333(@Nullable class_1297 entity, class_238 axisAlignedBB, @Nullable Predicate<? super class_1297> predicate) {
        return new ArrayList<class_1297>();
    }

    public <T extends class_1297> List<T> method_18023(class_5575<class_1297, T> p_151464_, class_238 p_151465_, Predicate<? super T> p_151466_) {
        return null;
    }

    public <T extends class_1297> List<T> method_8390(Class<T> p_45979_, class_238 p_45980_, Predicate<? super T> p_45981_) {
        return List.of();
    }

    public List<? extends class_1657> method_18456() {
        return new ArrayList();
    }

    @Nullable
    public class_2791 method_8402(int p_217353_1_, int p_217353_2_, class_2806 p_217353_3_, boolean p_217353_4_) {
        return this.method_8392(p_217353_1_, p_217353_2_);
    }

    public class_2338 method_8598(class_2902.class_2903 heightmapType, class_2338 pos) {
        return this.getDelegate().method_8598(heightmapType, pos);
    }

    public class_5455 method_30349() {
        return null;
    }

    public boolean method_8650(class_2338 blockPos, boolean b) {
        return this.removeOverride(blockPos);
    }

    public boolean method_16358(class_2338 p_217375_1_, Predicate<class_2680> p_217375_2_) {
        return p_217375_2_.test(this.method_8320(p_217375_1_));
    }

    public boolean method_35237(class_2338 p_151584_, Predicate<class_3610> p_151585_) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public int method_30273() {
        return this.delegate.method_30273();
    }

    public long method_39224() {
        return this.delegate.method_39224();
    }

    public class_6756<class_2248> method_8397() {
        return this.delegate.method_8397();
    }

    public class_6756<class_3611> method_8405() {
        return this.delegate.method_8405();
    }

    public class_2791 method_8392(int chunkX, int chunkZ) {
        return this.delegate.method_8392(chunkX, chunkZ);
    }

    public class_5217 method_8401() {
        return this.delegate.method_8401();
    }

    public class_1266 method_8404(class_2338 pos) {
        return this.delegate.method_8404(pos);
    }

    @Nullable
    public MinecraftServer method_8503() {
        return this.delegate.method_8503();
    }

    public class_1267 method_8407() {
        return this.delegate.method_8407();
    }

    public class_2802 method_8398() {
        return this.delegate.method_8398();
    }

    public Random method_8409() {
        return this.delegate.method_8409();
    }

    public boolean method_22347(class_2338 pos) {
        return this.method_8320(pos).method_26215();
    }

    public class_1959 method_23753(class_2338 pos) {
        return this.delegate.method_23753(pos);
    }

    public class_1959 method_22387(int x, int y, int z) {
        return null;
    }

    public int method_8624(class_2902.class_2903 heightmapType, int x, int z) {
        return this.delegate.method_8624(heightmapType, x, z);
    }

    public int method_8594() {
        return this.delegate.method_8594();
    }

    public class_4543 method_22385() {
        return null;
    }

    public class_2784 method_8621() {
        return this.delegate.method_8621();
    }

    public boolean method_8611(@Nullable class_1297 entityIn, class_265 shape) {
        return this.delegate.method_8611(entityIn, shape);
    }

    public int method_22344(class_2338 pos, class_2350 direction) {
        return this.delegate.method_22344(pos, direction);
    }

    public boolean method_8608() {
        return this.delegate.method_8608();
    }

    public int method_8615() {
        return this.delegate.method_8615();
    }

    public class_2874 method_8597() {
        return this.delegate.method_8597();
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        if (this.delegate.method_31606(pos)) {
            return null;
        }
        BlockInfo info = this.getOverriddenBlock(pos);
        if (info != null) {
            return info.getEntity(this);
        }
        return this.delegate.method_8321(pos);
    }

    public class_2680 method_8320(class_2338 pos) {
        if (this.delegate.method_31606(pos)) {
            return class_2246.field_10243.method_9564();
        }
        class_2680 state = this.getOverriddenState(pos);
        return state != null ? state : class_2246.field_10124.method_9564();
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    public int method_8315() {
        return this.delegate.method_8315();
    }

    public boolean method_30092(class_2338 p_241211_1_, class_2680 p_241211_2_, int p_241211_3_, int p_241211_4_) {
        return false;
    }

    public boolean method_8652(class_2338 pos, class_2680 newState, int flags) {
        if (this.delegate.method_31606(pos)) {
            return false;
        }
        BlockInfo info = this.getOverriddenBlock(pos);
        if (info != null) {
            info.setState(newState);
        } else {
            this.posToBlock.put(pos, this.createInfo(pos, newState));
        }
        return true;
    }

    public boolean method_22352(class_2338 pos, boolean dropBlock) {
        return !this.method_8320(pos).method_26215() && this.method_8650(pos, true);
    }

    public boolean method_30093(class_2338 pos, boolean dropBlock, @Nullable class_1297 entity, int recursionLeft) {
        return false;
    }

    @Nullable
    public BlockInfo getOverriddenBlock(class_2338 pos) {
        return this.posToBlock.get(pos);
    }

    @Nullable
    public class_2680 getOverriddenState(class_2338 pos) {
        BlockInfo info = this.getOverriddenBlock(pos);
        return info != null ? info.getState() : null;
    }

    @Nullable
    public class_2586 getOverriddenTile(class_2338 pos) {
        BlockInfo info = this.getOverriddenBlock(pos);
        return info != null ? info.getEntity(this) : null;
    }

    public void clear() {
        this.posToBlock.clear();
    }

    public boolean removeOverride(class_2338 pos) {
        BlockInfo info = this.posToBlock.remove(pos);
        if (info != null) {
            info.onRemove();
            return true;
        }
        return false;
    }

    protected BlockInfo createInfo(class_2338 pos, class_2680 state) {
        return new BlockInfo(pos, state);
    }

    public float method_22349(class_2338 pos) {
        return this.delegate.method_22349(pos);
    }

    public float method_24852(class_2350 p_230487_1_, boolean p_230487_2_) {
        return 0.0f;
    }

    public class_3568 method_22336() {
        return this.delegate.method_22336();
    }

    public static class BlockInfo {
        private class_2338 pos;
        private class_2680 state;
        @Nullable
        private class_2586 entity;

        public BlockInfo(class_2338 pos, class_2680 state) {
            this.pos = Objects.requireNonNull(pos);
            this.state = Objects.requireNonNull(state);
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public BlockInfo setPos(class_2338 pos) {
            this.pos = Objects.requireNonNull(pos);
            return this;
        }

        public class_2680 getState() {
            return this.state;
        }

        public BlockInfo setState(class_2680 state) {
            Preconditions.checkNotNull((Object)state);
            if (this.state.method_26204() != state.method_26204() || !state.method_31709()) {
                this.onRemove();
            }
            this.state = state;
            return this;
        }

        @Nullable
        public class_2586 getEntity(class_1936 world) {
            if (this.entity == null && this.state.method_31709()) {
                try {
                    this.entity = ((class_2343)this.state.method_26204()).method_10123(this.pos, this.state);
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.debug("Tile Entity at {} with state {} threw exception whilst creating.", (Object)this.pos, (Object)this.state, (Object)e);
                }
            }
            return this.entity;
        }

        public void onRemove() {
            if (this.entity != null) {
                try {
                    this.entity.method_11012();
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.debug("Tile Entity at {} with state {} threw exception whilst removing.", (Object)this.pos, (Object)this.state, (Object)e);
                }
                this.entity = null;
            }
        }
    }
}

