/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tileentities;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffectBlockTileEntity
extends class_2586 {
    private BlockData renderedBlock;
    private BlockData sourceBlock;
    private EffectBlock.Mode mode = null;
    private int ticks;

    public EffectBlockTileEntity(class_2338 pos, class_2680 state) {
        super(OurTileEntities.EFFECT_BLOCK_TILE_ENTITY, pos, state);
    }

    public void initializeData(class_2680 curState, @Nullable class_2586 be, BlockData replacementBlock, EffectBlock.Mode mode) {
        this.ticks = 0;
        this.sourceBlock = replacementBlock;
        this.mode = mode;
        if (mode == EffectBlock.Mode.REPLACE) {
            this.setRenderedBlock(TileSupport.createBlockData(curState, be));
        } else {
            this.setRenderedBlock(replacementBlock);
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, EffectBlockTileEntity blockEntity) {
        if (++blockEntity.ticks >= blockEntity.getLifespan()) {
            blockEntity.complete();
        }
    }

    private void complete() {
        if (this.field_11863 == null || this.field_11863.field_9236 || this.mode == null || this.getRenderedBlock() == null) {
            return;
        }
        this.mode.onBuilderRemoved(this);
    }

    public BlockData getRenderedBlock() {
        return this.renderedBlock;
    }

    public void setRenderedBlock(BlockData renderedBlock) {
        this.renderedBlock = renderedBlock;
    }

    public BlockData getSourceBlock() {
        return this.sourceBlock;
    }

    public EffectBlock.Mode getReplacementMode() {
        return this.mode;
    }

    public int getTicksExisted() {
        return this.ticks;
    }

    public int getLifespan() {
        return 20;
    }

    public void method_11007(@NotNull class_2487 compound) {
        super.method_11007(compound);
        if (this.mode != null && this.getRenderedBlock() != null && this.sourceBlock != null) {
            compound.method_10569("ticks", this.ticks);
            compound.method_10569("mode", this.mode.ordinal());
            compound.method_10566("replacement_block", (class_2520)this.getRenderedBlock().serialize(true));
            compound.method_10566("source_block", (class_2520)this.sourceBlock.serialize(true));
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("ticks", 3) && nbt.method_10573("mode", 3) && nbt.method_10573("source_block", 10) && nbt.method_10573("replacement_block", 10)) {
            this.ticks = nbt.method_10550("ticks");
            this.mode = EffectBlock.Mode.values()[nbt.method_10550("mode")];
            this.setRenderedBlock(BlockData.tryDeserialize(nbt.method_10562("replacement_block"), true));
            this.sourceBlock = BlockData.tryDeserialize(nbt.method_10562("source_block"), true);
        }
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 instanceof class_3218) {
            ((class_3215)this.field_11863.method_8398()).method_14128(this.method_11016());
        }
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

