/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.template;

import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateReadException;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateWriteException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import org.jetbrains.annotations.Nullable;

public final class TemplateIO {
    private static final Gson GSON = TemplateHeader.appendHeaderSpecification(new GsonBuilder(), false, true).create();

    private TemplateIO() {
    }

    public static void writeTemplate(Template template, OutputStream stream) throws TemplateWriteException {
        TemplateIO.writeTemplate(template, stream, true);
    }

    public static void writeTemplate(Template template, OutputStream stream, boolean persisted) throws TemplateWriteException {
        class_2487 nbt = template.serialize(persisted);
        try {
            class_2507.method_10634((class_2487)nbt, (OutputStream)stream);
        }
        catch (IOException e) {
            throw new TemplateWriteException.DataCannotBeWrittenException(e, nbt);
        }
    }

    public static Template readTemplate(InputStream stream, @Nullable TemplateHeader header) throws TemplateReadException {
        return TemplateIO.readTemplate(stream, header, true);
    }

    public static Template readTemplate(InputStream stream, @Nullable TemplateHeader header, boolean persisted) throws TemplateReadException {
        try {
            return TemplateIO.readTemplate(class_2507.method_10629((InputStream)stream), header, persisted);
        }
        catch (IOException e) {
            throw new TemplateReadException.DataCannotBeReadException(e);
        }
    }

    public static Template readTemplate(class_2487 nbt, @Nullable TemplateHeader header, boolean persisted) throws TemplateReadException {
        try {
            return Template.deserialize(nbt, header, persisted);
        }
        catch (Exception e) {
            throw new TemplateReadException.IllegalNBTDataException(e, nbt);
        }
    }

    public static String writeTemplateJson(Template template, @Nullable BuildContext context) throws TemplateWriteException {
        return GSON.toJson((Object)TemplateJsonRepresentation.ofTemplate(template, context));
    }

    public static Template readTemplateFromJson(String json) throws TemplateReadException {
        try {
            return ((TemplateJsonRepresentation)GSON.fromJson(json, TemplateJsonRepresentation.class)).getTemplate();
        }
        catch (JsonSyntaxException e) {
            throw new TemplateReadException.CorruptJsonException(e);
        }
    }

    private static class TemplateJsonRepresentation {
        private TemplateHeader header;
        private String body;

        private TemplateJsonRepresentation(TemplateHeader header, String body) {
            this.header = header;
            this.body = body;
        }

        public static TemplateJsonRepresentation ofTemplate(Template template, @Nullable BuildContext context) throws TemplateWriteException {
            TemplateHeader header = context != null ? template.getHeaderAndForceMaterials(context) : template.getHeader();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TemplateIO.writeTemplate(template, baos);
            String base64 = Base64.getEncoder().encodeToString(baos.toByteArray());
            return new TemplateJsonRepresentation(header, base64);
        }

        private Template getTemplate() throws TemplateReadException {
            try {
                byte[] bytes = Base64.getDecoder().decode(this.body);
                class_2487 nbt = class_2507.method_10629((InputStream)new ByteArrayInputStream(bytes));
                return Template.deserialize(nbt, this.header, true);
            }
            catch (IOException | NullPointerException e) {
                throw new TemplateReadException.CorruptDataException(e, this.body);
            }
        }
    }
}

