/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public abstract class TimedDataSave<T extends TimedValue>
extends class_18 {
    private final Map<UUID, T> idToValue = new HashMap<UUID, T>();
    private final Long2ObjectSortedMap<Set<UUID>> timeToId = new Long2ObjectRBTreeMap();

    public UUID getFreeUUID() {
        UUID res = UUID.randomUUID();
        return this.idToValue.containsKey(res) ? this.getFreeUUID() : res;
    }

    protected T get(UUID id) {
        return (T)this.get(id, uuid -> this.createValue());
    }

    protected T get(UUID id, Function<UUID, T> factory) {
        this.method_80();
        return (T)((TimedValue)this.idToValue.computeIfAbsent(id, factory));
    }

    protected void remove(UUID id) {
        Set set;
        TimedValue val = (TimedValue)this.idToValue.remove(id);
        if (val != null && !(set = (Set)this.timeToId.get(val.getUpdateTime())).isEmpty()) {
            set.remove(id);
            if (set.isEmpty()) {
                this.timeToId.remove(val.getUpdateTime());
            }
        }
    }

    protected boolean contains(UUID id) {
        return this.idToValue.containsKey(id);
    }

    public long getLastUpdateTime(UUID id) {
        return ((TimedValue)this.get(id)).getUpdateTime();
    }

    public void load(class_2487 nbt) {
        class_2520 timeList = nbt.method_10580("data_map");
        this.timeToId.clear();
        this.idToValue.clear();
        if (timeList instanceof class_2499) {
            NBTHelper.deserializeUUIDMap((class_2499)timeList, this.idToValue, inbt -> this.readValue((class_2487)inbt));
            for (Map.Entry<UUID, T> entry : this.idToValue.entrySet()) {
                ((Set)this.timeToId.computeIfAbsent(((TimedValue)entry.getValue()).getUpdateTime(), i -> new HashSet())).add(entry.getKey());
            }
        }
    }

    public class_2487 method_75(class_2487 compound) {
        class_2499 data = NBTHelper.serializeUUIDMap(this.idToValue, TimedValue::write);
        compound.method_10566("data_map", (class_2520)data);
        return compound;
    }

    protected abstract T createValue();

    protected abstract T readValue(class_2487 var1);

    public static class TimedValue {
        private long lastUpdateTime;

        protected TimedValue(class_2487 nbt) {
            this(nbt.method_10573("time", 4) ? nbt.method_10537("time") : System.currentTimeMillis());
        }

        protected TimedValue(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        protected TimedValue() {
            this(System.currentTimeMillis());
        }

        public TimedValue updateTime() {
            this.lastUpdateTime = System.currentTimeMillis();
            return this;
        }

        public long getUpdateTime() {
            return this.lastUpdateTime;
        }

        public class_2487 write() {
            class_2487 nbt = new class_2487();
            nbt.method_10544("time", this.lastUpdateTime);
            return nbt;
        }
    }
}

