/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory;

import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public final class PlayerItemIndex
implements IItemIndex {
    private final class_1657 player;
    private final Storage<ItemVariant> storage;

    public PlayerItemIndex(class_1799 stack, class_1657 player) {
        this.player = player;
        this.storage = InventoryHelper.getHandlers(stack, player);
    }

    @Override
    public void insert(Multiset<ItemVariant> items, TransactionContext transaction) {
        for (Multiset.Entry entry : items.entrySet()) {
            this.insertObject((ItemVariant)entry.getElement(), entry.getCount(), transaction);
        }
    }

    private void insertObject(ItemVariant obj, int count, TransactionContext transaction) {
        int remainingCount = this.insertIntoProviders(obj, count, transaction);
        if (remainingCount != 0) {
            PlayerInventoryStorage.of((class_1657)this.player).drop(obj, (long)remainingCount, transaction);
        }
    }

    private int insertIntoProviders(ItemVariant variant, int toInsert, TransactionContext transaction) {
        return (int)((long)toInsert - this.storage.insert((Object)variant, (long)toInsert, transaction));
    }

    @Override
    public MatchResult match(MaterialList list, TransactionContext transaction) {
        MatchResult result = null;
        for (ImmutableMultiset multiset : list) {
            Transaction inner = Transaction.openNested((TransactionContext)transaction);
            try {
                result = this.match(list, (Multiset<ItemVariant>)multiset, (TransactionContext)inner);
                if (!result.isSuccess()) continue;
                inner.commit();
                MatchResult matchResult = MatchResult.success(list, result.getFoundItems(), (ImmutableMultiset<ItemVariant>)multiset);
                return matchResult;
            }
            finally {
                if (inner == null) continue;
                inner.close();
            }
        }
        if (result == null) {
            return MatchResult.success(list, (ImmutableMultiset<ItemVariant>)ImmutableMultiset.of(), (ImmutableMultiset<ItemVariant>)ImmutableMultiset.of());
        }
        return this.evaluateFailingOptionFoundItems(list, transaction);
    }

    private MatchResult evaluateFailingOptionFoundItems(MaterialList list, TransactionContext transaction) {
        HashMultiset multiset = HashMultiset.create();
        for (ImmutableMultiset<ItemVariant> option : list.getItemOptions()) {
            for (Multiset.Entry entry : option.entrySet()) {
                multiset.setCount((Object)((ItemVariant)entry.getElement()), Math.max(multiset.count(entry.getElement()), entry.getCount()));
            }
        }
        multiset.addAll(list.getRequiredItems());
        MatchResult result = this.match(list, (Multiset<ItemVariant>)multiset, transaction);
        if (result.isSuccess()) {
            throw new RuntimeException("This should not be possible! The the content changed between matches?!?");
        }
        PeekingIterator<ImmutableMultiset<ItemVariant>> it = list.iterator();
        return it.hasNext() ? MatchResult.failure(list, result.getFoundItems(), (ImmutableMultiset<ItemVariant>)((ImmutableMultiset)it.next())) : result;
    }

    private MatchResult match(MaterialList list, Multiset<ItemVariant> multiset, TransactionContext transaction) {
        ImmutableMultiset.Builder availableBuilder = ImmutableMultiset.builder();
        boolean success = true;
        for (Multiset.Entry entry : multiset.entrySet()) {
            int remainingCount = entry.getCount();
            int extracted = (int)this.storage.extract((Object)((ItemVariant)entry.getElement()), (long)remainingCount, transaction);
            success &= extracted == remainingCount;
            availableBuilder.addCopies((Object)((ItemVariant)entry.getElement()), extracted);
        }
        if (success) {
            return MatchResult.success(list, (ImmutableMultiset<ItemVariant>)availableBuilder.build(), (ImmutableMultiset<ItemVariant>)ImmutableMultiset.of());
        }
        return MatchResult.failure(list, (ImmutableMultiset<ItemVariant>)availableBuilder.build(), (ImmutableMultiset<ItemVariant>)ImmutableMultiset.of());
    }
}

