/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.concurrent;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.ServerTickingScheduler;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.SteppedScheduler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public final class UndoScheduler
extends SteppedScheduler {
    private final Iterator<Map.Entry<class_2338, Undo.BlockInfo>> iterator;
    private final BuildContext context;
    private final IItemIndex index;

    public static UndoScheduler scheduleUndo(Undo undo, IItemIndex index, BuildContext context, int steps) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
        UndoScheduler res = new UndoScheduler(Objects.requireNonNull(undo), Objects.requireNonNull(index), Objects.requireNonNull(context), steps);
        ServerTickingScheduler.runTicked(res);
        return res;
    }

    private UndoScheduler(Undo undo, IItemIndex index, BuildContext context, int steps) {
        super(steps);
        assert (context.getPlayer() != null);
        assert (!context.getStack().method_7960());
        this.iterator = undo.getUndoData().entrySet().iterator();
        this.index = index;
        this.context = context;
    }

    @Override
    protected boolean advance() {
        if (this.iterator.hasNext()) {
            return this.undoBlock(this.iterator.next());
        }
        return false;
    }

    private boolean undoBlock(Map.Entry<class_2338, Undo.BlockInfo> entry) {
        class_2586 be;
        class_2680 state = this.context.getWorld().method_8320(entry.getKey());
        BlockData data = TileSupport.createBlockData(state, be = this.context.getWorld().method_8321(entry.getKey()));
        if (data.getState().method_26204().method_9564() != entry.getValue().getPlacedData().getState().method_26204().method_9564()) {
            return true;
        }
        if (!state.method_26215() && !this.context.getServerWorld().method_8505(this.context.getPlayer(), entry.getKey())) {
            return true;
        }
        try (Transaction transaction = Transaction.openOuter();){
            MatchResult matchResult = this.index.match(MaterialList.of(entry.getValue().getProducedItems()), (TransactionContext)transaction);
            if (matchResult.isSuccess()) {
                this.index.insert(entry.getValue().getUsedItems(), (TransactionContext)transaction);
                EffectBlock.spawnUndoBlock(this.context, new PlacementTarget(entry.getKey(), entry.getValue().getRecordedData()));
                transaction.commit();
            }
        }
        return true;
    }

    @Override
    protected void onFinish() {
    }
}

