/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.google.common.base.Preconditions;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record BlockData(class_2680 state, ITileEntityData tileData) {
    public static final BlockData AIR = new BlockData(class_2246.field_10124.method_9564(), TileSupport.dummyTileEntityData());

    @Nullable
    public static BlockData tryDeserialize(@Nullable class_2487 tag, boolean persisted) {
        return BlockData.tryDeserialize(tag, persisted ? null : i -> (ITileDataSerializer)Registries.getTileDataSerializers().method_10200(i), persisted);
    }

    @Nullable
    public static BlockData tryDeserialize(@Nullable class_2487 tag, @Nullable IntFunction<ITileDataSerializer> serializerProvider, boolean readDataPersisted) {
        ITileDataSerializer serializer;
        if (!(tag != null && tag.method_10545("state") && tag.method_10545("serializer") && tag.method_10545("data"))) {
            return null;
        }
        class_2680 state = class_2512.method_10681((class_2487)tag.method_10562("state"));
        try {
            serializer = serializerProvider == null ? (ITileDataSerializer)Registries.getTileDataSerializers().method_10223(new class_2960(tag.method_10558("serializer"))) : serializerProvider.apply(tag.method_10550("serializer"));
        }
        catch (Exception e) {
            BuildingGadgets.LOG.error("Failed to create deserializer!", (Throwable)e);
            return null;
        }
        if (serializer == null) {
            return null;
        }
        ITileEntityData data = serializer.deserialize(tag.method_10562("data"), readDataPersisted);
        return new BlockData(state, data);
    }

    public static BlockData deserialize(class_2487 tag, boolean persisted) {
        return BlockData.deserialize(tag, persisted ? null : i -> (ITileDataSerializer)Registries.getTileDataSerializers().method_10200(i), persisted);
    }

    public static BlockData deserialize(class_2487 tag, @Nullable IntFunction<ITileDataSerializer> serializerProvider, boolean readDataPersisted) {
        ITileDataSerializer serializer;
        Preconditions.checkNotNull((Object)tag, (Object)"Cannot deserialize from a null tag compound");
        Preconditions.checkArgument((tag.method_10545("state") && tag.method_10545("serializer") && tag.method_10545("data") ? 1 : 0) != 0, (String)"Given NBTTagCompound does not contain a valid BlockData instance. Missing NBT-Keys in Tag {}!", (Object)tag.toString());
        class_2680 state = class_2512.method_10681((class_2487)tag.method_10562("state"));
        try {
            serializer = serializerProvider == null ? (ITileDataSerializer)Registries.getTileDataSerializers().method_10223(new class_2960(tag.method_10558("serializer"))) : serializerProvider.apply(tag.method_10550("serializer"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not retrieve serializer with persisted=" + readDataPersisted + "!", e);
        }
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0, (String)"Failed to retrieve serializer for tag {} and persisted={}", (Object)tag.toString(), (Object)readDataPersisted);
        ITileEntityData data = serializer.deserialize(tag.method_10562("data"), readDataPersisted);
        return new BlockData(state, data);
    }

    public class_2680 getState() {
        return this.state();
    }

    public ITileEntityData getTileData() {
        return this.tileData();
    }

    public boolean placeIn(BuildContext context, class_2338 pos) {
        return this.tileData.placeIn(context, this.state, pos);
    }

    public class_2487 serialize(boolean persisted) {
        return this.serialize(persisted ? null : ser -> Registries.getTileDataSerializers().method_10206(ser), persisted);
    }

    public class_2487 serialize(@Nullable ToIntFunction<ITileDataSerializer> idGetter, boolean writeDataPersisted) {
        class_2487 tag = new class_2487();
        tag.method_10566("state", (class_2520)class_2512.method_10686((class_2680)this.state));
        if (idGetter == null) {
            tag.method_10582("serializer", Registries.getTileDataSerializers().method_10221((Object)this.tileData.getSerializer()).toString());
        } else {
            tag.method_10569("serializer", idGetter.applyAsInt(this.tileData.getSerializer()));
        }
        tag.method_10566("data", (class_2520)this.tileData.getSerializer().serialize(this.tileData, writeDataPersisted));
        return tag;
    }

    public BlockData mirror(class_2415 mirror) {
        return new BlockData(this.getState().method_26185(mirror), this.getTileData());
    }

    public BlockData rotate(class_2470 rotation) {
        return new BlockData(this.getState().method_26186(rotation), this.getTileData());
    }

    public MaterialList getRequiredItems(BuildContext context, @Nullable class_239 target, @Nullable class_2338 pos) {
        return this.getTileData().getRequiredItems(context, this.getState(), target, pos);
    }
}

