/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.bidirection;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.mojang.datafixers.util.Either;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public class PacketSetRemoteInventoryCache {
    private static void send(Data data, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        data.write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketHandler.PacketSetRemoteInventoryCache, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    public static void send(boolean isCopyPaste, class_1268 hand) {
        class_2540 buf = PacketByteBufs.create();
        new Data(isCopyPaste, (Either<Cache, class_1268>)Either.right((Object)hand)).write(buf);
        ClientPlayNetworking.send((class_2960)PacketHandler.PacketSetRemoteInventoryCache, (class_2540)buf);
    }

    private record Data(boolean isCopyPaste, Either<Cache, class_1268> either) {
        private static Data read(class_2540 buf) {
            boolean isCopyPaste = buf.readBoolean();
            if (buf.readBoolean()) {
                int len = buf.readInt();
                ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
                for (int i = 0; i < len; ++i) {
                    builder.addCopies((Object)ItemVariant.fromPacket((class_2540)buf), buf.readInt());
                }
                return new Data(isCopyPaste, (Either<Cache, class_1268>)Either.left((Object)new Cache((Multiset<ItemVariant>)builder.build())));
            }
            class_1268 hand = (class_1268)buf.method_10818(class_1268.class);
            return new Data(isCopyPaste, (Either<Cache, class_1268>)Either.right((Object)hand));
        }

        private void write(class_2540 buf) {
            buf.writeBoolean(this.isCopyPaste);
            this.either.mapBoth(cache -> {
                buf.writeBoolean(true);
                buf.writeInt(cache.cache().entrySet().size());
                for (Multiset.Entry entry : cache.cache().entrySet()) {
                    ItemVariant uniqueItem = (ItemVariant)entry.getElement();
                    uniqueItem.toPacket(buf);
                    buf.writeInt(entry.getCount());
                }
                return null;
            }, hand -> {
                buf.writeBoolean(false);
                buf.method_10817((Enum)hand);
                return null;
            });
        }
    }

    private record Cache(Multiset<ItemVariant> cache) {
    }

    public static class Server
    implements ServerPlayNetworking.PlayChannelHandler {
        public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            Data data = Data.read(buf);
            server.execute(() -> data.either.ifRight(hand -> {
                HashMultiset items = HashMultiset.create();
                InventoryLinker.getLinkedInventory(player.field_6002, player.method_5998(hand)).ifPresent(arg_0 -> Server.lambda$receive$0((Multiset)items, arg_0));
                PacketSetRemoteInventoryCache.send(new Data(data.isCopyPaste, (Either<Cache, class_1268>)Either.left((Object)new Cache((Multiset<ItemVariant>)ImmutableMultiset.copyOf((Iterable)items)))), player);
            }));
        }

        private static /* synthetic */ void lambda$receive$0(Multiset items, Storage inventory) {
            try (Transaction transaction = Transaction.openOuter();){
                for (StorageView view : inventory.iterable((TransactionContext)transaction)) {
                    if (view.isResourceBlank()) continue;
                    ItemVariant resource = (ItemVariant)view.getResource();
                    items.add((Object)resource, (int)view.getAmount());
                }
            }
        }
    }

    public static class Client
    implements ClientPlayNetworking.PlayChannelHandler {
        @Environment(value=EnvType.CLIENT)
        public void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
            Data data = Data.read(buf);
            client.execute(() -> data.either.ifLeft(cache -> {
                if (!data.isCopyPaste()) {
                    BaseRenderer.setInventoryCache(cache.cache());
                }
            }));
        }
    }
}

