/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerRegistryImpl;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class GadgetDestruction
extends AbstractGadget {
    public GadgetDestruction(class_1792.class_1793 builder) {
        super(builder, Reference.TagReference.WHITELIST_DESTRUCTION, Reference.TagReference.BLACKLIST_DESTRUCTION);
    }

    @Override
    public long getEnergyCapacity() {
        return BuildingGadgets.getConfig().gadgets.gadgetDestruction.maxEnergy;
    }

    @Override
    public long getEnergyCost(class_1799 tool) {
        return BuildingGadgets.getConfig().gadgets.gadgetDestruction.energyCost * (long)this.getCostMultiplier(tool);
    }

    private int getCostMultiplier(class_1799 tool) {
        return (int)(!GadgetDestruction.getFuzzy(tool) ? BuildingGadgets.getConfig().gadgets.gadgetDestruction.nonFuzzyMultiplier : 1L);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add((class_2561)TooltipTranslation.GADGET_DESTROYWARNING.componentTranslation(new Object[0]).method_10862(Styles.RED));
        tooltip.add((class_2561)TooltipTranslation.GADGET_DESTROYSHOWOVERLAY.componentTranslation(String.valueOf(GadgetDestruction.getOverlay(stack))).method_10862(Styles.AQUA));
        tooltip.add((class_2561)TooltipTranslation.GADGET_BUILDING_PLACE_ATOP.componentTranslation(String.valueOf(GadgetDestruction.getConnectedArea(stack))).method_10862(Styles.YELLOW));
        if (BuildingGadgets.getConfig().gadgets.gadgetDestruction.nonFuzzyEnabled) {
            tooltip.add((class_2561)TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetDestruction.getFuzzy(stack))).method_10862(Styles.GOLD));
        }
        GadgetDestruction.addInformationRayTraceFluid(tooltip, stack);
    }

    public static void setAnchor(class_1799 stack, class_2338 pos) {
        GadgetUtils.writePOSToNBT(stack, pos, "anchor");
    }

    public static void setAnchorSide(class_1799 stack, class_2350 side) {
        class_2487 tag = stack.method_7948();
        if (side == null) {
            tag.method_10551("anchor_side");
        } else {
            tag.method_10582("anchor_side", side.method_10151());
        }
    }

    public static class_2350 getAnchorSide(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        String facing = tag.method_10558("anchor_side");
        if (facing.isEmpty()) {
            return null;
        }
        return class_2350.method_10168((String)facing);
    }

    public static void setToolValue(class_1799 stack, int value, String valueName) {
        stack.method_7948().method_10569(valueName, value);
    }

    public static int getToolValue(class_1799 stack, String valueName) {
        return stack.method_7948().method_10550(valueName);
    }

    public static boolean getOverlay(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545("overlay")) {
            return tag.method_10577("overlay");
        }
        tag.method_10556("overlay", true);
        tag.method_10556("fuzzy", true);
        stack.method_7980(tag);
        return true;
    }

    public static void setOverlay(class_1799 stack, boolean showOverlay) {
        stack.method_7948().method_10556("overlay", showOverlay);
    }

    public static void switchOverlay(class_1657 player, class_1799 stack) {
        boolean newOverlay = !GadgetDestruction.getOverlay(stack);
        GadgetDestruction.setOverlay(stack, newOverlay);
        player.method_7353((class_2561)TooltipTranslation.GADGET_DESTROYSHOWOVERLAY.componentTranslation(newOverlay).method_10862(Styles.AQUA), true);
    }

    public static boolean getIsFluidOnly(class_1799 stack) {
        return stack.method_7948().method_10577("fluid");
    }

    public static void toggleFluidMode(class_1799 stack) {
        stack.method_7948().method_10556("fluid", !GadgetDestruction.getIsFluidOnly(stack));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        player.method_6019(hand);
        if (!world.field_9236) {
            if (!player.method_5715()) {
                class_2338 anchorPos = this.getAnchor(stack);
                class_2350 anchorSide = GadgetDestruction.getAnchorSide(stack);
                if (anchorPos != null && anchorSide != null) {
                    this.clearArea(world, anchorPos, anchorSide, (class_3222)player, stack);
                    this.onAnchorRemoved(stack, player);
                    return new class_1271(class_1269.field_5812, (Object)stack);
                }
                class_3965 lookingAt = VectorHelper.getLookingAt(player, stack);
                if (!world.method_22347(lookingAt.method_17777())) {
                    this.clearArea(world, lookingAt.method_17777(), lookingAt.method_17780(), (class_3222)player, stack);
                    this.onAnchorRemoved(stack, player);
                    return new class_1271(class_1269.field_5812, (Object)stack);
                }
                return new class_1271(class_1269.field_5814, (Object)stack);
            }
        } else if (player.method_5715()) {
            GuiMod.DESTRUCTION.openScreen(player);
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    @Override
    protected void onAnchorSet(class_1799 stack, class_1657 player, class_3965 lookingAt) {
        super.onAnchorSet(stack, player, lookingAt);
        GadgetDestruction.setAnchorSide(stack, lookingAt.method_17780());
    }

    @Override
    protected void onAnchorRemoved(class_1799 stack, class_1657 player) {
        super.onAnchorRemoved(stack, player);
        GadgetDestruction.setAnchorSide(stack, null);
    }

    public static List<class_2338> getArea(class_1937 world, class_2338 pos, class_2350 incomingSide, class_1657 player, class_1799 stack) {
        class_1799 tool = GadgetDestruction.getGadget(player);
        int depth = GadgetDestruction.getToolValue(stack, "depth");
        if (tool.method_7960() || depth == 0 || !player.method_7294()) {
            return new ArrayList<class_2338>();
        }
        boolean vertical = incomingSide.method_10166().method_10178();
        class_2350 up = vertical ? player.method_5735() : class_2350.field_11036;
        class_2350 down = up.method_10153();
        class_2350 right = vertical ? up.method_10170() : incomingSide.method_10160();
        class_2350 left = right.method_10153();
        class_2338 first = pos.method_10079(left, GadgetDestruction.getToolValue(stack, "left")).method_10079(up, GadgetDestruction.getToolValue(stack, "up"));
        class_2338 second = pos.method_10079(right, GadgetDestruction.getToolValue(stack, "right")).method_10079(down, GadgetDestruction.getToolValue(stack, "down")).method_10079(incomingSide.method_10153(), depth - 1);
        boolean isFluidOnly = GadgetDestruction.getIsFluidOnly(stack);
        return new Region((class_2382)first, (class_2382)second).stream().filter(e -> isFluidOnly ? GadgetDestruction.isFluidBlock(world, e) : GadgetDestruction.isValidBlock(world, e, player, world.method_8320(e))).sorted(Comparator.comparing(arg_0 -> ((class_2338)player.method_24515()).method_10262(arg_0))).collect(Collectors.toList());
    }

    public static boolean isFluidBlock(class_1937 world, class_2338 pos) {
        if (world.method_8316(pos).method_15769()) {
            return false;
        }
        return FluidRenderHandlerRegistryImpl.INSTANCE.get(world.method_8316(pos).method_15772()) != null;
    }

    public static boolean isValidBlock(class_1937 world, class_2338 voidPos, class_1657 player, class_2680 currentBlock) {
        if (world.method_22347(voidPos) || currentBlock.equals(OurBlocks.EFFECT_BLOCK.method_9564()) || currentBlock.method_26214((class_1922)world, voidPos) < 0.0f || !world.method_8505(player, voidPos)) {
            return false;
        }
        class_2586 be = world.method_8321(voidPos);
        return be == null;
    }

    public void clearArea(class_1937 world, class_2338 pos, class_2350 side, class_3222 player, class_1799 stack) {
        List<class_2338> positions = GadgetDestruction.getArea(world, pos, side, (class_1657)player, stack);
        Undo.Builder builder = Undo.builder();
        for (class_2338 clearPos : positions) {
            class_2680 state = world.method_8320(clearPos);
            class_2586 be = world.method_8321(clearPos);
            if (!this.isAllowedBlock(state.method_26204()) || be != null || !GadgetDestruction.mayInteract(player, clearPos)) continue;
            this.destroyBlock(world, clearPos, player, builder);
        }
        this.pushUndo(stack, builder.build(world), world);
    }

    private void destroyBlock(class_1937 world, class_2338 voidPos, class_3222 player, Undo.Builder builder) {
        if (world.method_22347(voidPos)) {
            return;
        }
        class_1799 tool = GadgetDestruction.getGadget((class_1657)player);
        if (tool.method_7960()) {
            return;
        }
        if (!this.canUse(tool, (class_1657)player)) {
            return;
        }
        if (this.useEnergy(tool, player)) {
            builder.record((class_1922)world, voidPos, BlockData.AIR, (Multiset<ItemVariant>)ImmutableMultiset.of(), (Multiset<ItemVariant>)ImmutableMultiset.of());
            EffectBlock.spawnEffectBlock((class_1936)world, voidPos, TileSupport.createBlockData((class_1922)world, voidPos), EffectBlock.Mode.REMOVE);
        }
    }

    public static class_1799 getGadget(class_1657 player) {
        class_1799 stack = AbstractGadget.getGadget(player);
        if (!(stack.method_7909() instanceof GadgetDestruction)) {
            return class_1799.field_8037;
        }
        return stack;
    }
}

