/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.BuildingModes;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.network.S2C.LookupResult;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class GadgetBuilding
extends AbstractGadget {
    private static final MockBuilderWorld fakeWorld = new MockBuilderWorld();

    public GadgetBuilding(class_1792.class_1793 builder) {
        super(builder, Reference.TagReference.WHITELIST_BUILDING, Reference.TagReference.BLACKLIST_BUILDING);
    }

    @Override
    public long getEnergyCapacity() {
        return BuildingGadgets.getConfig().gadgets.gadgetBuilding.maxEnergy;
    }

    @Override
    public long getEnergyCost(class_1799 tool) {
        return BuildingGadgets.getConfig().gadgets.gadgetBuilding.energyCost;
    }

    public boolean placeAtop(class_1799 stack) {
        return GadgetBuilding.shouldPlaceAtop(stack);
    }

    private static void setToolMode(class_1799 tool, BuildingModes mode) {
        class_2487 tagCompound = tool.method_7948();
        tagCompound.method_10582("mode", mode.toString());
        tool.method_7980(tagCompound);
    }

    public static BuildingModes getToolMode(class_1799 tool) {
        class_2487 tagCompound = tool.method_7948();
        return BuildingModes.getFromName(tagCompound.method_10558("mode"));
    }

    public static boolean shouldPlaceAtop(class_1799 stack) {
        return !stack.method_7948().method_10577("start_inside");
    }

    public static void togglePlaceAtop(class_1657 player, class_1799 stack) {
        stack.method_7948().method_10556("start_inside", GadgetBuilding.shouldPlaceAtop(stack));
        player.method_7353((class_2561)(GadgetBuilding.shouldPlaceAtop(stack) ? MessageTranslation.PLACE_ATOP : MessageTranslation.PLACE_INSIDE).componentTranslation(new Object[0]).method_10862(Styles.AQUA), true);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, world, tooltip, flag);
        BuildingModes mode = GadgetBuilding.getToolMode(stack);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add((class_2561)TooltipTranslation.GADGET_MODE.componentTranslation(mode == BuildingModes.SURFACE && GadgetBuilding.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.format(new class_2588(mode.getTranslationKey()).getString()) : new class_2588(mode.getTranslationKey())).method_10862(Styles.AQUA));
        tooltip.add((class_2561)TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).method_10862(Styles.DK_GREEN));
        int range = GadgetUtils.getToolRange(stack);
        if (GadgetBuilding.getToolMode(stack) != BuildingModes.BUILD_TO_ME) {
            tooltip.add((class_2561)TooltipTranslation.GADGET_RANGE.componentTranslation(range, GadgetBuilding.getRangeInBlocks(range, mode.getMode())).method_10862(Styles.LT_PURPLE));
        }
        if (GadgetBuilding.getToolMode(stack) == BuildingModes.SURFACE) {
            tooltip.add((class_2561)TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetBuilding.getFuzzy(stack))).method_10862(Styles.GOLD));
        }
        GadgetBuilding.addInformationRayTraceFluid(tooltip, stack);
        tooltip.add((class_2561)TooltipTranslation.GADGET_BUILDING_PLACE_ATOP.componentTranslation(String.valueOf(GadgetBuilding.shouldPlaceAtop(stack))).method_10862(Styles.YELLOW));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_3965 posLookingAt = VectorHelper.getLookingAt(player, itemstack);
        player.method_6019(hand);
        if (!world.field_9236) {
            boolean lookingAtInventory;
            boolean bl = lookingAtInventory = ItemStorage.SIDED.find(world, posLookingAt.method_17777(), (Object)posLookingAt.method_17780()) != null;
            if (player.method_5715()) {
                if (lookingAtInventory) {
                    LookupResult.sendToClient((class_3222)player, lookingAtInventory);
                    return class_1271.method_22430((Object)itemstack);
                }
                class_1271<class_2248> result = GadgetUtils.selectBlock(itemstack, player);
                if (!result.method_5467().method_23665()) {
                    player.method_7353((class_2561)MessageTranslation.INVALID_BLOCK.componentTranslation(((class_2248)result.method_5466()).method_9518()).method_10862(Styles.AQUA), true);
                    return super.method_7836(world, player, hand);
                }
            } else if (player instanceof class_3222) {
                this.build((class_3222)player, itemstack);
            }
        } else if (!player.method_5715()) {
            BaseRenderer.updateInventoryCache();
        }
        return new class_1271(class_1269.field_5812, (Object)itemstack);
    }

    public void setMode(class_1799 heldItem, int modeInt) {
        BuildingModes mode = BuildingModes.values()[modeInt];
        GadgetBuilding.setToolMode(heldItem, mode);
    }

    public static void rangeChange(class_1657 player, class_1799 heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetBuilding.getToolMode(heldItem) != BuildingModes.SURFACE || range % 2 == 0 ? 1 : 2;
        range = player.method_5715() ? (range == 1 ? BuildingGadgets.getConfig().gadgets.maxRange : range - changeAmount) : (range >= BuildingGadgets.getConfig().gadgets.maxRange ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.method_7353((class_2561)MessageTranslation.RANGE_SET.componentTranslation(range).method_10862(Styles.AQUA), true);
    }

    private void build(class_3222 player, class_1799 stack) {
        class_1937 world = player.field_6002;
        class_1799 heldItem = GadgetBuilding.getGadget((class_1657)player);
        if (heldItem.method_7960()) {
            return;
        }
        List<class_2338> coords = GadgetUtils.getAnchor(heldItem).orElse(new ArrayList());
        BlockData blockData = GadgetUtils.getToolBlock(heldItem);
        if (blockData.getState() == class_2246.field_10124.method_9564()) {
            return;
        }
        if (coords.size() == 0) {
            class_3965 lookingAt = VectorHelper.getLookingAt((class_1657)player, stack);
            if (world.method_22347(lookingAt.method_17777())) {
                return;
            }
            class_2350 sideHit = lookingAt.method_17780();
            coords = GadgetBuilding.getToolMode(stack).getMode().getCollection(new AbstractMode.UseContext(world, blockData.getState(), lookingAt.method_17777(), heldItem, sideHit, this.placeAtop(stack), GadgetBuilding.getConnectedArea(stack)), (class_1657)player);
        } else {
            GadgetUtils.setAnchor(stack);
        }
        Undo.Builder builder = Undo.builder();
        IItemIndex index = InventoryHelper.index(stack, (class_1657)player);
        fakeWorld.setWorldAndState(player.field_6002, blockData.getState(), (Collection<class_2338>)coords);
        for (class_2338 coordinate : coords) {
            this.placeBlock(world, player, index, builder, coordinate, blockData);
        }
        this.pushUndo(stack, builder.build(world), world);
    }

    private void placeBlock(class_1937 world, class_3222 player, IItemIndex index, Undo.Builder builder, class_2338 pos, BlockData setBlock) {
        if (pos.method_10264() > world.method_31600() || pos.method_10264() < world.method_31607() || !player.method_7294()) {
            return;
        }
        class_1799 heldItem = GadgetBuilding.getGadget((class_1657)player);
        if (heldItem.method_7960()) {
            return;
        }
        BuildContext buildContext = new BuildContext((class_1936)world, (class_1657)player, heldItem);
        MaterialList requiredItems = setBlock.getRequiredItems(buildContext, null, pos);
        try (Transaction transaction = Transaction.openOuter();){
            MatchResult match = index.match(requiredItems, (TransactionContext)transaction);
            if (!match.isSuccess()) {
                return;
            }
            if (!GadgetBuilding.mayInteract(player, pos)) {
                return;
            }
            if (this.useEnergy(heldItem, player)) {
                ImmutableMultiset<ItemVariant> usedItems = match.getChosenOption();
                builder.record((class_1922)world, pos, setBlock, (Multiset<ItemVariant>)usedItems, (Multiset<ItemVariant>)ImmutableMultiset.of());
                EffectBlock.spawnEffectBlock((class_1936)world, pos, setBlock, EffectBlock.Mode.PLACE);
                transaction.commit();
            }
        }
    }

    public static class_1799 getGadget(class_1657 player) {
        class_1799 stack = AbstractGadget.getGadget(player);
        if (!(stack.method_7909() instanceof GadgetBuilding)) {
            return class_1799.field_8037;
        }
        return stack;
    }

    @Override
    public boolean performRotate(class_1799 stack, class_1657 player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.ROTATE);
        return true;
    }

    @Override
    public boolean performMirror(class_1799 stack, class_1657 player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.MIRROR);
        return true;
    }
}

